/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonPermitExpirableSemaphore
extends RedissonExpirable
implements RPermitExpirableSemaphore {
    private final SemaphorePubSub semaphorePubSub;
    final CommandAsyncExecutor commandExecutor;
    private final String timeoutName;
    private final long nonExpirableTimeout = 922337203685477L;

    public RedissonPermitExpirableSemaphore(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.timeoutName = RedissonPermitExpirableSemaphore.suffixName(name, "timeout");
        this.commandExecutor = commandExecutor;
        this.semaphorePubSub = commandExecutor.getConnectionManager().getSubscribeService().getSemaphorePubSub();
    }

    String getChannelName() {
        return RedissonPermitExpirableSemaphore.getChannelName(this.getRawName());
    }

    public static String getChannelName(String name) {
        if (name.contains("{")) {
            return "redisson_sc:" + name;
        }
        return "redisson_sc:{" + name + "}";
    }

    @Override
    public String acquire() throws InterruptedException {
        return this.acquire(1, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String acquire(long leaseTime, TimeUnit timeUnit) throws InterruptedException {
        return this.acquire(1, leaseTime, timeUnit);
    }

    @Override
    public RFuture<String> acquireAsync(long leaseTime, TimeUnit timeUnit) {
        return this.acquireAsync(1, leaseTime, timeUnit);
    }

    private String acquire(int permits, long ttl, TimeUnit timeUnit) throws InterruptedException {
        String permitId = this.tryAcquire(permits, ttl, timeUnit);
        if (permitId != null && !permitId.startsWith(":")) {
            return permitId;
        }
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        this.semaphorePubSub.timeout((CompletableFuture)future);
        RedissonLockEntry entry = this.commandExecutor.getInterrupted(future);
        try {
            while (true) {
                Long nearestTimeout;
                if ((permitId = this.tryAcquire(permits, ttl, timeUnit)) != null) {
                    if (!permitId.startsWith(":")) {
                        String string = permitId;
                        return string;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                if (nearestTimeout != null) {
                    entry.getLatch().tryAcquire(permits, nearestTimeout, TimeUnit.MILLISECONDS);
                    continue;
                }
                entry.getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    @Override
    public RFuture<String> acquireAsync() {
        return this.acquireAsync(1, -1L, TimeUnit.MILLISECONDS);
    }

    private RFuture<String> acquireAsync(int permits, long ttl, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        CompletionStage f = tryAcquireFuture.thenCompose(permitId -> {
            if (permitId != null && !permitId.startsWith(":")) {
                return CompletableFuture.completedFuture(permitId);
            }
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            this.semaphorePubSub.timeout((CompletableFuture)subscribeFuture);
            return subscribeFuture.thenCompose(res -> this.acquireAsync(permits, (RedissonLockEntry)res, ttl, timeUnit));
        });
        f.whenComplete((r, e) -> {
            if (f.toCompletableFuture().isCancelled()) {
                tryAcquireFuture.whenComplete((permitId, ex) -> {
                    if (permitId != null && !permitId.startsWith(":")) {
                        this.releaseAsync((String)permitId);
                    }
                });
            }
        });
        return new CompletableFutureWrapper<String>(f);
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RedissonLockEntry entry, final CompletableFuture<String> result, final long ttl, final TimeUnit timeUnit) {
        if (result.isDone()) {
            this.unsubscribe(entry);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry);
            result.complete(null);
            return;
        }
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        long curr = System.currentTimeMillis();
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.whenComplete((permitId, e) -> {
            Long nearestTimeout;
            if (e != null) {
                this.unsubscribe(entry);
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (permitId != null) {
                if (!permitId.startsWith(":")) {
                    this.unsubscribe(entry);
                    if (!result.complete((String)permitId)) {
                        this.releaseAsync((String)permitId);
                    }
                    return;
                }
                nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
            } else {
                nearestTimeout = null;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry);
                result.complete(null);
                return;
            }
            final long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryAcquireAsync(time, permits, entry, result, ttl, timeUnit);
            } else {
                final AtomicReference<Timeout> waitTimeoutFutureRef = new AtomicReference<Timeout>();
                final Timeout scheduledFuture = nearestTimeout != null ? this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                            return;
                        }
                        long elapsed = System.currentTimeMillis() - current;
                        time.addAndGet(-elapsed);
                        RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, entry, result, ttl, timeUnit);
                    }
                }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
                final Runnable listener = () -> {
                    if (waitTimeoutFutureRef.get() != null && !((Timeout)waitTimeoutFutureRef.get()).cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    if (scheduledFuture != null && !scheduledFuture.cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryAcquireAsync(time, permits, entry, result, ttl, timeUnit);
                };
                entry.addListener(listener);
                long t = time.get();
                Timeout waitTimeoutFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (scheduledFuture != null && !scheduledFuture.cancel()) {
                            return;
                        }
                        if (entry.removeListener(listener)) {
                            long elapsed = System.currentTimeMillis() - current;
                            time.addAndGet(-elapsed);
                            RedissonPermitExpirableSemaphore.this.tryAcquireAsync(time, permits, entry, result, ttl, timeUnit);
                        }
                    }
                }, t, TimeUnit.MILLISECONDS);
                waitTimeoutFutureRef.set(waitTimeoutFuture);
            }
        });
    }

    private CompletableFuture<String> acquireAsync(int permits, RedissonLockEntry entry, long ttl, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        CompletableFuture tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate).toCompletableFuture();
        return ((CompletableFuture)tryAcquireFuture.whenComplete((p, e) -> {
            if (e != null) {
                this.unsubscribe(entry);
            }
        })).thenCompose(permitId -> {
            Long nearestTimeout;
            if (permitId != null) {
                if (!permitId.startsWith(":")) {
                    this.unsubscribe(entry);
                    return CompletableFuture.completedFuture(permitId);
                }
                nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
            } else {
                nearestTimeout = null;
            }
            if (entry.getLatch().tryAcquire(permits)) {
                return this.acquireAsync(permits, entry, ttl, timeUnit);
            }
            CompletableFuture res = new CompletableFuture();
            Timeout scheduledFuture = nearestTimeout != null ? this.commandExecutor.getConnectionManager().newTimeout(timeout -> {
                CompletableFuture<String> r = this.acquireAsync(permits, entry, ttl, timeUnit);
                this.commandExecutor.transfer(r, res);
            }, nearestTimeout, TimeUnit.MILLISECONDS) : null;
            Runnable listener = () -> {
                if (scheduledFuture != null && !scheduledFuture.cancel()) {
                    entry.getLatch().release();
                    return;
                }
                CompletableFuture<String> r = this.acquireAsync(permits, entry, ttl, timeUnit);
                this.commandExecutor.transfer(r, res);
            };
            entry.addListener(listener);
            return res;
        });
    }

    @Override
    public String tryAcquire() {
        String res = this.tryAcquire(1, -1L, TimeUnit.MILLISECONDS);
        if (res != null && res.startsWith(":")) {
            return null;
        }
        return res;
    }

    private String tryAcquire(int permits, long ttl, TimeUnit timeUnit) {
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        return this.get(this.tryAcquireAsync(permits, timeoutDate));
    }

    private long calcTimeout(long ttl, TimeUnit timeUnit) {
        if (ttl != -1L) {
            return System.currentTimeMillis() + timeUnit.toMillis(ttl);
        }
        return 922337203685477L;
    }

    @Override
    public RFuture<String> tryAcquireAsync() {
        CompletableFuture future = this.tryAcquireAsync(1, 922337203685477L).toCompletableFuture();
        CompletionStage f = future.thenApply(permitId -> {
            if (permitId != null && !permitId.startsWith(":")) {
                return permitId;
            }
            return null;
        });
        future.whenComplete((arg_0, arg_1) -> this.lambda$tryAcquireAsync$11((CompletableFuture)f, arg_0, arg_1));
        return new CompletableFutureWrapper<String>((CompletableFuture<String>)f);
    }

    protected byte[] generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return id;
    }

    private RFuture<String> tryAcquireAsync(int permits, long timeoutDate) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        byte[] id = this.generateId();
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_PERMIT_DATA, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[4], 'limit', 0, ARGV[1]); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call('publish', KEYS[3], value); end;end; local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then redis.call('decrby', KEYS[1], ARGV[1]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[3]); local ttl = redis.call('pttl', KEYS[1]); if ttl > 0 then redis.call('pexpire', KEYS[2], ttl); end; return ARGV[3]; end; local v = redis.call('zrange', KEYS[2], 0, 0, 'WITHSCORES'); if v[1] ~= nil and v[2] ~= ARGV[5] then return ':' .. tostring(v[2]); end return nil;", Arrays.asList(this.getRawName(), this.timeoutName, this.getChannelName()), permits, timeoutDate, id, System.currentTimeMillis(), 922337203685477L);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, -1L, unit);
    }

    @Override
    public String tryAcquire(long waitTime, long ttl, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, waitTime, ttl, unit);
    }

    @Override
    public RFuture<String> tryAcquireAsync(long waitTime, long ttl, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, ttl, unit);
    }

    private String tryAcquire(int permits, long waitTime, long ttl, TimeUnit unit) throws InterruptedException {
        RedissonLockEntry entry;
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        String permitId = this.tryAcquire(permits, ttl, unit);
        if (permitId != null && !permitId.startsWith(":")) {
            return permitId;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            return null;
        }
        current = System.currentTimeMillis();
        CompletableFuture<RedissonLockEntry> future = this.subscribe();
        try {
            entry = future.get(time, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            return null;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                String e = null;
                return e;
            }
            while (true) {
                Long nearestTimeout;
                current = System.currentTimeMillis();
                permitId = this.tryAcquire(permits, ttl, unit);
                if (permitId != null) {
                    if (!permitId.startsWith(":")) {
                        String string = permitId;
                        return string;
                    }
                    nearestTimeout = Long.valueOf(permitId.substring(1)) - System.currentTimeMillis();
                } else {
                    nearestTimeout = null;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    String string = null;
                    return string;
                }
                current = System.currentTimeMillis();
                if (nearestTimeout != null) {
                    entry.getLatch().tryAcquire(permits, Math.min(time, nearestTimeout), TimeUnit.MILLISECONDS);
                } else {
                    entry.getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                if ((time -= elapsed) > 0L) continue;
                String string = null;
                return string;
            }
        }
        finally {
            this.unsubscribe(entry);
        }
    }

    private RFuture<String> tryAcquireAsync(int permits, long waitTime, long ttl, TimeUnit timeUnit) {
        final CompletableFuture result = new CompletableFuture();
        AtomicLong time = new AtomicLong(timeUnit.toMillis(waitTime));
        long curr = System.currentTimeMillis();
        long timeoutDate = this.calcTimeout(ttl, timeUnit);
        RFuture<String> tryAcquireFuture = this.tryAcquireAsync(permits, timeoutDate);
        tryAcquireFuture.whenComplete((permitId, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (permitId != null && !permitId.startsWith(":")) {
                if (!result.complete(permitId)) {
                    this.releaseAsync((String)permitId);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                result.complete(null);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryAcquireAsync(time, permits, (RedissonLockEntry)r, result, ttl, timeUnit);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            result.complete(null);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return new CompletableFutureWrapper<String>(result);
    }

    private CompletableFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getRawName(), this.getChannelName());
    }

    private void unsubscribe(RedissonLockEntry entry) {
        this.semaphorePubSub.unsubscribe(entry, this.getRawName(), this.getChannelName());
    }

    @Override
    public String tryAcquire(long waitTime, TimeUnit unit) throws InterruptedException {
        String res = this.tryAcquire(1, waitTime, -1L, unit);
        if (res != null && res.startsWith(":")) {
            return null;
        }
        return res;
    }

    @Override
    public void release(String permitId) {
        this.get(this.releaseAsync(permitId));
    }

    @Override
    public boolean tryRelease(String permitId) {
        return this.get(this.tryReleaseAsync(permitId));
    }

    @Override
    public RFuture<Boolean> tryReleaseAsync(String permitId) {
        if (permitId == null) {
            throw new IllegalArgumentException("permitId can't be null");
        }
        byte[] id = ByteBufUtil.decodeHexDump(permitId);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expire = redis.call('zscore', KEYS[3], ARGV[1]);local removed = redis.call('zrem', KEYS[3], ARGV[1]);if tonumber(removed) ~= 1 then return 0;end;local value = redis.call('incrby', KEYS[1], ARGV[2]); redis.call('publish', KEYS[2], value); if tonumber(expire) <= tonumber(ARGV[3]) then return 0;end;return 1;", Arrays.asList(this.getRawName(), this.getChannelName(), this.timeoutName), id, 1, System.currentTimeMillis());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.timeoutName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.timeoutName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.timeoutName);
    }

    @Override
    public RFuture<Void> releaseAsync(String permitId) {
        CompletionStage<Void> f = this.tryReleaseAsync(permitId).handle((res, e) -> {
            if (e != null) {
                throw new CompletionException((Throwable)e);
            }
            if (res.booleanValue()) {
                return null;
            }
            throw new CompletionException(new IllegalArgumentException("Permit with id " + permitId + " has already been released or doesn't exist"));
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public int availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Integer> availablePermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[1], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call('publish', KEYS[3], value); end;return value; end; local ret = redis.call('get', KEYS[1]); return ret == false and 0 or ret;", Arrays.asList(this.getRawName(), this.timeoutName, this.getChannelName()), System.currentTimeMillis());
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.getChannelName()), permits);
    }

    @Override
    public void addPermits(int permits) {
        this.get(this.addPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> addPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], tonumber(value) + tonumber(ARGV[1])); if tonumber(ARGV[1]) > 0 then redis.call('publish', KEYS[2], ARGV[1]); end;", Arrays.asList(this.getRawName(), this.getChannelName()), permits);
    }

    @Override
    public RFuture<Boolean> updateLeaseTimeAsync(String permitId, long leaseTime, TimeUnit unit) {
        long timeoutDate = this.calcTimeout(leaseTime, unit);
        byte[] id = ByteBufUtil.decodeHexDump(permitId);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local expiredIds = redis.call('zrangebyscore', KEYS[2], 0, ARGV[3], 'limit', 0, -1); if #expiredIds > 0 then redis.call('zrem', KEYS[2], unpack(expiredIds)); local value = redis.call('incrby', KEYS[1], #expiredIds); if tonumber(value) > 0 then redis.call('publish', KEYS[3], value); end;end; local value = redis.call('zscore', KEYS[2], ARGV[1]); if (value ~= false) then redis.call('zadd', KEYS[2], ARGV[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getRawName(), this.timeoutName, this.getChannelName()), id, timeoutDate, System.currentTimeMillis());
    }

    @Override
    public boolean updateLeaseTime(String permitId, long leaseTime, TimeUnit unit) {
        return this.get(this.updateLeaseTimeAsync(permitId, leaseTime, unit));
    }

    private /* synthetic */ void lambda$tryAcquireAsync$11(CompletableFuture f, String permitId, Throwable e) {
        if (f.isCancelled() && permitId != null && !permitId.startsWith(":")) {
            this.releaseAsync(permitId);
        }
    }
}

