/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.time.ZoneId;
import org.redisson.executor.CronExpression;
import org.redisson.executor.CronExpressionEx;

public final class CronSchedule {
    private final CronExpression expression;
    private final ZoneId zoneId;

    CronSchedule(CronExpression expression, ZoneId zoneId) {
        this.expression = expression;
        this.zoneId = zoneId;
    }

    public static CronSchedule of(String expression) {
        return new CronSchedule(new CronExpressionEx(expression), ZoneId.systemDefault());
    }

    public static CronSchedule of(String expression, ZoneId zoneId) {
        return new CronSchedule(new CronExpressionEx(expression), zoneId);
    }

    public static CronSchedule dailyAtHourAndMinute(int hour, int minute) {
        String expression = String.format("0 %d %d ? * *", minute, hour);
        return CronSchedule.of(expression);
    }

    public static CronSchedule dailyAtHourAndMinute(int hour, int minute, ZoneId zoneId) {
        String expression = String.format("0 %d %d ? * *", minute, hour);
        return CronSchedule.of(expression, zoneId);
    }

    public static CronSchedule weeklyOnDayAndHourAndMinute(int hour, int minute, Integer ... daysOfWeek) {
        if (daysOfWeek == null || daysOfWeek.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        String expression = String.format("0 %d %d ? * %d", minute, hour, daysOfWeek[0]);
        for (int i = 1; i < daysOfWeek.length; ++i) {
            expression = expression + "," + daysOfWeek[i];
        }
        return CronSchedule.of(expression);
    }

    public static CronSchedule weeklyOnDayAndHourAndMinute(int hour, int minute, ZoneId zoneId, Integer ... daysOfWeek) {
        if (daysOfWeek == null || daysOfWeek.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        String expression = String.format("0 %d %d ? * %d", minute, hour, daysOfWeek[0]);
        for (int i = 1; i < daysOfWeek.length; ++i) {
            expression = expression + "," + daysOfWeek[i];
        }
        return CronSchedule.of(expression, zoneId);
    }

    public static CronSchedule monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute) {
        String expression = String.format("0 %d %d %d * ?", minute, hour, dayOfMonth);
        return CronSchedule.of(expression);
    }

    public static CronSchedule monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute, ZoneId zoneId) {
        String expression = String.format("0 %d %d %d * ?", minute, hour, dayOfMonth);
        return CronSchedule.of(expression, zoneId);
    }

    public CronExpression getExpression() {
        return this.expression;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }
}

