/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.resolver.AddressResolver;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RedisURI> sentinelHosts = new HashSet<RedisURI>();
    private final ConcurrentMap<RedisURI, RedisClient> sentinels = new ConcurrentHashMap<RedisURI, RedisClient>();
    private final AtomicReference<RedisURI> currentMaster = new AtomicReference();
    private final Set<RedisURI> disconnectedSlaves = new HashSet<RedisURI>();
    private ScheduledFuture<?> monitorFuture;
    private AddressResolver<InetSocketAddress> sentinelResolver;
    private final RedisStrictCommand<RedisURI> masterHostCommand;
    private boolean usePassword = false;
    private String scheme;
    private final SentinelServersConfig cfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config, UUID id) {
        super(config, id);
        if (cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        if (cfg.getSentinelAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel node should be defined!");
        }
        this.config = this.create(cfg);
        this.cfg = cfg;
        this.initTimer(this.config);
        this.sentinelResolver = this.resolverGroup.getResolver(this.getGroup().next());
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            this.scheme = addr.getScheme();
            if (NetUtil.createByteArrayFromIpAddressString((addr = this.applyNatMap(addr)).getHost()) != null || addr.getHost().equals("localhost")) continue;
            this.sentinelHosts.add(addr);
        }
        this.checkAuth(cfg);
        this.masterHostCommand = "redis".equals(this.scheme) ? RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME : RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME_SSL;
        Throwable lastException = null;
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisURI uri;
                RedisConnection connection = null;
                try {
                    connection = client.connect();
                    if (!connection.isActive()) continue;
                }
                catch (RedisConnectionException e) {}
                continue;
                RedisURI master = connection.sync(this.masterHostCommand, cfg.getMasterName());
                if (master == null) {
                    throw new RedisConnectionException("Master node is undefined! SENTINEL GET-MASTER-ADDR-BY-NAME command returns empty result!");
                }
                RedisURI masterHost = this.resolveIP(this.scheme, master).join();
                this.config.setMasterAddress(masterHost.toString());
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String host = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = map.getOrDefault("flags", "");
                    String masterLinkStatus = map.getOrDefault("master-link-status", "");
                    uri = this.resolveIP(host, port).join();
                    this.config.addSlaveAddress(uri.toString());
                    this.log.debug("slave {} state: {}", (Object)uri, (Object)map);
                    this.log.info("slave: {} added", (Object)uri);
                    if (!this.isSlaveDown(flags, masterLinkStatus)) continue;
                    this.disconnectedSlaves.add(uri);
                    this.log.warn("slave: {} is down", (Object)uri);
                }
                List sentinelSentinels = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
                ArrayList<CompletableFuture<Void>> connectionFutures = new ArrayList<CompletableFuture<Void>>(sentinelSentinels.size());
                for (Map map : sentinelSentinels) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String port = (String)map.get("port");
                    uri = this.resolveIP(ip, port).join();
                    CompletionStage<Void> future = this.registerSentinel(uri, this.config, null);
                    connectionFutures.add(future.toCompletableFuture());
                }
                RedisURI sentinelIp = this.toURI(connection.getRedisClient().getAddr());
                CompletionStage<Void> f = this.registerSentinel(sentinelIp, this.config, null);
                connectionFutures.add(f.toCompletableFuture());
                CompletableFuture<Void> future = CompletableFuture.allOf(connectionFutures.toArray(new CompletableFuture[0]));
                try {
                    future.get(this.config.getConnectTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.stopThreads();
                throw e;
            }
            catch (Exception e) {
                if (e instanceof CompletionException) {
                    e = (Exception)e.getCause();
                }
                lastException = e;
                this.log.warn(e.getMessage());
            }
            finally {
                client.shutdownAsync();
            }
        }
        if (cfg.isCheckSentinelsList() && cfg.isSentinelsDiscovery()) {
            if (this.sentinels.isEmpty()) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns empty result or connection can't be established to some of them! Set checkSentinelsList = false to avoid this check.", lastException);
            }
            if (this.sentinels.size() < 2) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns less than 2 nodes or connection can't be established to some of them! At least two sentinels should be defined in Redis configuration. Set checkSentinelsList = false to avoid this check.", lastException);
            }
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!", lastException);
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found!");
        }
        this.initSingleEntry();
        this.scheduleChangeCheck(cfg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuth(SentinelServersConfig cfg) {
        if (cfg.getPassword() == null) {
            return;
        }
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection c = client.connect();
                if (this.config.getPingConnectionInterval() == 0) {
                    c.sync(RedisCommands.PING, new Object[0]);
                }
                return;
            }
            catch (RedisAuthRequiredException e) {
                this.usePassword = true;
                return;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server", e);
            }
            catch (Exception exception) {}
            continue;
            finally {
                client.shutdown();
            }
        }
        this.stopThreads();
        StringBuilder list = new StringBuilder();
        for (String address : cfg.getSentinelAddresses()) {
            list.append(address).append(", ");
        }
        throw new RedisConnectionException("Unable to connect to Redis sentinel servers: " + list);
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() == -1L || this.sentinelHosts.isEmpty()) {
            return;
        }
        this.scheduleSentinelDNSCheck();
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        if (type == NodeType.SENTINEL && !this.usePassword) {
            result.setUsername(null);
            result.setPassword(null);
        } else if (type == NodeType.SENTINEL && this.usePassword) {
            result.setUsername(this.cfg.getSentinelUsername());
            if (this.cfg.getSentinelPassword() != null) {
                result.setPassword(this.cfg.getSentinelPassword());
            }
        }
        return result;
    }

    private void scheduleSentinelDNSCheck() {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicInteger sentinelsCounter = new AtomicInteger(SentinelConnectionManager.this.sentinelHosts.size());
                SentinelConnectionManager.this.performSentinelDNSCheck(future -> {
                    if (sentinelsCounter.decrementAndGet() == 0) {
                        SentinelConnectionManager.this.scheduleSentinelDNSCheck();
                    }
                });
            }
        }, this.config.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    private void performSentinelDNSCheck(FutureListener<List<InetSocketAddress>> commonListener) {
        for (RedisURI host : this.sentinelHosts) {
            Future<List<InetSocketAddress>> allNodes = this.sentinelResolver.resolveAll(InetSocketAddress.createUnresolved(host.getHost(), host.getPort()));
            allNodes.addListener(future -> {
                if (!future.isSuccess()) {
                    this.log.error("Unable to resolve " + host.getHost(), future.cause());
                    return;
                }
                ((List)future.getNow()).stream().map(addr -> this.toURI((InetSocketAddress)addr)).filter(uri -> !this.sentinels.containsKey(uri)).forEach(uri -> this.registerSentinel((RedisURI)uri, this.getConfig(), host.getHost()));
            });
            if (commonListener == null) continue;
            allNodes.addListener(commonListener);
        }
    }

    private void scheduleChangeCheck(final SentinelServersConfig cfg, final Iterator<RedisClient> iterator) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicReference lastException = new AtomicReference();
                Iterator iter = iterator;
                if (iter == null) {
                    ArrayList clients = new ArrayList(SentinelConnectionManager.this.sentinels.values());
                    Collections.shuffle(clients);
                    iter = clients.iterator();
                }
                SentinelConnectionManager.this.checkState(cfg, iter, lastException);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkState(SentinelServersConfig cfg, Iterator<RedisClient> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.performSentinelDNSCheck(null);
            this.scheduleChangeCheck(cfg, null);
            return;
        }
        if (!this.getShutdownLatch().acquire()) {
            return;
        }
        RedisClient client = iterator.next();
        RedisURI addr = this.toURI(client.getAddr());
        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(NodeType.SENTINEL, cfg, addr, null);
        connectionFuture.whenComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkState(cfg, iterator, lastException);
                return;
            }
            this.updateState(cfg, (RedisConnection)connection, iterator);
        });
    }

    private void updateState(SentinelServersConfig cfg, RedisConnection connection, Iterator<RedisClient> iterator) {
        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
        CompletionStage<RedisURI> masterFuture = this.checkMasterChange(cfg, connection);
        futures.add(masterFuture.toCompletableFuture());
        if (!this.config.checkSkipSlavesInit()) {
            CompletionStage<Void> slavesFuture = this.checkSlavesChange(cfg, connection);
            futures.add(slavesFuture.toCompletableFuture());
        }
        CompletionStage<Void> sentinelsFuture = this.checkSentinelsChange(cfg, connection);
        futures.add(sentinelsFuture.toCompletableFuture());
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        future.whenComplete((r, e) -> {
            if (e != null) {
                this.log.error("Can't execute SENTINEL commands on " + connection.getRedisClient().getAddr(), (Throwable)e);
            }
            this.getShutdownLatch().release();
            if (e != null) {
                this.scheduleChangeCheck(cfg, iterator);
            } else {
                this.scheduleChangeCheck(cfg, null);
            }
        });
    }

    private CompletionStage<Void> checkSentinelsChange(SentinelServersConfig cfg, RedisConnection connection) {
        if (!cfg.isSentinelsDiscovery()) {
            return CompletableFuture.completedFuture(null);
        }
        RFuture sentinelsFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
        return sentinelsFuture.thenCompose(list -> {
            if (list.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            List<CompletableFuture> newUris = list.stream().filter(m -> {
                String flags = m.getOrDefault("flags", "");
                String masterLinkStatus = m.getOrDefault("master-link-status", "");
                return !m.isEmpty() && !this.isSlaveDown(flags, masterLinkStatus);
            }).map(m -> {
                String ip = (String)m.get("ip");
                String port = (String)m.get("port");
                return this.toURI(this.scheme, ip, port);
            }).map(addr -> {
                CompletableFuture<RedisURI> f = this.resolveIP((RedisURI)addr);
                return f.exceptionally(ex -> {
                    this.log.error("unable to resolve hostname", (Throwable)ex);
                    return null;
                }).toCompletableFuture();
            }).collect(Collectors.toList());
            CompletableFuture<Void> futures = CompletableFuture.allOf(newUris.toArray(new CompletableFuture[0]));
            return futures.whenComplete((r, ex) -> {
                List<RedisURI> uris = newUris.stream().map(u -> {
                    try {
                        return u.getNow(null);
                    }
                    catch (Exception exc) {
                        return null;
                    }
                }).filter(u -> u != null).collect(Collectors.toList());
                InetSocketAddress addr = connection.getRedisClient().getAddr();
                RedisURI currentAddr = this.toURI(addr);
                uris.add(currentAddr);
                this.updateSentinels(uris);
            });
        });
    }

    private CompletionStage<Void> checkSlavesChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture slavesFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
        return slavesFuture.thenCompose(slavesMap -> {
            Set currentSlaves = Collections.newSetFromMap(new ConcurrentHashMap(slavesMap.size()));
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (Map map : slavesMap) {
                if (map.isEmpty()) continue;
                String host = (String)map.get("ip");
                String port = (String)map.get("port");
                String flags = map.getOrDefault("flags", "");
                String masterLinkStatus = map.getOrDefault("master-link-status", "");
                String masterHost = (String)map.get("master-host");
                String masterPort = (String)map.get("master-port");
                CompletableFuture<RedisURI> slaveAddrFuture = this.resolveIP(host, port);
                CompletableFuture<Object> masterAddrFuture = "?".equals(masterHost) ? CompletableFuture.completedFuture(null) : this.resolveIP(masterHost, masterPort);
                CompletableFuture<Void> resolvedFuture = CompletableFuture.allOf(masterAddrFuture, slaveAddrFuture);
                futures.add(((CompletableFuture)resolvedFuture.whenComplete((r, exc) -> {
                    if (exc != null) {
                        this.log.error("Unable to resolve addresses " + host + " and/or " + masterHost, (Throwable)exc);
                    }
                })).thenCompose(res -> {
                    RedisURI slaveAddr = slaveAddrFuture.getNow(null);
                    RedisURI masterAddr = masterAddrFuture.getNow(null);
                    if (this.isSlaveDown(flags, masterLinkStatus)) {
                        this.slaveDown(slaveAddr);
                        return CompletableFuture.completedFuture(res);
                    }
                    if ("?".equals(masterHost) || !this.isUseSameMaster(slaveAddr, masterAddr)) {
                        return CompletableFuture.completedFuture(res);
                    }
                    currentSlaves.add(slaveAddr);
                    return this.addSlave(slaveAddr).whenComplete((r, e) -> {
                        if (e != null) {
                            this.log.error("Unable to add slave " + slaveAddr, (Throwable)e);
                        }
                    });
                }));
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            return future.whenComplete((r, exc) -> {
                MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
                entry.getAllEntries().stream().map(e -> e.getClient().getAddr()).map(a -> this.toURI(this.scheme, a.getAddress().getHostAddress(), String.valueOf(a.getPort()))).filter(a -> !currentSlaves.contains(a) && !a.equals(this.currentMaster.get())).forEach(a -> this.slaveDown((RedisURI)a));
            });
        });
    }

    private CompletionStage<RedisURI> checkMasterChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture masterFuture = connection.async(StringCodec.INSTANCE, this.masterHostCommand, cfg.getMasterName());
        return masterFuture.thenCompose(u -> this.resolveIP(this.scheme, (RedisURI)u)).whenComplete((newMaster, e) -> {
            if (e != null) {
                return;
            }
            RedisURI current = this.currentMaster.get();
            if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, (RedisURI)newMaster)) {
                CompletableFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), (RedisURI)newMaster);
                changeFuture.exceptionally(ex -> {
                    this.currentMaster.compareAndSet((RedisURI)newMaster, current);
                    return null;
                });
            }
        });
    }

    private void updateSentinels(Collection<RedisURI> newUris) {
        newUris.stream().filter(uri -> !this.sentinels.containsKey(uri)).forEach(uri -> this.registerSentinel((RedisURI)uri, this.getConfig(), null));
        this.sentinels.keySet().stream().filter(uri -> !newUris.contains(uri)).forEach(uri -> {
            RedisClient sentinel = (RedisClient)this.sentinels.remove(uri);
            if (sentinel != null) {
                this.disconnectNode((RedisURI)uri);
                sentinel.shutdownAsync();
                this.log.warn("sentinel: {} is down", uri);
            }
        });
    }

    @Override
    protected Collection<RedisURI> getDisconnectedNodes() {
        return this.disconnectedSlaves;
    }

    private CompletionStage<Void> registerSentinel(RedisURI addr, MasterSlaveServersConfig c, String sslHostname) {
        RedisClient sentinel;
        boolean isHostname;
        boolean bl = isHostname = NetUtil.createByteArrayFromIpAddressString(addr.getHost()) == null;
        if (!isHostname && (sentinel = (RedisClient)this.sentinels.get(addr)) != null) {
            return CompletableFuture.completedFuture(null);
        }
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, c.getConnectTimeout(), c.getTimeout(), sslHostname);
        CompletableFuture<InetSocketAddress> future = client.resolveAddr();
        return future.thenCompose(res -> {
            RedisClient sentinel;
            RedisURI ipAddr = this.toURI(client.getAddr());
            if (isHostname && (sentinel = (RedisClient)this.sentinels.get(ipAddr)) != null) {
                return CompletableFuture.completedFuture(null);
            }
            RFuture<RedisConnection> f = client.connectAsync();
            return f.handle((resp, e) -> {
                if (e != null) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw new CompletionException((Throwable)e);
                }
                if (this.sentinels.putIfAbsent(ipAddr, client) == null) {
                    this.log.info("sentinel: {} added", (Object)ipAddr);
                }
                return null;
            });
        });
    }

    private CompletableFuture<RedisURI> resolveIP(String host, String port) {
        RedisURI uri = this.toURI(this.scheme, host, port);
        return this.resolveIP(uri);
    }

    private RedisURI toURI(InetSocketAddress addr) {
        return this.toURI(this.scheme, addr.getAddress().getHostAddress(), "" + addr.getPort());
    }

    private CompletableFuture<Void> addSlave(RedisURI uri) {
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(uri) && !this.config.checkSkipSlavesInit()) {
            CompletableFuture<Void> future = entry.addSlave(uri);
            return future.whenComplete((res, e) -> {
                if (e != null) {
                    this.log.error("Can't add slave: " + uri, (Throwable)e);
                    return;
                }
                if (entry.isSlaveUnfreezed(uri) || entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                    this.log.info("slave: {} added", (Object)uri);
                }
            });
        }
        if (entry.hasSlave(uri)) {
            this.slaveUp(uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void slaveDown(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.warn("slave: {} is down", (Object)uri);
        } else {
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {} is down", (Object)uri);
            }
        }
    }

    private boolean isSlaveDown(String flags, String masterLinkStatus) {
        boolean baseStatus;
        boolean bl = baseStatus = flags.contains("s_down") || flags.contains("disconnected");
        if (this.cfg.isCheckSlaveStatusWithSyncing() && !StringUtil.isNullOrEmpty(masterLinkStatus)) {
            return baseStatus || masterLinkStatus.contains("err");
        }
        return baseStatus;
    }

    private boolean isUseSameMaster(RedisURI slaveAddr, RedisURI slaveMasterAddr) {
        RedisURI master = this.currentMaster.get();
        if (!master.equals(slaveMasterAddr)) {
            this.log.warn("Skipped slave up {} for master {} differs from current {}", slaveAddr, slaveMasterAddr, master);
            return false;
        }
        return true;
    }

    private void slaveUp(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.info("slave: {} is up", (Object)uri);
            return;
        }
        if (this.getEntry(this.singleSlotRange.getStartSlot()).slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            this.log.info("slave: {} is up", (Object)uri);
        }
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((SentinelServersConfig)cfg).getDatabase());
        return res;
    }

    public Collection<RedisClient> getSentinels() {
        return this.sentinels.values();
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.sentinels.values().stream().map(s -> s.shutdownAsync()).forEach(f -> f.toCompletableFuture().join());
        super.shutdown();
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        RedisURI result = this.cfg.getNatMapper().map(address);
        if (!result.equals(address)) {
            this.log.debug("nat mapped uri: {} to {}", (Object)address, (Object)result);
        }
        return result;
    }
}

