/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.pubsub.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionWatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<ClientConnectionsEntry, List<Entry>> entries = new ConcurrentHashMap<ClientConnectionsEntry, List<Entry>>();
    private final ScheduledFuture<?> monitorFuture;

    public IdleConnectionWatcher(ConnectionManager manager, MasterSlaveServersConfig config) {
        this.monitorFuture = manager.getGroup().scheduleWithFixedDelay(() -> {
            long currTime = System.nanoTime();
            for (Entry entry : this.entries.values().stream().flatMap(m -> m.stream()).collect(Collectors.toList())) {
                if (!this.validateAmount(entry)) continue;
                for (final RedisConnection c : entry.connections) {
                    final long timeInPool = TimeUnit.NANOSECONDS.toMillis(currTime - c.getLastUsageTime());
                    if (c instanceof RedisPubSubConnection && (!((RedisPubSubConnection)c).getChannels().isEmpty() || !((RedisPubSubConnection)c).getPatternChannels().isEmpty()) || timeInPool <= (long)config.getIdleConnectionTimeout() || !this.validateAmount(entry) || !((Boolean)entry.deleteHandler.apply(c)).booleanValue()) continue;
                    ChannelFuture future = c.closeAsync();
                    future.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

                        @Override
                        public void operationComplete(Future<Void> future) throws Exception {
                            IdleConnectionWatcher.this.log.debug("Connection {} has been closed due to idle timeout. Not used for {} ms", (Object)c.getChannel(), (Object)timeInPool);
                        }
                    });
                }
            }
        }, config.getIdleConnectionTimeout(), config.getIdleConnectionTimeout(), TimeUnit.MILLISECONDS);
    }

    private boolean validateAmount(Entry entry) {
        return entry.maximumAmount - entry.freeConnectionsCounter.getCounter() + entry.connections.size() > entry.minimumAmount;
    }

    public void remove(ClientConnectionsEntry entry) {
        this.entries.remove(entry);
    }

    public void add(ClientConnectionsEntry entry, int minimumAmount, int maximumAmount, Collection<? extends RedisConnection> connections, AsyncSemaphore freeConnectionsCounter, Function<RedisConnection, Boolean> deleteHandler) {
        List list = this.entries.computeIfAbsent(entry, k -> new ArrayList(2));
        list.add(new Entry(minimumAmount, maximumAmount, connections, freeConnectionsCounter, deleteHandler));
    }

    public void stop() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
    }

    public static class Entry {
        private final int minimumAmount;
        private final int maximumAmount;
        private final AsyncSemaphore freeConnectionsCounter;
        private final Collection<? extends RedisConnection> connections;
        private final Function<RedisConnection, Boolean> deleteHandler;

        public Entry(int minimumAmount, int maximumAmount, Collection<? extends RedisConnection> connections, AsyncSemaphore freeConnectionsCounter, Function<RedisConnection, Boolean> deleteHandler) {
            this.minimumAmount = minimumAmount;
            this.maximumAmount = maximumAmount;
            this.connections = connections;
            this.freeConnectionsCounter = freeConnectionsCounter;
            this.deleteHandler = deleteHandler;
        }
    }
}

