/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonBatch;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonObject;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMultimapAsync;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RTopic;
import org.redisson.api.RTopicAsync;
import org.redisson.api.RTransaction;
import org.redisson.api.TransactionOptions;
import org.redisson.api.listener.MessageListener;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisabledKey;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.AsyncCountDownLatch;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.transaction.HashKey;
import org.redisson.transaction.HashValue;
import org.redisson.transaction.RedissonTransactionalBucket;
import org.redisson.transaction.RedissonTransactionalBuckets;
import org.redisson.transaction.RedissonTransactionalLocalCachedMap;
import org.redisson.transaction.RedissonTransactionalMap;
import org.redisson.transaction.RedissonTransactionalMapCache;
import org.redisson.transaction.RedissonTransactionalSet;
import org.redisson.transaction.RedissonTransactionalSetCache;
import org.redisson.transaction.TransactionException;
import org.redisson.transaction.TransactionTimeoutException;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.map.MapOperation;

public class RedissonTransaction
implements RTransaction {
    private final CommandAsyncExecutor commandExecutor;
    private final AtomicBoolean executed = new AtomicBoolean();
    private final TransactionOptions options;
    private List<TransactionalOperation> operations = new CopyOnWriteArrayList<TransactionalOperation>();
    private Set<String> localCaches = new HashSet<String>();
    private final long startTime = System.currentTimeMillis();
    private final String id = RedissonTransaction.generateId();

    public RedissonTransaction(CommandAsyncExecutor commandExecutor, TransactionOptions options) {
        this.options = options;
        this.commandExecutor = commandExecutor;
    }

    public RedissonTransaction(CommandAsyncExecutor commandExecutor, TransactionOptions options, List<TransactionalOperation> operations, Set<String> localCaches) {
        this.commandExecutor = commandExecutor;
        this.options = options;
        this.operations = operations;
        this.localCaches = localCaches;
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(RLocalCachedMap<K, V> fromInstance) {
        this.checkState();
        this.localCaches.add(fromInstance.getName());
        return new RedissonTransactionalLocalCachedMap<K, V>(this.commandExecutor, this.operations, this.options.getTimeout(), this.executed, fromInstance, this.id);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        this.checkState();
        return new RedissonTransactionalBucket(this.commandExecutor, this.options.getTimeout(), name, this.operations, this.executed, this.id);
    }

    @Override
    public <V> RBucket<V> getBucket(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalBucket(codec, this.commandExecutor, this.options.getTimeout(), name, this.operations, this.executed, this.id);
    }

    @Override
    public RBuckets getBuckets() {
        this.checkState();
        return new RedissonTransactionalBuckets(this.commandExecutor, this.options.getTimeout(), this.operations, this.executed, this.id);
    }

    @Override
    public RBuckets getBuckets(Codec codec) {
        this.checkState();
        return new RedissonTransactionalBuckets(codec, this.commandExecutor, this.options.getTimeout(), this.operations, this.executed, this.id);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        this.checkState();
        return new RedissonTransactionalSet(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <V> RSet<V> getSet(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalSet(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name) {
        this.checkState();
        return new RedissonTransactionalSetCache(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalSetCache(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        this.checkState();
        return new RedissonTransactionalMap(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalMap(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name) {
        this.checkState();
        return new RedissonTransactionalMapCache(this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec) {
        this.checkState();
        return new RedissonTransactionalMapCache(codec, this.commandExecutor, name, this.operations, this.options.getTimeout(), this.executed, this.id);
    }

    @Override
    public RFuture<Void> commitAsync() {
        this.checkState();
        this.checkTimeout();
        BatchOptions batchOptions = this.createOptions();
        CommandBatchService transactionExecutor = new CommandBatchService(this.commandExecutor, batchOptions);
        for (TransactionalOperation transactionalOperation : this.operations) {
            transactionalOperation.commit(transactionExecutor);
        }
        String id = RedissonTransaction.generateId();
        CompletionStage<Map<HashKey, HashValue>> future = this.disableLocalCacheAsync(id, this.localCaches, this.operations);
        CompletionStage ff = future.handle((hashes, ex) -> {
            if (ex != null) {
                throw new CompletionException(new TransactionException("Unable to execute transaction", (Throwable)ex));
            }
            try {
                this.checkTimeout();
            }
            catch (TransactionTimeoutException e) {
                this.enableLocalCacheAsync(id, (Map<HashKey, HashValue>)hashes);
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(e);
                return f;
            }
            return hashes;
        }).thenCompose(hashes -> {
            RFuture<BatchResult<?>> transactionFuture = transactionExecutor.executeAsync();
            return transactionFuture.handle((r, exc) -> {
                if (exc != null) {
                    throw new CompletionException(new TransactionException("Unable to execute transaction", (Throwable)exc));
                }
                this.enableLocalCacheAsync(id, (Map)hashes);
                this.executed.set(true);
                return null;
            });
        });
        return new CompletableFutureWrapper<Void>(ff);
    }

    private BatchOptions createOptions() {
        MasterSlaveEntry entry = this.commandExecutor.getConnectionManager().getEntrySet().iterator().next();
        int syncSlaves = entry.getAvailableSlaves();
        if (this.options.getSyncSlaves() == -1) {
            syncSlaves = 0;
        } else if (this.options.getSyncSlaves() > 0) {
            syncSlaves = this.options.getSyncSlaves();
        }
        BatchOptions batchOptions = BatchOptions.defaults().syncSlaves(syncSlaves, this.options.getSyncTimeout(), TimeUnit.MILLISECONDS).responseTimeout(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS).retryAttempts(this.options.getRetryAttempts()).retryInterval(this.options.getRetryInterval(), TimeUnit.MILLISECONDS).executionMode(BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC);
        return batchOptions;
    }

    @Override
    public void commit() {
        this.commit(this.localCaches, this.operations);
    }

    public void commit(Set<String> localCaches, List<TransactionalOperation> operations) {
        this.checkState();
        this.checkTimeout();
        BatchOptions batchOptions = this.createOptions();
        CommandBatchService transactionExecutor = new CommandBatchService(this.commandExecutor, batchOptions);
        for (TransactionalOperation transactionalOperation : operations) {
            transactionalOperation.commit(transactionExecutor);
        }
        String id = RedissonTransaction.generateId();
        Map<HashKey, HashValue> hashes = this.disableLocalCache(id, localCaches, operations);
        try {
            this.checkTimeout();
        }
        catch (TransactionTimeoutException e) {
            this.enableLocalCache(id, hashes);
            throw e;
        }
        try {
            transactionExecutor.execute();
        }
        catch (Exception e) {
            throw new TransactionException("Unable to execute transaction", e);
        }
        this.enableLocalCache(id, hashes);
        this.executed.set(true);
    }

    private void checkTimeout() {
        if (this.options.getTimeout() != -1L && System.currentTimeMillis() - this.startTime > this.options.getTimeout()) {
            this.rollbackAsync();
            throw new TransactionTimeoutException("Transaction was discarded due to timeout " + this.options.getTimeout() + " milliseconds");
        }
    }

    private RFuture<BatchResult<?>> enableLocalCacheAsync(String requestId, Map<HashKey, HashValue> hashes) {
        if (hashes.isEmpty()) {
            return new CompletableFutureWrapper((BatchResult)null);
        }
        RedissonBatch publishBatch = this.createBatch();
        for (Map.Entry<HashKey, HashValue> entry : hashes.entrySet()) {
            String name = RedissonObject.suffixName(entry.getKey().getName(), "topic");
            RTopicAsync topic = publishBatch.getTopic(name, LocalCachedMessageCodec.INSTANCE);
            LocalCachedMapEnable msg = new LocalCachedMapEnable(requestId, (byte[][])entry.getValue().getKeyIds().toArray((T[])new byte[entry.getValue().getKeyIds().size()][]));
            topic.publishAsync(msg);
        }
        return publishBatch.executeAsync();
    }

    private void enableLocalCache(String requestId, Map<HashKey, HashValue> hashes) {
        if (hashes.isEmpty()) {
            return;
        }
        RedissonBatch publishBatch = this.createBatch();
        for (Map.Entry<HashKey, HashValue> entry : hashes.entrySet()) {
            String name = RedissonObject.suffixName(entry.getKey().getName(), "topic");
            RTopicAsync topic = publishBatch.getTopic(name, LocalCachedMessageCodec.INSTANCE);
            LocalCachedMapEnable msg = new LocalCachedMapEnable(requestId, (byte[][])entry.getValue().getKeyIds().toArray((T[])new byte[entry.getValue().getKeyIds().size()][]));
            topic.publishAsync(msg);
        }
        try {
            publishBatch.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<HashKey, HashValue> disableLocalCache(String requestId, Set<String> localCaches, List<TransactionalOperation> operations) {
        if (localCaches.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<HashKey, HashValue> hashes = new HashMap<HashKey, HashValue>(localCaches.size());
        RedissonBatch batch = this.createBatch();
        for (TransactionalOperation transactionalOperation : operations) {
            if (!localCaches.contains(transactionalOperation.getName())) continue;
            MapOperation mapOperation = (MapOperation)transactionalOperation;
            RedissonLocalCachedMap redissonLocalCachedMap = (RedissonLocalCachedMap)mapOperation.getMap();
            HashKey hashKey = new HashKey(transactionalOperation.getName(), transactionalOperation.getCodec());
            byte[] key = redissonLocalCachedMap.getLocalCacheView().toCacheKey(mapOperation.getKey()).getKeyHash();
            HashValue value = (HashValue)hashes.get(hashKey);
            if (value == null) {
                value = new HashValue();
                hashes.put(hashKey, value);
            }
            value.getKeyIds().add(key);
            String disabledKeysName = RedissonObject.suffixName(transactionalOperation.getName(), "disabled-keys");
            RMultimapAsync multimap = batch.getListMultimapCache(disabledKeysName, transactionalOperation.getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.putAsync(localCacheKey, ByteBufUtil.hexDump(key));
            multimap.expireKeyAsync(localCacheKey, this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        try {
            batch.execute();
        }
        catch (Exception e) {
            throw new TransactionException("Unable to execute transaction over local cached map objects: " + localCaches, e);
        }
        final CountDownLatch latch = new CountDownLatch(hashes.size());
        ArrayList<RedissonTopic> topics = new ArrayList<RedissonTopic>();
        for (final Map.Entry entry : hashes.entrySet()) {
            RedissonTopic redissonTopic = RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), requestId + ":topic"));
            topics.add(redissonTopic);
            redissonTopic.addListener(Object.class, new MessageListener<Object>(){

                @Override
                public void onMessage(CharSequence channel, Object msg) {
                    AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                    if (counter.decrementAndGet() == 0) {
                        latch.countDown();
                    }
                }
            });
        }
        RedissonBatch publishBatch = this.createBatch();
        for (Map.Entry entry : hashes.entrySet()) {
            String disabledKeysName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "disabled-keys");
            RMultimapAsync multimap = publishBatch.getListMultimapCache(disabledKeysName, ((HashKey)entry.getKey()).getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.removeAllAsync(localCacheKey);
            RTopicAsync topic = publishBatch.getTopic(RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "topic"), LocalCachedMessageCodec.INSTANCE);
            RFuture<Long> future = topic.publishAsync(new LocalCachedMapDisable(requestId, (byte[][])((HashValue)entry.getValue()).getKeyIds().toArray((T[])new byte[((HashValue)entry.getValue()).getKeyIds().size()][]), this.options.getResponseTimeout()));
            future.thenAccept(res -> {
                int receivers = res.intValue();
                AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                if (counter.addAndGet(receivers) == 0) {
                    latch.countDown();
                }
            });
        }
        try {
            publishBatch.execute();
        }
        catch (Exception exception) {
            throw new TransactionException("Unable to execute transaction over local cached map objects: " + localCaches, exception);
        }
        for (RTopic rTopic : topics) {
            rTopic.removeAllListeners();
        }
        try {
            latch.await(this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return hashes;
    }

    private CompletionStage<Map<HashKey, HashValue>> disableLocalCacheAsync(String requestId, Set<String> localCaches, List<TransactionalOperation> operations) {
        if (localCaches.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap<HashKey, HashValue> hashes = new HashMap<HashKey, HashValue>(localCaches.size());
        RedissonBatch batch = this.createBatch();
        for (TransactionalOperation transactionalOperation : operations) {
            if (!localCaches.contains(transactionalOperation.getName())) continue;
            MapOperation mapOperation = (MapOperation)transactionalOperation;
            RedissonLocalCachedMap map = (RedissonLocalCachedMap)mapOperation.getMap();
            HashKey hashKey = new HashKey(transactionalOperation.getName(), transactionalOperation.getCodec());
            byte[] key = map.getLocalCacheView().toCacheKey(mapOperation.getKey()).getKeyHash();
            HashValue value = (HashValue)hashes.get(hashKey);
            if (value == null) {
                value = new HashValue();
                hashes.put(hashKey, value);
            }
            value.getKeyIds().add(key);
            String disabledKeysName = RedissonObject.suffixName(transactionalOperation.getName(), "disabled-keys");
            RMultimapAsync multimap = batch.getListMultimapCache(disabledKeysName, transactionalOperation.getCodec());
            LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
            multimap.putAsync(localCacheKey, ByteBufUtil.hexDump(key));
            multimap.expireKeyAsync(localCacheKey, this.options.getResponseTimeout(), TimeUnit.MILLISECONDS);
        }
        CompletableFuture<Map<HashKey, HashValue>> result = new CompletableFuture<Map<HashKey, HashValue>>();
        RFuture<BatchResult<?>> batchListener = batch.executeAsync();
        batchListener.thenAccept(res -> {
            ArrayList subscriptionFutures = new ArrayList();
            ArrayList<RedissonTopic> topics = new ArrayList<RedissonTopic>();
            AsyncCountDownLatch latch = new AsyncCountDownLatch();
            latch.latch(() -> {
                for (RTopic t : topics) {
                    t.removeAllListenersAsync();
                }
                result.complete(hashes);
            }, hashes.size());
            for (Map.Entry entry : hashes.entrySet()) {
                String disabledAckName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), requestId + ":topic");
                RedissonTopic topic = RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, disabledAckName);
                topics.add(topic);
                RFuture<Integer> topicFuture = topic.addListenerAsync(Object.class, (channel, msg) -> {
                    AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                    if (counter.decrementAndGet() == 0) {
                        latch.countDown();
                    }
                });
                subscriptionFutures.add(topicFuture.toCompletableFuture());
            }
            CompletableFuture<Void> subscriptionFuture = CompletableFuture.allOf(subscriptionFutures.toArray(new CompletableFuture[0]));
            subscriptionFuture.thenAccept(r -> {
                RedissonBatch publishBatch = this.createBatch();
                for (Map.Entry entry : hashes.entrySet()) {
                    String disabledKeysName = RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "disabled-keys");
                    RMultimapAsync multimap = publishBatch.getListMultimapCache(disabledKeysName, ((HashKey)entry.getKey()).getCodec());
                    LocalCachedMapDisabledKey localCacheKey = new LocalCachedMapDisabledKey(requestId, this.options.getResponseTimeout());
                    multimap.removeAllAsync(localCacheKey);
                    RTopicAsync topic = publishBatch.getTopic(RedissonObject.suffixName(((HashKey)entry.getKey()).getName(), "topic"), LocalCachedMessageCodec.INSTANCE);
                    RFuture<Long> publishFuture = topic.publishAsync(new LocalCachedMapDisable(requestId, (byte[][])((HashValue)entry.getValue()).getKeyIds().toArray((T[])new byte[((HashValue)entry.getValue()).getKeyIds().size()][]), this.options.getResponseTimeout()));
                    publishFuture.thenAccept(receivers -> {
                        AtomicInteger counter = ((HashValue)entry.getValue()).getCounter();
                        if (counter.addAndGet(receivers.intValue()) == 0) {
                            latch.countDown();
                        }
                    });
                }
                RFuture<BatchResult<?>> publishFuture = publishBatch.executeAsync();
                publishFuture.thenAccept(res2 -> this.commandExecutor.getConnectionManager().newTimeout(timeout -> result.completeExceptionally(new TransactionTimeoutException("Unable to execute transaction within " + this.options.getResponseTimeout() + "ms")), this.options.getResponseTimeout(), TimeUnit.MILLISECONDS));
            });
        });
        return result;
    }

    private RedissonBatch createBatch() {
        return new RedissonBatch(null, this.commandExecutor, BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC));
    }

    protected static String generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    @Override
    public void rollback() {
        this.rollback(this.operations);
    }

    public void rollback(List<TransactionalOperation> operations) {
        this.checkState();
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
        for (TransactionalOperation transactionalOperation : operations) {
            transactionalOperation.rollback(executorService);
        }
        try {
            executorService.execute();
        }
        catch (Exception e) {
            throw new TransactionException("Unable to rollback transaction", e);
        }
        operations.clear();
        this.executed.set(true);
    }

    @Override
    public RFuture<Void> rollbackAsync() {
        this.checkState();
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
        for (TransactionalOperation transactionalOperation : this.operations) {
            transactionalOperation.rollback(executorService);
        }
        RFuture<BatchResult<?>> future = executorService.executeAsync();
        CompletionStage<Void> f = future.handle((res, e) -> {
            if (e != null) {
                throw new CompletionException(new TransactionException("Unable to rollback transaction", (Throwable)e));
            }
            this.operations.clear();
            this.executed.set(true);
            return null;
        });
        return new CompletableFutureWrapper<Void>(f);
    }

    public Set<String> getLocalCaches() {
        return this.localCaches;
    }

    public List<TransactionalOperation> getOperations() {
        return this.operations;
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction was finished!");
        }
    }
}

