/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.misc.CompletableFutureWrapper;

public class BaseTransactionalObject {
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    public RFuture<Boolean> expireAtAsync(Instant timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("move method is not supported in transaction");
    }

    public RFuture<Void> migrateAsync(String host, int port, int database) {
        throw new UnsupportedOperationException("migrate method is not supported in transaction");
    }

    protected <R> RFuture<R> executeLocked(long timeout, Supplier<CompletionStage<R>> runnable, RLock lock) {
        CompletionStage f = lock.lockAsync(timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get());
        return new CompletableFutureWrapper(f);
    }

    protected <R> RFuture<R> executeLocked(long timeout, Supplier<CompletionStage<R>> runnable, List<RLock> locks) {
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[0]));
        long threadId = Thread.currentThread().getId();
        CompletionStage<Object> f = multiLock.lockAsync(timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get()).whenComplete((r, e) -> {
            if (e != null) {
                multiLock.unlockAsync(threadId);
            }
        });
        return new CompletableFutureWrapper<Object>(f);
    }
}

