/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class PropertiesConvertor {
    private static final Set<String> LIST_NODES = new HashSet<String>(Arrays.asList("node-addresses", "nodeaddresses", "slave-addresses", "slaveaddresses", "addresses"));

    public static String toYaml(String suffix, Iterable<String> propertyNames, Function<String, String> resolver) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith(suffix)) continue;
            List<String> list = Arrays.asList(propertyName.replace(suffix, "").split("\\."));
            String value = resolver.apply(propertyName);
            if (list.size() == 2) {
                Map m = (Map)map.computeIfAbsent(list.get(0), k -> new HashMap());
                m.put(list.get(1), value);
                continue;
            }
            map.put(list.get(0), value);
        }
        StringBuilder yaml = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                yaml.append(PropertiesConvertor.convertKey((String)entry.getKey())).append(":").append("\n");
                Map m = (Map)entry.getValue();
                for (Map.Entry<String, Object> entry2 : m.entrySet()) {
                    yaml.append("  ").append(PropertiesConvertor.convertKey((String)entry2.getKey())).append(": ");
                    PropertiesConvertor.addValue(yaml, entry2);
                    yaml.append("\n");
                }
                continue;
            }
            yaml.append(PropertiesConvertor.convertKey((String)entry.getKey())).append(": ");
            PropertiesConvertor.addValue(yaml, entry);
            yaml.append("\n");
        }
        return yaml.toString();
    }

    private static String convertKey(String key) {
        if (!key.contains("-")) {
            return key;
        }
        String[] parts = key.split("-");
        StringBuilder builder = new StringBuilder();
        builder.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i].substring(0, 1).toUpperCase()).append(parts[i].substring(1));
        }
        return builder.toString();
    }

    private static void addValue(StringBuilder yaml, Map.Entry<String, Object> subEntry) {
        String value;
        block6: {
            value = (String)subEntry.getValue();
            if (value.contains(",") || LIST_NODES.contains(subEntry.getKey())) {
                for (String part : value.split(",")) {
                    yaml.append("\n  ").append("- \"").append(part.trim()).append("\"");
                }
                return;
            }
            if ("codec".equals(subEntry.getKey()) || "load-balancer".equals(subEntry.getKey())) {
                value = "!<" + value + "> {}";
            } else {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    if (Boolean.parseBoolean(value) || "null".equals(value)) break block6;
                    value = "\"" + value + "\"";
                }
            }
        }
        yaml.append(value);
    }
}

