/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.redisson.api.RFuture;

public class CompletableFutureWrapper<V>
implements RFuture<V> {
    private final CompletableFuture<V> future;
    private CompletableFuture<V> lastFuture;

    public CompletableFutureWrapper(V value) {
        this(CompletableFuture.completedFuture(value));
    }

    public CompletableFutureWrapper(CompletionStage<V> stage) {
        this.future = stage.toCompletableFuture();
        this.lastFuture = this.future;
    }

    public CompletableFutureWrapper(CompletableFuture<V> future) {
        this.future = future;
        this.lastFuture = future;
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.future.thenApply(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.future.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        return this.future.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super V> action) {
        return this.future.thenAccept(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.future.thenAcceptAsync(action);
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        return this.future.thenAcceptAsync(action, executor);
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return this.future.thenRun(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        return this.future.thenRunAsync(action);
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public <U, V1> CompletionStage<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombine(other, fn);
    }

    @Override
    public <U, V1> CompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.future.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V1> CompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        return this.future.thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBoth(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.future.thenAcceptBothAsync(other, action);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        return this.future.thenAcceptBothAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEither(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.future.applyToEitherAsync(other, fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn, Executor executor) {
        return this.future.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEither(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.future.acceptEitherAsync(other, action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action, Executor executor) {
        return this.future.acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.future.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenCompose(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.future.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.future.thenComposeAsync(fn, executor);
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handle(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.future.handleAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        return this.future.handleAsync(fn, executor);
    }

    @Override
    public CompletionStage<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return this.future.whenComplete(action);
    }

    @Override
    public CompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return this.future.whenCompleteAsync(action);
    }

    @Override
    public CompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        return this.future.whenCompleteAsync(action, executor);
    }

    @Override
    public CompletionStage<V> exceptionally(Function<Throwable, ? extends V> fn) {
        return this.future.exceptionally(fn);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this.future;
    }

    public V getNow(V valueIfAbsent) {
        return this.future.getNow(valueIfAbsent);
    }

    public boolean complete(V value) {
        return this.future.complete(value);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean isSuccess() {
        return this.future.isDone() && !this.future.isCompletedExceptionally();
    }

    @Override
    public Throwable cause() {
        if (this.future.isDone()) {
            try {
                this.future.getNow(null);
            }
            catch (CompletionException e) {
                return e.getCause();
            }
            catch (CancellationException e) {
                return e;
            }
        }
        return null;
    }

    @Override
    public V getNow() {
        return this.future.getNow(null);
    }

    @Override
    public V join() {
        return this.future.join();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.future.get(timeout, unit);
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<V> sync() throws InterruptedException {
        try {
            this.future.get();
            return this;
        }
        catch (ExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    public RFuture<V> syncUninterruptibly() {
        try {
            this.future.join();
            return this;
        }
        catch (CompletionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    public RFuture<V> await() throws InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public RFuture<V> awaitUninterruptibly() {
        try {
            this.future.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            this.future.get(timeout, unit);
        }
        catch (ExecutionException | TimeoutException exception) {
        }
        catch (InterruptedException e) {
            this.awaitUninterruptibly(timeout, unit);
        }
        return this.future.isDone();
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onComplete(BiConsumer<? super V, ? super Throwable> action) {
        this.lastFuture = this.lastFuture.whenComplete(action);
    }
}

