/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.redisson.MapWriterTask;
import org.redisson.RedissonMap;
import org.redisson.ScanResult;
import org.redisson.WriteBehindService;
import org.redisson.api.EvictionMode;
import org.redisson.api.MapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RMapCache;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.map.event.EntryCreatedListener;
import org.redisson.api.map.event.EntryEvent;
import org.redisson.api.map.event.EntryExpiredListener;
import org.redisson.api.map.event.EntryRemovedListener;
import org.redisson.api.map.event.EntryUpdatedListener;
import org.redisson.api.map.event.MapEntryListener;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MapCacheScanResult;
import org.redisson.client.protocol.decoder.MapCacheScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.client.protocol.decoder.ObjectMapDecoder;
import org.redisson.codec.BaseEventCodec;
import org.redisson.codec.MapCacheEventCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RedissonPromise;

public class RedissonMapCache<K, V>
extends RedissonMap<K, V>
implements RMapCache<K, V> {
    private EvictionScheduler evictionScheduler;
    private static final RedisCommand<MapCacheScanResult<Object, Object>> SCAN = new RedisCommand<Object>("EVAL", new ListMultiDecoder2(new MapCacheScanResultReplayDecoder(), new ObjectMapDecoder(true)));
    private BaseEventCodec.OSType osType;

    public RedissonMapCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(commandExecutor, name, redisson, options, writeBehindService);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getExpiredChannelName(), this.getLastAccessTimeSetName());
        }
        this.evictionScheduler = evictionScheduler;
    }

    public RedissonMapCache(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson, MapOptions<K, V> options, WriteBehindService writeBehindService) {
        super(codec, commandExecutor, name, redisson, options, writeBehindService);
        if (evictionScheduler != null) {
            evictionScheduler.schedule(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getExpiredChannelName(), this.getLastAccessTimeSetName());
        }
        this.evictionScheduler = evictionScheduler;
    }

    @Override
    public boolean trySetMaxSize(int maxSize) {
        return this.get(this.trySetMaxSizeAsync(maxSize));
    }

    @Override
    public boolean trySetMaxSize(int maxSize, EvictionMode mode) {
        return this.get(this.trySetMaxSizeAsync(maxSize, mode));
    }

    @Override
    public RFuture<Boolean> trySetMaxSizeAsync(int maxSize) {
        return this.trySetMaxSizeAsync(maxSize, EvictionMode.LRU);
    }

    @Override
    public RFuture<Boolean> trySetMaxSizeAsync(int maxSize, EvictionMode mode) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize should be greater than zero");
        }
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], 'max-size', ARGV[1]);return redis.call('hsetnx', KEYS[1], 'mode', ARGV[2]);", Collections.singletonList(this.getOptionsName()), new Object[]{maxSize, mode});
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.get(this.setMaxSizeAsync(maxSize));
    }

    @Override
    public void setMaxSize(int maxSize, EvictionMode mode) {
        this.get(this.setMaxSizeAsync(maxSize, mode));
    }

    @Override
    public RFuture<Void> setMaxSizeAsync(int maxSize) {
        return this.setMaxSizeAsync(maxSize, EvictionMode.LRU);
    }

    @Override
    public RFuture<Void> setMaxSizeAsync(int maxSize, EvictionMode mode) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize should be greater than zero");
        }
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.getOptionsName());
        params.add("max-size");
        params.add(maxSize);
        params.add("mode");
        params.add((Object)mode);
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.HMSET, params.toArray());
    }

    @Override
    protected RFuture<Boolean> containsKeyOperationAsync(String name, Object key) {
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); local expireDate = 92233720368547758; if value ~= false then     local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));     if maxSize ~= nil and maxSize ~= 0 then         local mode = redis.call('hget', KEYS[5], 'mode');         if mode == false or mode == 'LRU' then                redis.call('zadd', KEYS[4], tonumber(ARGV[1]), ARGV[2]);         else                redis.call('zincrby', KEYS[4], 1, ARGV[2]);         end;     end;    local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]);     if expireDateScore ~= false then         expireDate = tonumber(expireDateScore)     end;     local t, val = struct.unpack('dLc0', value);     if t ~= 0 then         local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]);         if expireIdle ~= false then             if tonumber(expireIdle) > tonumber(ARGV[1]) then                 redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]);             end ;            expireDate = math.min(expireDate, tonumber(expireIdle))         end;     end;     if expireDate <= tonumber(ARGV[1]) then         return 0;     end;     return 1;end;return 0; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getLastAccessTimeSetName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local s = redis.call('hgetall', KEYS[1]); for i, v in ipairs(s) do     if i % 2 == 0 then         local t, val = struct.unpack('dLc0', v);         if ARGV[2] == val then             local key = s[i - 1];             local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));             if maxSize ~= nil and maxSize ~= 0 then                 local mode = redis.call('hget', KEYS[5], 'mode');                 if mode == false or mode == 'LRU' then                     redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key);                 else                     redis.call('zincrby', KEYS[4], 1, key);                 end;             end;             local expireDate = 92233720368547758;             local expireDateScore = redis.call('zscore', KEYS[2], key);             if expireDateScore ~= false then                 expireDate = tonumber(expireDateScore)             end;             if t ~= 0 then                 local expireIdle = redis.call('zscore', KEYS[3], key);                 if expireIdle ~= false then                     if tonumber(expireIdle) > tonumber(ARGV[1]) then                         redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key);                     end;                     expireDate = math.min(expireDate, tonumber(expireIdle))                 end;             end;             if expireDate <= tonumber(ARGV[1]) then                 return 0;             end;             return 1;         end;    end;end;return 0;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis(), this.encodeMapValue(value));
    }

    @Override
    public RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        ArrayList<Comparable<Long>> args = new ArrayList<Comparable<Long>>(keys.size() + 1);
        ArrayList<Object> plainKeys = new ArrayList<Object>(keys.size());
        args.add(Long.valueOf(System.currentTimeMillis()));
        for (K key : keys) {
            plainKeys.add(key);
            args.add(this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Object>("EVAL", new MapValueDecoder(new MapGetAllDecoder(plainKeys, 0))), "local expireHead = redis.call('zrange', KEYS[2], 0, 0, 'withscores'); local currentTime = tonumber(table.remove(ARGV, 1)); local hasExpire = #expireHead == 2 and tonumber(expireHead[2]) <= currentTime; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));local map = {}; for i = 1, #ARGV, 1 do     local value = redis.call('hget', KEYS[1], ARGV[i]);     map[i] = false;    if value ~= false then         local key = ARGV[i];         local t, val = struct.unpack('dLc0', value);         map[i] = val;         if maxSize ~= nil and maxSize ~= 0 then                 local mode = redis.call('hget', KEYS[5], 'mode');                 if mode == false or mode == 'LRU' then                     redis.call('zadd', KEYS[4], currentTime, key);                 else                     redis.call('zincrby', KEYS[4], 1, key);                 end;         end;         if hasExpire then             local expireDate = redis.call('zscore', KEYS[2], key);             if expireDate ~= false and tonumber(expireDate) <= currentTime then                 map[i] = false;             end;         end;         if t ~= 0 then             local expireIdle = redis.call('zscore', KEYS[3], key);             if expireIdle ~= false then                 if tonumber(expireIdle) > currentTime then                     redis.call('zadd', KEYS[3], t + currentTime, key);                 else                     map[i] = false;                 end;             end;         end;     end; end; return map;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), args.toArray());
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.get(this.putIfAbsentAsync(key, value, ttl, ttlUnit));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.putIfAbsentAsync(key, value, ttl, ttlUnit, 0L, null);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.get(this.putIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    @Override
    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (maxIdleTime < 0L) {
            throw new IllegalArgumentException("maxIdleTime can't be negative");
        }
        if (ttl == 0L && maxIdleTime == 0L) {
            return this.putIfAbsentAsync(key, value);
        }
        if (ttl > 0L && ttlUnit == null) {
            throw new NullPointerException("ttlUnit param can't be null");
        }
        if (maxIdleTime > 0L && maxIdleUnit == null) {
            throw new NullPointerException("maxIdleUnit param can't be null");
        }
        long ttlTimeout = 0L;
        if (ttl > 0L) {
            ttlTimeout = System.currentTimeMillis() + ttlUnit.toMillis(ttl);
        }
        long maxIdleTimeout = 0L;
        long maxIdleDelta = 0L;
        if (maxIdleTime > 0L) {
            maxIdleDelta = maxIdleUnit.toMillis(maxIdleTime);
            maxIdleTimeout = System.currentTimeMillis() + maxIdleDelta;
        }
        String name = this.getRawName(key);
        RFuture future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local insertable = false; local value = redis.call('hget', KEYS[1], ARGV[5]); if value == false then insertable = true; else local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[5]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[5]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then insertable = true; end; end; if insertable == true then if tonumber(ARGV[2]) > 0 then redis.call('zadd', KEYS[2], ARGV[2], ARGV[5]); else redis.call('zrem', KEYS[2], ARGV[5]); end; if tonumber(ARGV[3]) > 0 then redis.call('zadd', KEYS[3], ARGV[3], ARGV[5]); else redis.call('zrem', KEYS[3], ARGV[5]); end; local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then     local currentTime = tonumber(ARGV[1]);     local lastAccessTimeSetName = KEYS[5]; local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[5]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize >= maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[5] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);                 if lruItemValue ~= false then                 local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                    local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[5]); end; end; local val = struct.pack('dLc0', tonumber(ARGV[4]), string.len(ARGV[6]), ARGV[6]); redis.call('hset', KEYS[1], ARGV[5], val); local msg = struct.pack('Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); return nil; else local t, val = struct.unpack('dLc0', value); redis.call('zadd', KEYS[3], t + ARGV[1], ARGV[5]); return val; end; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), ttlTimeout, maxIdleTimeout, maxIdleDelta, this.encodeMapKey(key), this.encodeMapValue(value));
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add task = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, task, r -> r == null);
    }

    @Override
    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return 0; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then return 0; end; if val == ARGV[3] then redis.call('zrem', KEYS[2], ARGV[2]); redis.call('zrem', KEYS[3], ARGV[2]); local maxSize = tonumber(redis.call('hget', KEYS[6], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then    redis.call('zrem', KEYS[5], ARGV[2]); end; redis.call('hdel', KEYS[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(val), val); redis.call('publish', KEYS[4], msg); return 1; else return 0; end", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getRemovedChannelName(name), this.getLastAccessTimeSetName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public RFuture<V> getOperationAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return nil; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]); end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then return nil; end; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), ARGV[2]); else redis.call('zincrby', KEYS[4], 1, ARGV[2]); end; end; return val; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getLastAccessTimeSetName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit unit) {
        return this.get(this.putAsync(key, value, ttl, unit));
    }

    @Override
    protected RFuture<V> putOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[2]);local exists = false;if v ~= false then    local t, val = struct.unpack('dLc0', v);    local expireDate = 92233720368547758;    local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]);    if expireDateScore ~= false then        expireDate = tonumber(expireDateScore)    end;    if t ~= 0 then        local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]);        if expireIdle ~= false then            expireDate = math.min(expireDate, tonumber(expireIdle))        end;    end;    if expireDate > tonumber(ARGV[1]) then        exists = true;    end;end;redis.call('zrem', KEYS[2], ARGV[2]); redis.call('zrem', KEYS[3], ARGV[2]); local value = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]);redis.call('hset', KEYS[1], ARGV[2], value);local currentTime = tonumber(ARGV[1]);local lastAccessTimeSetName = KEYS[6];local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size'));local mode = redis.call('hget', KEYS[8], 'mode'); if exists == false then    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;         local cacheSize = tonumber(redis.call('hlen', KEYS[1]));        if cacheSize > maxSize then            local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);            for index, lruItem in ipairs(lruItems) do                if lruItem and lruItem ~= ARGV[2] then                    local lruItemValue = redis.call('hget', KEYS[1], lruItem);                    redis.call('hdel', KEYS[1], lruItem);                    redis.call('zrem', KEYS[2], lruItem);                    redis.call('zrem', KEYS[3], lruItem);                    redis.call('zrem', lastAccessTimeSetName, lruItem);                    if lruItemValue ~= false then                     local removedChannelName = KEYS[7];local ttl, obj = struct.unpack('dLc0', lruItemValue);                    local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                    redis.call('publish', removedChannelName, msg);end;                 end;            end        end;if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end;     end;    local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]);    redis.call('publish', KEYS[4], msg);    return nil;else    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); else redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end;     end;end;local t, val = struct.unpack('dLc0', v);local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3], string.len(val), val);redis.call('publish', KEYS[5], msg);return val;", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<V> putIfExistsOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return nil;end; local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size'));local lastAccessTimeSetName = KEYS[5]; local currentTime = tonumber(ARGV[1]); local t, val;if value ~= false then t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); else redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; else return nil; end; end; local newValue = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], newValue); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);                 if lruItemValue ~= false then                 local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3], string.len(val), val); redis.call('publish', KEYS[4], msg); return val;", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size'));local lastAccessTimeSetName = KEYS[5]; local currentTime = tonumber(ARGV[1]); if value ~= false then local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); else redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; return val; end; end; local value = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], value); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);                 if lruItemValue ~= false then                 local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); return nil;", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long ttl, TimeUnit ttlUnit) {
        this.get(this.putAllAsync(map, ttl, ttlUnit));
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long ttl, TimeUnit ttlUnit) {
        if (map.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RFuture<Void> future = this.putAllOperationAsync(map, ttl, ttlUnit);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(map);
        return this.mapWriterFuture(future, listener);
    }

    @Override
    public V addAndGet(K key, Number value) {
        return this.get(this.addAndGetAsync(key, value));
    }

    @Override
    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("EVAL", new NumberConvertor(value.getClass())), "local value = redis.call('hget', KEYS[1], ARGV[2]); local expireDate = 92233720368547758; local t = 0; local val = 0; if value ~= false then t, val = struct.unpack('dLc0', value); local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]); end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; end; local newValue = tonumber(ARGV[3]); if value ~= false and expireDate > tonumber(ARGV[1]) then newValue = tonumber(val) + newValue; local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(newValue), newValue, string.len(val), val); redis.call('publish', KEYS[5], msg); else local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); end; local newValuePack = struct.pack('dLc0', t, string.len(newValue), newValue); redis.call('hset', KEYS[1], ARGV[2], newValuePack); local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then     local currentTime = tonumber(ARGV[1]);     local lastAccessTimeSetName = KEYS[6]; local mode = redis.call('hget', KEYS[8], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);                 if lruItemValue ~= false then                 local removedChannelName = KEYS[7]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; return tostring(newValue); ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), keyState, new BigDecimal(value.toString()).toPlainString());
    }

    @Override
    public boolean fastPut(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.get(this.fastPutAsync(key, value, ttl, ttlUnit));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.fastPutAsync(key, value, ttl, ttlUnit, 0L, null);
    }

    @Override
    public boolean fastPut(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.get(this.fastPutAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    @Override
    public RFuture<Boolean> fastPutAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (maxIdleTime < 0L) {
            throw new IllegalArgumentException("maxIdleTime can't be negative");
        }
        if (ttl == 0L && maxIdleTime == 0L) {
            return this.fastPutAsync(key, value);
        }
        if (ttl > 0L && ttlUnit == null) {
            throw new NullPointerException("ttlUnit param can't be null");
        }
        if (maxIdleTime > 0L && maxIdleUnit == null) {
            throw new NullPointerException("maxIdleUnit param can't be null");
        }
        RFuture<Boolean> future = this.fastPutOperationAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
        if (this.hasNoWriter()) {
            return future;
        }
        return this.mapWriterFuture(future, new MapWriterTask.Add(key, value));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        long currentTime = System.currentTimeMillis();
        long ttlTimeout = 0L;
        if (ttl > 0L) {
            ttlTimeout = currentTime + ttlUnit.toMillis(ttl);
        }
        long maxIdleTimeout = 0L;
        long maxIdleDelta = 0L;
        if (maxIdleTime > 0L) {
            maxIdleDelta = maxIdleUnit.toMillis(maxIdleTime);
            maxIdleTimeout = currentTime + maxIdleDelta;
        }
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local insertable = false; local value = redis.call('hget', KEYS[1], ARGV[5]); local t, val;if value == false then insertable = true; else t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[5]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[5]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then insertable = true; end; end; if tonumber(ARGV[2]) > 0 then redis.call('zadd', KEYS[2], ARGV[2], ARGV[5]); else redis.call('zrem', KEYS[2], ARGV[5]); end; if tonumber(ARGV[3]) > 0 then redis.call('zadd', KEYS[3], ARGV[3], ARGV[5]); else redis.call('zrem', KEYS[3], ARGV[5]); end; local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size')); local mode = redis.call('hget', KEYS[8], 'mode'); if maxSize ~= nil and maxSize ~= 0 then     local currentTime = tonumber(ARGV[1]);     local lastAccessTimeSetName = KEYS[6]; if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[5]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize >= maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[5] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);                 if lruItemValue ~= false then                 local removedChannelName = KEYS[7]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[5]); end; end; local value = struct.pack('dLc0', ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('hset', KEYS[1], ARGV[5], value); if insertable == true then local msg = struct.pack('Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); return 1;else local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6], string.len(val), val); redis.call('publish', KEYS[5], msg); return 0;end;", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), ttlTimeout, maxIdleTimeout, maxIdleDelta, this.encodeMapKey(key), this.encodeMapValue(value));
        return future;
    }

    @Override
    public boolean updateEntryExpiration(K key, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.get(this.updateEntryExpirationAsync(key, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    @Override
    public RFuture<Boolean> updateEntryExpirationAsync(K key, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.checkKey(key);
        long currentTime = System.currentTimeMillis();
        long ttlTimeout = 0L;
        if (ttl > 0L) {
            ttlTimeout = currentTime + ttlUnit.toMillis(ttl);
        }
        long maxIdleTimeout = 0L;
        if (maxIdleTime > 0L) {
            long maxIdleDelta = maxIdleUnit.toMillis(maxIdleTime);
            maxIdleTimeout = currentTime + maxIdleDelta;
        }
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[4]); local t, val;if value == false then return 0; else t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[4]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then return 0; end; end; if tonumber(ARGV[2]) > 0 then redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); else redis.call('zrem', KEYS[2], ARGV[4]); end; if tonumber(ARGV[3]) > 0 then redis.call('zadd', KEYS[3], ARGV[3], ARGV[4]); else redis.call('zrem', KEYS[3], ARGV[4]); end; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); local mode = redis.call('hget', KEYS[5], 'mode'); if maxSize ~= nil and maxSize ~= 0 then local currentTime = tonumber(ARGV[1]); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], currentTime, ARGV[4]); end; if mode == 'LFU' then redis.call('zincrby', KEYS[4], 1, ARGV[4]); end; end; return 1;", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getLastAccessTimeSetName(name), this.getOptionsName(name)), System.currentTimeMillis(), ttlTimeout, maxIdleTimeout, this.encodeMapKey(key));
        return future;
    }

    @Override
    public RFuture<V> putAsync(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.putAsync(key, value, ttl, ttlUnit, 0L, null);
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.get(this.putAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    @Override
    public RFuture<V> putAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (maxIdleTime < 0L) {
            throw new IllegalArgumentException("maxIdleTime can't be negative");
        }
        if (ttl == 0L && maxIdleTime == 0L) {
            return this.putAsync(key, value);
        }
        if (ttl > 0L && ttlUnit == null) {
            throw new NullPointerException("ttlUnit param can't be null");
        }
        if (maxIdleTime > 0L && maxIdleUnit == null) {
            throw new NullPointerException("maxIdleUnit param can't be null");
        }
        long ttlTimeout = 0L;
        long ttlTimeoutDelta = 0L;
        if (ttl > 0L) {
            ttlTimeoutDelta = ttlUnit.toMillis(ttl);
            ttlTimeout = System.currentTimeMillis() + ttlTimeoutDelta;
        }
        long maxIdleTimeout = 0L;
        long maxIdleDelta = 0L;
        if (maxIdleTime > 0L) {
            maxIdleDelta = maxIdleUnit.toMillis(maxIdleTime);
            maxIdleTimeout = System.currentTimeMillis() + maxIdleDelta;
        }
        RFuture<V> future = this.putOperationAsync(key, value, ttlTimeout, maxIdleTimeout, maxIdleDelta, ttlTimeoutDelta);
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, listener);
    }

    protected RFuture<V> putOperationAsync(K key, V value, long ttlTimeout, long maxIdleTimeout, long maxIdleDelta, long ttlTimeoutDelta) {
        String name = this.getRawName(key);
        RFuture future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local insertable = false; local v = redis.call('hget', KEYS[1], ARGV[5]); if v == false then insertable = true; else local t, val = struct.unpack('dLc0', v); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[5]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[5]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then insertable = true; end; end; if tonumber(ARGV[2]) > 0 then redis.call('zadd', KEYS[2], ARGV[2], ARGV[5]); else redis.call('zrem', KEYS[2], ARGV[5]); end; if tonumber(ARGV[3]) > 0 then redis.call('zadd', KEYS[3], ARGV[3], ARGV[5]); else redis.call('zrem', KEYS[3], ARGV[5]); end; local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then     local currentTime = tonumber(ARGV[1]);     local lastAccessTimeSetName = KEYS[6];         local mode = redis.call('hget', KEYS[8], 'mode');         if mode == false or mode == 'LRU' then             redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[5]);         end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize >= maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[5] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);  if lruItemValue ~= false then                 local removedChannelName = KEYS[7]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[5]); end; end; local value = struct.pack('dLc0', ARGV[4], string.len(ARGV[6]), ARGV[6]); redis.call('hset', KEYS[1], ARGV[5], value); if insertable == true then local msg = struct.pack('Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6]); redis.call('publish', KEYS[4], msg); return nil;end; local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6], string.len(val), val); redis.call('publish', KEYS[5], msg); return val", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), ttlTimeout, maxIdleTimeout, maxIdleDelta, this.encodeMapKey(key), this.encodeMapValue(value));
        return future;
    }

    @Override
    public V getWithTTLOnly(K key) {
        return this.get(this.getWithTTLOnlyAsync(key));
    }

    private RFuture<V> getWithTTLOnlyOperationAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalReadAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return nil; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return nil; end; return val; ", Arrays.asList(name, this.getTimeoutSetName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    @Override
    public RFuture<V> getWithTTLOnlyAsync(K key) {
        this.checkKey(key);
        RFuture<V> future = this.getWithTTLOnlyOperationAsync(key);
        if (this.hasNoLoader()) {
            return future;
        }
        CompletionStage f = future.thenCompose(res -> {
            if (res == null) {
                return this.loadValue(key, false);
            }
            return CompletableFuture.completedFuture(res);
        });
        return new CompletableFutureWrapper(f);
    }

    @Override
    public long remainTimeToLive(K key) {
        return this.get(this.remainTimeToLiveAsync(key));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(K key) {
        this.checkKey(key);
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LONG, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return -2; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate == 92233720368547758 then return -1; end;if expireDate > tonumber(ARGV[1]) then return expireDate - ARGV[1]; else return -2; end; return val; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    String getTimeoutSetName(String name) {
        return RedissonMapCache.prefixName("redisson__timeout__set", name);
    }

    String getTimeoutSetName() {
        return RedissonMapCache.prefixName("redisson__timeout__set", this.getRawName());
    }

    String getLastAccessTimeSetName(String name) {
        return RedissonMapCache.prefixName("redisson__map_cache__last_access__set", name);
    }

    String getLastAccessTimeSetName() {
        return RedissonMapCache.prefixName("redisson__map_cache__last_access__set", this.getRawName());
    }

    String getIdleSetName(String name) {
        return RedissonMapCache.prefixName("redisson__idle__set", name);
    }

    String getIdleSetName() {
        return RedissonMapCache.prefixName("redisson__idle__set", this.getRawName());
    }

    String getOptionsName() {
        return RedissonMapCache.suffixName(this.getRawName(), "redisson_options");
    }

    String getOptionsName(String name) {
        return RedissonMapCache.suffixName(name, "redisson_options");
    }

    String getCreatedChannelName(String name) {
        return RedissonMapCache.prefixName("redisson_map_cache_created", name);
    }

    String getCreatedChannelName() {
        return RedissonMapCache.prefixName("redisson_map_cache_created", this.getRawName());
    }

    String getUpdatedChannelName() {
        return RedissonMapCache.prefixName("redisson_map_cache_updated", this.getRawName());
    }

    String getUpdatedChannelName(String name) {
        return RedissonMapCache.prefixName("redisson_map_cache_updated", name);
    }

    String getExpiredChannelName(String name) {
        return RedissonMapCache.prefixName("redisson_map_cache_expired", name);
    }

    String getExpiredChannelName() {
        return RedissonMapCache.prefixName("redisson_map_cache_expired", this.getRawName());
    }

    String getRemovedChannelName() {
        return RedissonMapCache.prefixName("redisson_map_cache_removed", this.getRawName());
    }

    String getRemovedChannelName(String name) {
        return RedissonMapCache.prefixName("redisson_map_cache_removed", name);
    }

    @Override
    protected RFuture<V> removeOperationAsync(K key) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return nil; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then return nil; end; redis.call('zrem', KEYS[2], ARGV[2]); redis.call('zrem', KEYS[3], ARGV[2]); redis.call('zrem', KEYS[5], ARGV[2]); redis.call('hdel', KEYS[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(val), val); redis.call('publish', KEYS[4], msg); return val; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getRemovedChannelName(name), this.getLastAccessTimeSetName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
    }

    @Override
    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        ArrayList<ByteBuf> args = new ArrayList<ByteBuf>(keys.length);
        for (K key : keys) {
            args.add(this.encodeMapKey(key));
        }
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local maxSize = tonumber(redis.call('hget', KEYS[6], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then     redis.call('zrem', KEYS[5], unpack(ARGV)); end; redis.call('zrem', KEYS[3], unpack(ARGV)); redis.call('zrem', KEYS[2], unpack(ARGV)); for i, key in ipairs(ARGV) do local v = redis.call('hget', KEYS[1], key); if v ~= false then local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(val), val); redis.call('publish', KEYS[4], msg); end; end; local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getRemovedChannelName(), this.getLastAccessTimeSetName(), this.getOptionsName()), args.toArray());
        return future;
    }

    @Override
    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length);
        for (K key : keys) {
            params.add(this.encodeMapKey(key));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "local maxSize = tonumber(redis.call('hget', KEYS[6], 'max-size')); for i=1, #ARGV, 5000 do if maxSize ~= nil and maxSize ~= 0 then redis.call('zrem', KEYS[5], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; redis.call('zrem', KEYS[3], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) redis.call('zrem', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; for i, key in ipairs(ARGV) do local v = redis.call('hget', KEYS[1], key); if v ~= false then local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(val), val); redis.call('publish', KEYS[4], msg); end; end; local n = 0;for i=1, #ARGV, 5000 do n = n + redis.call('hdel', KEYS[1], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; return n; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getRemovedChannelName(), this.getLastAccessTimeSetName(), this.getOptionsName()), params.toArray());
    }

    @Override
    public ScanResult<Map.Entry<Object, Object>> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        return this.get(this.scanIteratorAsync(name, client, startPos, pattern, count));
    }

    @Override
    public RFuture<ScanResult<Map.Entry<Object, Object>>> scanIteratorAsync(String name, RedisClient client, long startPos, String pattern, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(System.currentTimeMillis());
        params.add(startPos);
        if (pattern != null) {
            params.add(pattern);
        }
        params.add(count);
        RFuture future = this.commandExecutor.evalReadAsync(client, name, this.codec, SCAN, "local result = {}; local idleKeys = {}; local res; if (#ARGV == 4) then  res = redis.call('hscan', KEYS[1], ARGV[2], 'match', ARGV[3], 'count', ARGV[4]); else  res = redis.call('hscan', KEYS[1], ARGV[2], 'count', ARGV[3]); end;local currentTime = tonumber(ARGV[1]); for i, value in ipairs(res[2]) do if i % 2 == 0 then local key = res[2][i-1]; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; local t, val = struct.unpack('dLc0', value); if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > currentTime and expireDate > currentTime then table.insert(idleKeys, key); end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > currentTime then table.insert(result, key); table.insert(result, val); end; end; end;return {res[1], result, idleKeys};", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name)), params.toArray());
        CompletionStage<MapCacheScanResult> f = future.thenApply(res -> {
            if (res.getIdleKeys().isEmpty()) {
                return res;
            }
            ArrayList<Object> args = new ArrayList<Object>(res.getIdleKeys().size() + 1);
            args.add(System.currentTimeMillis());
            this.encodeMapKeys(args, res.getIdleKeys());
            this.commandExecutor.evalWriteAsync(name, this.codec, new RedisCommand<Object>("EVAL", new MapValueDecoder(new MapGetAllDecoder(args, 1))), "local currentTime = tonumber(table.remove(ARGV, 1)); local map = redis.call('hmget', KEYS[1], unpack(ARGV)); for i = #map, 1, -1 do local value = map[i]; if value ~= false then local key = ARGV[i]; local t, val = struct.unpack('dLc0', value); if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[2], key); if expireIdle ~= false then if tonumber(expireIdle) > currentTime then redis.call('zadd', KEYS[2], t + currentTime, key); end; end; end; end; end; ", Arrays.asList(name, this.getIdleSetName(name)), args.toArray());
            return res;
        });
        return new CompletableFutureWrapper<ScanResult<Map.Entry<Object, Object>>>(f);
    }

    @Override
    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local insertable = false; local v = redis.call('hget', KEYS[1], ARGV[2]); if v == false then insertable = true; else local t, val = struct.unpack('dLc0', v); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate <= tonumber(ARGV[1]) then insertable = true; end; end; local val = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], val); local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size'));if maxSize ~= nil and maxSize ~= 0 then     local currentTime = tonumber(ARGV[1]);     local lastAccessTimeSetName = KEYS[6]; local mode = redis.call('hget', KEYS[8], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);  if lruItemValue ~= false then                 local removedChannelName = KEYS[7]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; if insertable == true then local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); return 1;else local t, val = struct.unpack('dLc0', v); local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3], string.len(val), val); redis.call('publish', KEYS[5], msg); return 0;end;", Arrays.asList(this.getRawName(key), this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<Boolean> fastPutIfExistsOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); local lastAccessTimeSetName = KEYS[5]; local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size')); local currentTime = tonumber(ARGV[1]); if value ~= false then local val = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], val); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);  if lruItemValue ~= false then                 local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; return 1; end; return 0; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); local lastAccessTimeSetName = KEYS[5]; local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size')); local currentTime = tonumber(ARGV[1]); if value == false then local val = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], val); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); end;     local cacheSize = tonumber(redis.call('hlen', KEYS[1]));     if cacheSize > maxSize then         local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);         for index, lruItem in ipairs(lruItems) do             if lruItem and lruItem ~= ARGV[2] then                 local lruItemValue = redis.call('hget', KEYS[1], lruItem);                 redis.call('hdel', KEYS[1], lruItem);                 redis.call('zrem', KEYS[2], lruItem);                 redis.call('zrem', KEYS[3], lruItem);                 redis.call('zrem', lastAccessTimeSetName, lruItem);  if lruItemValue ~= false then                 local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                redis.call('publish', removedChannelName, msg); end;             end;         end;     end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; return 1; end; if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[2]); else redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[2]); end; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]); end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then return 0; end; redis.call('zrem', KEYS[2], ARGV[2]); redis.call('zrem', KEYS[3], ARGV[2]); local val = struct.pack('dLc0', 0, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], val); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[4], msg); return 1; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit) {
        return this.fastPutIfAbsent(key, value, ttl, ttlUnit, 0L, null);
    }

    @Override
    public boolean fastPutIfAbsent(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.get(this.fastPutIfAbsentAsync(key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.checkKey(key);
        this.checkValue(value);
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (maxIdleTime < 0L) {
            throw new IllegalArgumentException("maxIdleTime can't be negative");
        }
        if (ttl == 0L && maxIdleTime == 0L) {
            return this.fastPutIfAbsentAsync(key, value);
        }
        if (ttl > 0L && ttlUnit == null) {
            throw new NullPointerException("ttlUnit param can't be null");
        }
        if (maxIdleTime > 0L && maxIdleUnit == null) {
            throw new NullPointerException("maxIdleUnit param can't be null");
        }
        long ttlTimeout = 0L;
        if (ttl > 0L) {
            ttlTimeout = System.currentTimeMillis() + ttlUnit.toMillis(ttl);
        }
        long maxIdleTimeout = 0L;
        long maxIdleDelta = 0L;
        if (maxIdleTime > 0L) {
            maxIdleDelta = maxIdleUnit.toMillis(maxIdleTime);
            maxIdleTimeout = System.currentTimeMillis() + maxIdleDelta;
        }
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local insertable = false; local value = redis.call('hget', KEYS[1], ARGV[5]); if value == false then     insertable = true; else     if insertable == false then         local t, val = struct.unpack('dLc0', value);         local expireDate = 92233720368547758;         local expireDateScore = redis.call('zscore', KEYS[2], ARGV[5]);         if expireDateScore ~= false then             expireDate = tonumber(expireDateScore)         end;         if t ~= 0 then             local expireIdle = redis.call('zscore', KEYS[3], ARGV[5]);             if expireIdle ~= false then                 expireDate = math.min(expireDate, tonumber(expireIdle))             end;         end;         if expireDate <= tonumber(ARGV[1]) then             insertable = true;         end;     end; end; if insertable == true then     if tonumber(ARGV[2]) > 0 then         redis.call('zadd', KEYS[2], ARGV[2], ARGV[5]);     else         redis.call('zrem', KEYS[2], ARGV[5]);     end;     if tonumber(ARGV[3]) > 0 then         redis.call('zadd', KEYS[3], ARGV[3], ARGV[5]);     else         redis.call('zrem', KEYS[3], ARGV[5]);     end;     local maxSize = tonumber(redis.call('hget', KEYS[7], 'max-size'));     if maxSize ~= nil and maxSize ~= 0 then         local currentTime = tonumber(ARGV[1]);         local lastAccessTimeSetName = KEYS[5]; local mode = redis.call('hget', KEYS[7], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, ARGV[5]); end;         local cacheSize = tonumber(redis.call('hlen', KEYS[1]));         if cacheSize >= maxSize then             local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize);             for index, lruItem in ipairs(lruItems) do                 if lruItem and lruItem ~= ARGV[5] then                     local lruItemValue = redis.call('hget', KEYS[1], lruItem);                     redis.call('hdel', KEYS[1], lruItem);                     redis.call('zrem', KEYS[2], lruItem);                     redis.call('zrem', KEYS[3], lruItem);                     redis.call('zrem', lastAccessTimeSetName, lruItem);  if lruItemValue ~= false then                     local removedChannelName = KEYS[6]; local ttl, obj = struct.unpack('dLc0', lruItemValue);                    local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                    redis.call('publish', removedChannelName, msg); end;                 end;             end;         end; if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, ARGV[5]); end;     end;     local val = struct.pack('dLc0', ARGV[4], string.len(ARGV[6]), ARGV[6]);     redis.call('hset', KEYS[1], ARGV[5], val);     local msg = struct.pack('Lc0Lc0', string.len(ARGV[5]), ARGV[5], string.len(ARGV[6]), ARGV[6]);     redis.call('publish', KEYS[4], msg);     return 1; else     return 0; end; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getCreatedChannelName(name), this.getLastAccessTimeSetName(name), this.getRemovedChannelName(name), this.getOptionsName(name)), System.currentTimeMillis(), ttlTimeout, maxIdleTimeout, maxIdleDelta, this.encodeMapKey(key), this.encodeMapValue(value));
        if (this.hasNoWriter()) {
            return future;
        }
        MapWriterTask.Add listener = new MapWriterTask.Add(key, value);
        return this.mapWriterFuture(future, listener, Function.identity());
    }

    @Override
    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local v = redis.call('hget', KEYS[1], ARGV[2]); if v == false then     return 0; end; local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then     expireDate = tonumber(expireDateScore) end; local t, val = struct.unpack('dLc0', v); if t ~= 0 then     local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]);     if tonumber(expireIdle) > tonumber(ARGV[1]) then         redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]);     end ;    if expireIdle ~= false then         expireDate = math.min(expireDate, tonumber(expireIdle))     end; end; if expireDate > tonumber(ARGV[1]) and val == ARGV[3] then     local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[4]), ARGV[4], string.len(ARGV[3]), ARGV[3]);     redis.call('publish', KEYS[4], msg);     local value = struct.pack('dLc0', t, string.len(ARGV[4]), ARGV[4]);     redis.call('hset', KEYS[1], ARGV[2], value);     return 1; end; return 0; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getUpdatedChannelName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
    }

    @Override
    protected RFuture<Boolean> fastReplaceOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then     return 0; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then     expireDate = tonumber(expireDateScore) end; if t ~= 0 then     local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]);     if tonumber(expireIdle) > tonumber(ARGV[1]) then         redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]);     end ;    if expireIdle ~= false then         expireDate = math.min(expireDate, tonumber(expireIdle))     end; end; if expireDate <= tonumber(ARGV[1]) then     return 0; end; local value = struct.pack('dLc0', t, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], value); local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3], string.len(val), val); redis.call('publish', KEYS[4], msg); return 1; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getUpdatedChannelName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<V> replaceOperationAsync(K key, V value) {
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then     return nil; end; local t, val = struct.unpack('dLc0', value); local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then     expireDate = tonumber(expireDateScore) end; if t ~= 0 then     local expireIdle = redis.call('zscore', KEYS[3], ARGV[2]);     if tonumber(expireIdle) > tonumber(ARGV[1]) then         redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), ARGV[2]);     end ;    if expireIdle ~= false then         expireDate = math.min(expireDate, tonumber(expireIdle))     end; end; if expireDate <= tonumber(ARGV[1]) then     return nil; end; local value = struct.pack('dLc0', t, string.len(ARGV[3]), ARGV[3]); redis.call('hset', KEYS[1], ARGV[2], value); local msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3], string.len(val), val); redis.call('publish', KEYS[4], msg); return val; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getIdleSetName(name), this.getUpdatedChannelName(name)), System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    @Override
    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map) {
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>(map.size() * 2 + 1);
        params.add(Long.valueOf(System.currentTimeMillis()));
        for (Map.Entry<K, V> t : map.entrySet()) {
            if (t.getKey() == null) {
                throw new NullPointerException("map key can't be null");
            }
            if (t.getValue() == null) {
                throw new NullPointerException("map value can't be null");
            }
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local currentTime = tonumber(table.remove(ARGV, 1)); local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size'));local mode = redis.call('hget', KEYS[8], 'mode'); for i, value in ipairs(ARGV) do if i % 2 == 0 then local key = ARGV[i-1];local v = redis.call('hget', KEYS[1], key);local exists = false;if v ~= false then    local t, val = struct.unpack('dLc0', v);    local expireDate = 92233720368547758;    local expireDateScore = redis.call('zscore', KEYS[2], key);    if expireDateScore ~= false then        expireDate = tonumber(expireDateScore)    end;    if t ~= 0 then        local expireIdle = redis.call('zscore', KEYS[3], key);        if expireIdle ~= false then            expireDate = math.min(expireDate, tonumber(expireIdle))        end;    end;    if expireDate > tonumber(currentTime) then        exists = true;    end;end;local newvalue = struct.pack('dLc0', 0, string.len(value), value);redis.call('hset', KEYS[1], key, newvalue);local lastAccessTimeSetName = KEYS[6];if exists == false then    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, key); end;         local cacheSize = tonumber(redis.call('hlen', KEYS[1]));        if cacheSize > maxSize then            local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);            for index, lruItem in ipairs(lruItems) do                if lruItem and lruItem ~= key then                    local lruItemValue = redis.call('hget', KEYS[1], lruItem);                    redis.call('hdel', KEYS[1], lruItem);                    redis.call('zrem', KEYS[2], lruItem);                    redis.call('zrem', KEYS[3], lruItem);                    redis.call('zrem', lastAccessTimeSetName, lruItem); if lruItemValue ~= false then                     local removedChannelName = KEYS[7];local ttl, obj = struct.unpack('dLc0', lruItemValue);                    local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                    redis.call('publish', removedChannelName, msg);end;                 end;            end        end;if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, key); end;     end;    local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(value), value);    redis.call('publish', KEYS[4], msg);else local t, val = struct.unpack('dLc0', v);local msg = struct.pack('Lc0Lc0Lc0', string.len(key), key, string.len(value), value, string.len(val), val);redis.call('publish', KEYS[5], msg);    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, key); else redis.call('zincrby', lastAccessTimeSetName, 1, key); end;     end;end;end;end;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getCreatedChannelName(), this.getUpdatedChannelName(), this.getLastAccessTimeSetName(), this.getRemovedChannelName(), this.getOptionsName()), params.toArray());
    }

    private RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> map, long ttl, TimeUnit ttlUnit) {
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>(map.size() * 2 + 2);
        params.add(Long.valueOf(System.currentTimeMillis()));
        long ttlTimeout = 0L;
        if (ttl > 0L) {
            ttlTimeout = System.currentTimeMillis() + ttlUnit.toMillis(ttl);
        }
        params.add(Long.valueOf(ttlTimeout));
        for (Map.Entry<K, V> t : map.entrySet()) {
            if (t.getKey() == null) {
                throw new NullPointerException("map key can't be null");
            }
            if (t.getValue() == null) {
                throw new NullPointerException("map value can't be null");
            }
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "local currentTime = tonumber(table.remove(ARGV, 1)); local ttl = table.remove(ARGV, 1); local ttlNumber = tonumber(ttl); local maxSize = tonumber(redis.call('hget', KEYS[8], 'max-size'));local mode = redis.call('hget', KEYS[8], 'mode'); for i, value in ipairs(ARGV) do if i % 2 == 0 then local key = ARGV[i-1];local v = redis.call('hget', KEYS[1], key);local exists = false;if v ~= false then    local t, val = struct.unpack('dLc0', v);    local expireDate = 92233720368547758;    local expireDateScore = redis.call('zscore', KEYS[2], key);    if expireDateScore ~= false then        expireDate = tonumber(expireDateScore)    end;    if t ~= 0 then        local expireIdle = redis.call('zscore', KEYS[3], key);        if expireIdle ~= false then            expireDate = math.min(expireDate, tonumber(expireIdle))        end;    end;    if expireDate > tonumber(currentTime) then        exists = true;    end;end;if ttlNumber > 0 then     redis.call('zadd', KEYS[2], ttl, key); else     redis.call('zrem', KEYS[2], key); end; local newvalue = struct.pack('dLc0', 0, string.len(value), value);redis.call('hset', KEYS[1], key, newvalue);local lastAccessTimeSetName = KEYS[6];if exists == false then    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, key); end;         local cacheSize = tonumber(redis.call('hlen', KEYS[1]));        if cacheSize > maxSize then            local lruItems = redis.call('zrange', lastAccessTimeSetName, 0, cacheSize - maxSize - 1);            for index, lruItem in ipairs(lruItems) do                if lruItem and lruItem ~= key then                    local lruItemValue = redis.call('hget', KEYS[1], lruItem);                    redis.call('hdel', KEYS[1], lruItem);                    redis.call('zrem', KEYS[2], lruItem);                    redis.call('zrem', KEYS[3], lruItem);                    redis.call('zrem', lastAccessTimeSetName, lruItem); if lruItemValue ~= false then                     local removedChannelName = KEYS[7];local ttl, obj = struct.unpack('dLc0', lruItemValue);                    local msg = struct.pack('Lc0Lc0', string.len(lruItem), lruItem, string.len(obj), obj);                    redis.call('publish', removedChannelName, msg);end;                 end;            end        end;if mode == 'LFU' then redis.call('zincrby', lastAccessTimeSetName, 1, key); end;     end;    local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(value), value);    redis.call('publish', KEYS[4], msg);else local t, val = struct.unpack('dLc0', v);local msg = struct.pack('Lc0Lc0Lc0', string.len(key), key, string.len(value), value, string.len(val), val);redis.call('publish', KEYS[5], msg);    if maxSize ~= nil and maxSize ~= 0 then if mode == false or mode == 'LRU' then redis.call('zadd', lastAccessTimeSetName, currentTime, key); else redis.call('zincrby', lastAccessTimeSetName, 1, key); end;     end;end;end;end;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getCreatedChannelName(), this.getUpdatedChannelName(), this.getLastAccessTimeSetName(), this.getRemovedChannelName(), this.getOptionsName()), params.toArray());
    }

    @Override
    public int addListener(final MapEntryListener listener) {
        RTopic topic;
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.osType == null) {
            RFuture serverFuture = this.commandExecutor.readAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_SERVER, new Object[0]);
            String os = (String)((Map)serverFuture.toCompletableFuture().join()).get("os");
            if (os == null || os.contains("Windows")) {
                this.osType = BaseEventCodec.OSType.WINDOWS;
            } else if (os.contains("NONSTOP")) {
                this.osType = BaseEventCodec.OSType.HPNONSTOP;
            }
        }
        if (listener instanceof EntryRemovedListener) {
            topic = this.redisson.getTopic(this.getRemovedChannelName(), new MapCacheEventCodec(this.codec, this.osType));
            return topic.addListener(List.class, new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    EntryEvent<Object, Object> event = new EntryEvent<Object, Object>(RedissonMapCache.this, EntryEvent.Type.REMOVED, msg.get(0), msg.get(1), null);
                    ((EntryRemovedListener)listener).onRemoved(event);
                }
            });
        }
        if (listener instanceof EntryCreatedListener) {
            topic = this.redisson.getTopic(this.getCreatedChannelName(), new MapCacheEventCodec(this.codec, this.osType));
            return topic.addListener(List.class, new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    EntryEvent<Object, Object> event = new EntryEvent<Object, Object>(RedissonMapCache.this, EntryEvent.Type.CREATED, msg.get(0), msg.get(1), null);
                    ((EntryCreatedListener)listener).onCreated(event);
                }
            });
        }
        if (listener instanceof EntryUpdatedListener) {
            topic = this.redisson.getTopic(this.getUpdatedChannelName(), new MapCacheEventCodec(this.codec, this.osType));
            return topic.addListener(List.class, new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    EntryEvent<Object, Object> event = new EntryEvent<Object, Object>(RedissonMapCache.this, EntryEvent.Type.UPDATED, msg.get(0), msg.get(1), msg.get(2));
                    ((EntryUpdatedListener)listener).onUpdated(event);
                }
            });
        }
        if (listener instanceof EntryExpiredListener) {
            topic = this.redisson.getTopic(this.getExpiredChannelName(), new MapCacheEventCodec(this.codec, this.osType));
            return topic.addListener(List.class, new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    EntryEvent<Object, Object> event = new EntryEvent<Object, Object>(RedissonMapCache.this, EntryEvent.Type.EXPIRED, msg.get(0), msg.get(1), null);
                    ((EntryExpiredListener)listener).onExpired(event);
                }
            });
        }
        throw new IllegalArgumentException("Wrong listener type " + listener.getClass());
    }

    @Override
    public void removeListener(int listenerId) {
        super.removeListener(listenerId);
        RTopic removedTopic = this.redisson.getTopic(this.getRemovedChannelName());
        removedTopic.removeListener(listenerId);
        RTopic createdTopic = this.redisson.getTopic(this.getCreatedChannelName());
        createdTopic.removeListener(listenerId);
        RTopic updatedTopic = this.redisson.getTopic(this.getUpdatedChannelName());
        updatedTopic.removeListener(listenerId);
        RTopic expiredTopic = this.redisson.getTopic(this.getExpiredChannelName());
        expiredTopic.removeListener(listenerId);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName());
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public void clear() {
        RFuture<Boolean> future = this.deleteAsync(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName());
        this.get(future);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName());
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then redis.call('zadd', KEYS[4], 92233720368547758, 'redisson__expiretag'); if ARGV[2] ~= '' then redis.call('pexpire', KEYS[5], ARGV[1], ARGV[2]); redis.call('pexpire', KEYS[4], ARGV[1], ARGV[2]); else redis.call('pexpire', KEYS[5], ARGV[1]); redis.call('pexpire', KEYS[4], ARGV[1]); end; end; redis.call('zadd', KEYS[2], 92233720368547758, 'redisson__expiretag'); redis.call('zadd', KEYS[3], 92233720368547758, 'redisson__expiretag'); if ARGV[2] ~= '' then redis.call('pexpire', KEYS[2], ARGV[1], ARGV[2]); redis.call('pexpire', KEYS[3], ARGV[1], ARGV[2]); return redis.call('pexpireat', KEYS[1], ARGV[1], ARGV[2]); end; redis.call('pexpire', KEYS[2], ARGV[1]); redis.call('pexpire', KEYS[3], ARGV[1]); return redis.call('pexpire', KEYS[1], ARGV[1]); ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), timeUnit.toMillis(timeToLive), param);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then redis.call('zadd', KEYS[4], 92233720368547758, 'redisson__expiretag'); if ARGV[2] ~= '' then redis.call('pexpireat', KEYS[5], ARGV[1], ARGV[2]); redis.call('pexpireat', KEYS[4], ARGV[1], ARGV[2]); else redis.call('pexpireat', KEYS[5], ARGV[1]); redis.call('pexpireat', KEYS[4], ARGV[1]); end; end; redis.call('zadd', KEYS[2], 92233720368547758, 'redisson__expiretag'); redis.call('zadd', KEYS[3], 92233720368547758, 'redisson__expiretag'); if ARGV[2] ~= '' then redis.call('pexpireat', KEYS[2], ARGV[1], ARGV[2]); redis.call('pexpireat', KEYS[3], ARGV[1], ARGV[2]); return redis.call('pexpireat', KEYS[1], ARGV[1], ARGV[2]); end; redis.call('pexpireat', KEYS[2], ARGV[1]); redis.call('pexpireat', KEYS[3], ARGV[1]); return redis.call('pexpireat', KEYS[1], ARGV[1]); ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), timestamp, param);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); if maxSize ~= nil and maxSize ~= 0 then     redis.call('persist', KEYS[5]);     redis.call('zrem', KEYS[4], 92233720368547758, 'redisson__expiretag');     redis.call('persist', KEYS[4]); end; redis.call('zrem', KEYS[2], 'redisson__expiretag'); redis.call('persist', KEYS[2]); redis.call('zrem', KEYS[3], 'redisson__expiretag'); redis.call('persist', KEYS[3]); return redis.call('persist', KEYS[1]); ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), new Object[0]);
    }

    @Override
    public RFuture<Set<K>> readAllKeySetAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_KEY_SET, "local s = redis.call('hgetall', KEYS[1]); local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));local result = {}; for i, v in ipairs(s) do if i % 2 == 0 then local t, val = struct.unpack('dLc0', v); local key = s[i-1];local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key); else redis.call('zincrby', KEYS[4], 1, key); end; end; end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then table.insert(result, key); end; end; end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis());
    }

    @Override
    public RFuture<Set<K>> randomKeysAsync(int count) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_KEY_SET, "local s = redis.call('hrandfield', KEYS[1], ARGV[2], 'withvalues'); if s == false then return {};end; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));local result = {}; for i, v in ipairs(s) do if i % 2 == 0 then local t, val = struct.unpack('dLc0', v); local key = s[i-1];local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key); else redis.call('zincrby', KEYS[4], 1, key); end; end; end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then table.insert(result, key); end; end; end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis(), count);
    }

    @Override
    public RFuture<Map<K, V>> randomEntriesAsync(int count) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP, "local s = redis.call('hrandfield', KEYS[1], ARGV[2], 'withvalues'); if s == false then return {};end; local result = {}; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));for i, v in ipairs(s) do if i % 2 == 0 then local t, val = struct.unpack('dLc0', v); local key = s[i-1];local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key); else redis.call('zincrby', KEYS[4], 1, key); end; end; end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then table.insert(result, key); table.insert(result, val); end; end; end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis(), count);
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        return this.readAll(RedisCommands.EVAL_MAP_ENTRY);
    }

    private <R> RFuture<R> readAll(RedisCommand<?> evalCommandType) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, evalCommandType, "local s = redis.call('hgetall', KEYS[1]); local result = {}; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size'));for i, v in ipairs(s) do if i % 2 == 0 then local t, val = struct.unpack('dLc0', v); local key = s[i-1];local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key); else redis.call('zincrby', KEYS[4], 1, key); end; end; end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then table.insert(result, key); table.insert(result, val); end; end; end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis());
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        return this.readAll(RedisCommands.EVAL_MAP);
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, "local s = redis.call('hgetall', KEYS[1]); local result = {}; local maxSize = tonumber(redis.call('hget', KEYS[5], 'max-size')); for i, v in ipairs(s) do if i % 2 == 0 then local t, val = struct.unpack('dLc0', v); local key = s[i-1];local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if t ~= 0 then local expireIdle = redis.call('zscore', KEYS[3], key); if expireIdle ~= false then if tonumber(expireIdle) > tonumber(ARGV[1]) then redis.call('zadd', KEYS[3], t + tonumber(ARGV[1]), key); if maxSize ~= nil and maxSize ~= 0 then local mode = redis.call('hget', KEYS[5], 'mode'); if mode == false or mode == 'LRU' then redis.call('zadd', KEYS[4], tonumber(ARGV[1]), key); else redis.call('zincrby', KEYS[4], 1, key); end; end; end; expireDate = math.min(expireDate, tonumber(expireIdle)) end; end; if expireDate > tonumber(ARGV[1]) then table.insert(result, val); end; end; end;return result;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getIdleSetName(), this.getLastAccessTimeSetName(), this.getOptionsName()), System.currentTimeMillis());
    }

    @Override
    public void destroy() {
        if (this.evictionScheduler != null) {
            this.evictionScheduler.remove(this.getRawName());
        }
        if (this.writeBehindService != null) {
            this.writeBehindService.stop(this.getRawName());
        }
    }
}

