/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RedissonTopicReactive {
    private final RTopic topic;

    public RedissonTopicReactive(RTopic topic) {
        this.topic = topic;
    }

    public <M> Flux<M> getMessages(Class<M> type) {
        return Flux.create(emitter -> emitter.onRequest(n -> {
            AtomicLong counter = new AtomicLong(n);
            RFuture<Integer> t = this.topic.addListenerAsync(type, new MessageListener<M>((FluxSink)emitter, counter){
                final /* synthetic */ FluxSink val$emitter;
                final /* synthetic */ AtomicLong val$counter;
                {
                    this.val$emitter = fluxSink;
                    this.val$counter = atomicLong;
                }

                @Override
                public void onMessage(CharSequence channel, M msg) {
                    this.val$emitter.next(msg);
                    if (this.val$counter.decrementAndGet() == 0L) {
                        RedissonTopicReactive.this.topic.removeListenerAsync(this);
                        this.val$emitter.complete();
                    }
                }
            });
            t.whenComplete((id, e) -> {
                if (e != null) {
                    emitter.error((Throwable)e);
                    return;
                }
                emitter.onDispose(() -> this.topic.removeListenerAsync((Integer)id));
            });
        }));
    }
}

