/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.balancer.LoadBalancerManager;
import org.redisson.connection.pool.MasterConnectionPool;
import org.redisson.connection.pool.MasterPubSubConnectionPool;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    LoadBalancerManager slaveBalancer;
    ClientConnectionsEntry masterEntry;
    int references;
    final MasterSlaveServersConfig config;
    final ConnectionManager connectionManager;
    final MasterConnectionPool writeConnectionPool;
    final MasterPubSubConnectionPool pubSubConnectionPool;
    final AtomicBoolean active = new AtomicBoolean(true);

    public MasterSlaveEntry(ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        this.connectionManager = connectionManager;
        this.config = config;
        this.slaveBalancer = new LoadBalancerManager(config, connectionManager, this);
        this.writeConnectionPool = new MasterConnectionPool(config, connectionManager, this);
        this.pubSubConnectionPool = new MasterPubSubConnectionPool(config, connectionManager, this);
    }

    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<Void> initSlaveBalancer(Collection<RedisURI> disconnectedNodes) {
        return this.initSlaveBalancer(disconnectedNodes, null);
    }

    public CompletableFuture<Void> initSlaveBalancer(Collection<RedisURI> disconnectedNodes, String slaveSSLHostname) {
        ArrayList<CompletableFuture<Void>> result = new ArrayList<CompletableFuture<Void>>(this.config.getSlaveAddresses().size());
        for (String address : this.config.getSlaveAddresses()) {
            RedisURI uri = new RedisURI(address);
            CompletableFuture<Void> f = this.addSlave(uri, disconnectedNodes.contains(uri), NodeType.SLAVE, slaveSSLHostname);
            result.add(f);
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(result.toArray(new CompletableFuture[0]));
        return future.thenAccept(v -> this.useMasterAsSlave());
    }

    private void useMasterAsSlave() {
        if (this.slaveBalancer.getAvailableClients() == 0) {
            this.slaveUp(this.masterEntry.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM);
        } else {
            this.slaveDown(this.masterEntry.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM);
        }
    }

    public CompletableFuture<RedisClient> setupMasterEntry(InetSocketAddress address, RedisURI uri) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, uri, null);
        return this.setupMasterEntry(client);
    }

    public CompletableFuture<RedisClient> setupMasterEntry(RedisURI address) {
        return this.setupMasterEntry(address, null);
    }

    public CompletableFuture<RedisClient> setupMasterEntry(RedisURI address, String sslHostname) {
        RedisClient client = this.connectionManager.createClient(NodeType.MASTER, address, sslHostname);
        return this.setupMasterEntry(client);
    }

    private CompletableFuture<RedisClient> setupMasterEntry(RedisClient client) {
        CompletableFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        return ((CompletableFuture)((CompletableFuture)addrFuture.thenCompose(res -> {
            this.masterEntry = new ClientConnectionsEntry(client, this.config.getMasterConnectionMinimumIdleSize(), this.config.getMasterConnectionPoolSize(), this.config.getSubscriptionConnectionMinimumIdleSize(), this.config.getSubscriptionConnectionPoolSize(), this.connectionManager, NodeType.MASTER);
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            if (!this.config.checkSkipSlavesInit() && !this.slaveBalancer.contains(client.getAddr())) {
                CompletableFuture<Void> masterAsSlaveFuture = this.addSlave(client.getAddr(), client.getConfig().getAddress(), true, NodeType.MASTER, client.getConfig().getSslHostname());
                futures.add(masterAsSlaveFuture);
            }
            CompletableFuture writeFuture = this.writeConnectionPool.add(this.masterEntry);
            futures.add(writeFuture);
            if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
                CompletableFuture pubSubFuture = this.pubSubConnectionPool.add(this.masterEntry);
                futures.add(pubSubFuture);
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        })).whenComplete((r, e) -> {
            if (e != null) {
                client.shutdownAsync();
            }
        })).thenApply(r -> client);
    }

    public boolean slaveDown(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry e = this.slaveBalancer.freeze(entry, freezeReason);
        if (e == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    public boolean slaveDown(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.slaveBalancer.freeze(address, freezeReason);
        if (entry == null) {
            return false;
        }
        return this.slaveDown(entry);
    }

    private boolean slaveDown(ClientConnectionsEntry entry) {
        if (entry.isMasterForRead()) {
            return false;
        }
        if (!this.config.checkSkipSlavesInit() && this.slaveBalancer.getAvailableClients() == 0 && this.slaveBalancer.unfreeze(this.masterEntry.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} used as slave", (Object)this.masterEntry.getClient().getAddr());
        }
        return this.nodeDown(entry);
    }

    public void masterDown() {
        this.nodeDown(this.masterEntry);
    }

    public boolean nodeDown(ClientConnectionsEntry entry) {
        Object connection;
        entry.reset();
        for (RedisConnection connection2 : entry.getAllConnections()) {
            connection2.closeAsync();
            this.reattachBlockingQueue(connection2.getCurrentCommand());
        }
        while ((connection = entry.pollConnection(null)) != null) {
        }
        entry.getAllConnections().clear();
        connection = entry.getAllSubscribeConnections().iterator();
        while (connection.hasNext()) {
            RedisConnection connection2;
            connection2 = (RedisPubSubConnection)connection.next();
            connection2.closeAsync();
            this.connectionManager.getSubscribeService().reattachPubSub((RedisPubSubConnection)connection2);
        }
        while ((connection = entry.pollSubscribeConnection()) != null) {
        }
        entry.getAllSubscribeConnections().clear();
        return true;
    }

    private void reattachBlockingQueue(CommandData<?, ?> commandData) {
        MasterSlaveEntry entry;
        if (commandData == null || !commandData.isBlockingCommand() || commandData.getPromise().isDone()) {
            return;
        }
        String key = null;
        for (int i = 0; i < commandData.getParams().length; ++i) {
            Object param = commandData.getParams()[i];
            if (!"STREAMS".equals(param)) continue;
            key = (String)commandData.getParams()[i + 1];
            break;
        }
        if (key == null) {
            key = (String)commandData.getParams()[0];
        }
        if ((entry = this.connectionManager.getEntry(key)) == null) {
            this.connectionManager.newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
            return;
        }
        CompletableFuture<RedisConnection> newConnectionFuture = entry.connectionWriteOp(commandData.getCommand());
        newConnectionFuture.whenComplete((newConnection, e) -> {
            if (e != null) {
                this.connectionManager.newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                return;
            }
            if (commandData.getPromise().isDone()) {
                entry.releaseWrite((RedisConnection)newConnection);
                return;
            }
            ChannelFuture channelFuture = newConnection.send(commandData);
            channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (!future.isSuccess()) {
                    this.connectionManager.newTimeout(timeout -> this.reattachBlockingQueue(commandData), 1L, TimeUnit.SECONDS);
                }
            }));
            commandData.getPromise().whenComplete((r, ex) -> entry.releaseWrite((RedisConnection)newConnection));
        });
    }

    public boolean hasSlave(RedisClient redisClient) {
        return this.slaveBalancer.contains(redisClient);
    }

    public boolean hasSlave(InetSocketAddress addr) {
        return this.slaveBalancer.contains(addr);
    }

    public boolean hasSlave(RedisURI addr) {
        return this.slaveBalancer.contains(addr);
    }

    public int getAvailableSlaves() {
        return this.slaveBalancer.getAvailableSlaves();
    }

    public int getAvailableClients() {
        return this.slaveBalancer.getAvailableClients();
    }

    public CompletableFuture<Void> addSlave(RedisURI address) {
        return this.addSlave(address, false, NodeType.SLAVE, null);
    }

    public CompletableFuture<Void> addSlave(InetSocketAddress address, RedisURI uri) {
        return this.addSlave(address, uri, false, NodeType.SLAVE, null);
    }

    public CompletableFuture<Void> addSlave(InetSocketAddress address, RedisURI uri, String sslHostname) {
        return this.addSlave(address, uri, false, NodeType.SLAVE, sslHostname);
    }

    private CompletableFuture<Void> addSlave(RedisClient client, boolean freezed, NodeType nodeType) {
        CompletableFuture<InetSocketAddress> addrFuture = client.resolveAddr();
        return ((CompletableFuture)addrFuture.thenCompose(res -> {
            ClientConnectionsEntry entry = new ClientConnectionsEntry(client, this.config.getSlaveConnectionMinimumIdleSize(), this.config.getSlaveConnectionPoolSize(), this.config.getSubscriptionConnectionMinimumIdleSize(), this.config.getSubscriptionConnectionPoolSize(), this.connectionManager, nodeType);
            if (freezed) {
                ClientConnectionsEntry clientConnectionsEntry = entry;
                synchronized (clientConnectionsEntry) {
                    entry.setFreezeReason(ClientConnectionsEntry.FreezeReason.SYSTEM);
                }
            }
            return this.slaveBalancer.add(entry);
        })).whenComplete((r, ex) -> {
            if (ex != null) {
                client.shutdownAsync();
            }
        });
    }

    private CompletableFuture<Void> addSlave(InetSocketAddress address, RedisURI uri, boolean freezed, NodeType nodeType, String sslHostname) {
        RedisClient client = this.connectionManager.createClient(NodeType.SLAVE, address, uri, sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    public CompletableFuture<Void> addSlave(RedisURI address, boolean freezed, NodeType nodeType, String sslHostname) {
        RedisClient client = this.connectionManager.createClient(nodeType, address, sslHostname);
        return this.addSlave(client, freezed, nodeType);
    }

    public Collection<ClientConnectionsEntry> getAllEntries() {
        return this.slaveBalancer.getEntries();
    }

    public ClientConnectionsEntry getEntry(RedisClient redisClient) {
        return this.slaveBalancer.getEntry(redisClient);
    }

    public ClientConnectionsEntry getEntry(RedisURI addr) {
        return this.slaveBalancer.getEntry(addr);
    }

    public RedisClient getClient() {
        return this.masterEntry.getClient();
    }

    public boolean slaveUp(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(entry, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(entry.getClient().getAddr()) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean isSlaveUnfreezed(RedisURI address) {
        return this.slaveBalancer.isUnfreezed(address);
    }

    public boolean slaveUp(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !RedisURI.compare(addr, address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public boolean slaveUp(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (!this.slaveBalancer.unfreeze(address, freezeReason)) {
            return false;
        }
        InetSocketAddress addr = this.masterEntry.getClient().getAddr();
        if (!this.config.checkSkipSlavesInit() && !addr.equals(address) && this.slaveDown(addr, ClientConnectionsEntry.FreezeReason.SYSTEM)) {
            this.log.info("master {} excluded from slaves", (Object)addr);
        }
        return true;
    }

    public CompletableFuture<RedisClient> changeMaster(RedisURI address) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        CompletableFuture<RedisClient> future = this.setupMasterEntry(address);
        return this.changeMaster(address, oldMaster, future);
    }

    public CompletableFuture<RedisClient> changeMaster(InetSocketAddress address, RedisURI uri) {
        ClientConnectionsEntry oldMaster = this.masterEntry;
        CompletableFuture<RedisClient> future = this.setupMasterEntry(address, uri);
        return this.changeMaster(uri, oldMaster, future);
    }

    private CompletableFuture<RedisClient> changeMaster(RedisURI address, ClientConnectionsEntry oldMaster, CompletableFuture<RedisClient> future) {
        return future.whenComplete((newMasterClient, e) -> {
            if (e != null) {
                if (oldMaster != this.masterEntry) {
                    this.writeConnectionPool.remove(this.masterEntry);
                    this.pubSubConnectionPool.remove(this.masterEntry);
                    this.masterEntry.shutdownAsync();
                    this.masterEntry = oldMaster;
                }
                this.log.error("Unable to change master from: " + oldMaster.getClient().getAddr() + " to: " + address, (Throwable)e);
                return;
            }
            this.writeConnectionPool.remove(oldMaster);
            this.pubSubConnectionPool.remove(oldMaster);
            ClientConnectionsEntry clientConnectionsEntry = oldMaster;
            synchronized (clientConnectionsEntry) {
                oldMaster.setFreezeReason(ClientConnectionsEntry.FreezeReason.MANAGER);
            }
            this.nodeDown(oldMaster);
            this.slaveBalancer.changeType(oldMaster.getClient().getAddr(), NodeType.SLAVE);
            this.slaveBalancer.changeType(newMasterClient.getAddr(), NodeType.MASTER);
            this.slaveDown(oldMaster.getClient().getAddr(), ClientConnectionsEntry.FreezeReason.MANAGER);
            if (!this.config.checkSkipSlavesInit()) {
                this.useMasterAsSlave();
            }
            oldMaster.shutdownAsync();
            this.log.info("master {} has changed to {}", (Object)oldMaster.getClient().getAddr(), (Object)this.masterEntry.getClient().getAddr());
        });
    }

    public CompletableFuture<Void> shutdownAsync() {
        if (!this.active.compareAndSet(true, false)) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (this.masterEntry != null) {
            futures.add(this.masterEntry.shutdownAsync());
        }
        futures.add(this.slaveBalancer.shutdownAsync());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public CompletableFuture<RedisConnection> connectionWriteOp(RedisCommand<?> command) {
        return this.writeConnectionPool.get(command);
    }

    public CompletableFuture<RedisConnection> redirectedConnectionWriteOp(RedisCommand<?> command, RedisURI addr) {
        return this.slaveBalancer.getConnection(command, addr);
    }

    public CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.nextConnection(command);
    }

    public CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, RedisURI addr) {
        return this.slaveBalancer.getConnection(command, addr);
    }

    public CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command, RedisClient client) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            return this.connectionWriteOp(command);
        }
        return this.slaveBalancer.getConnection(command, client);
    }

    public CompletableFuture<RedisPubSubConnection> nextPubSubConnection() {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            return this.pubSubConnectionPool.get();
        }
        return this.slaveBalancer.nextPubSubConnection();
    }

    public void returnPubSubConnection(RedisPubSubConnection connection) {
        if (this.config.getSubscriptionMode() == SubscriptionMode.MASTER) {
            this.pubSubConnectionPool.returnConnection(this.masterEntry, connection);
            return;
        }
        this.slaveBalancer.returnPubSubConnection(connection);
    }

    public void releaseWrite(RedisConnection connection) {
        this.writeConnectionPool.returnConnection(this.masterEntry, connection);
    }

    public void releaseRead(RedisConnection connection) {
        if (this.config.getReadMode() == ReadMode.MASTER) {
            this.releaseWrite(connection);
            return;
        }
        this.slaveBalancer.returnConnection(connection);
    }

    public void incReference() {
        ++this.references;
    }

    public int decReference() {
        return --this.references;
    }

    public int getReferences() {
        return this.references;
    }

    public String toString() {
        return "MasterSlaveEntry [masterEntry=" + this.masterEntry + "]";
    }
}

