/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.redisson.RedissonQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RRingBuffer;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonPromise;

public class RedissonRingBuffer<V>
extends RedissonQueue<V>
implements RRingBuffer<V> {
    private static final RedisStrictCommand<Integer> GET_INTEGER = new RedisStrictCommand<Integer>("GET", new IntegerReplayConvertor(0));
    private final String settingsName = RedissonRingBuffer.prefixName("redisson_rb", this.getRawName());

    public RedissonRingBuffer(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonRingBuffer(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.SETNX, this.settingsName, capacity);
    }

    @Override
    public boolean trySetCapacity(int capacity) {
        return this.get(this.trySetCapacityAsync(capacity));
    }

    @Override
    public RFuture<Void> setCapacityAsync(int capacity) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "redis.call('set', KEYS[2], ARGV[1]); local len = redis.call('llen', KEYS[1]); redis.call('ltrim', KEYS[1], len - tonumber(ARGV[1]), len - 1); ", Arrays.asList(this.getRawName(), this.settingsName), capacity);
    }

    @Override
    public void setCapacity(int capacity) {
        this.get(this.setCapacityAsync(capacity));
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local limit = redis.call('get', KEYS[2]); assert(limit ~= false, 'RingBuffer capacity is not defined'); local size = redis.call('rpush', KEYS[1], ARGV[1]); if size > tonumber(limit) then redis.call('lpop', KEYS[1]); end; return 1; ", Arrays.asList(this.getRawName(), this.settingsName), this.encode((Object)e));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<Object> args = new ArrayList<Object>(c.size());
        this.encode(args, c);
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local limit = redis.call('get', KEYS[2]); assert(limit ~= false, 'RingBuffer capacity is not defined'); local size = 0; for i=1, #ARGV,5000 do size = redis.call('rpush', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); end; local extraSize = size - tonumber(limit); if extraSize > 0 then redis.call('ltrim', KEYS[1], extraSize, -1); end; return 1; ", Arrays.asList(this.getRawName(), this.settingsName), args.toArray());
    }

    @Override
    public int remainingCapacity() {
        return this.get(this.remainingCapacityAsync());
    }

    @Override
    public RFuture<Integer> remainingCapacityAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local limit = redis.call('get', KEYS[2]); assert(limit ~= false, 'RingBuffer capacity is not defined'); local size = redis.call('llen', KEYS[1]); return math.max(tonumber(limit) - size, 0); ", Arrays.asList(this.getRawName(), this.settingsName), new Object[0]);
    }

    @Override
    public RFuture<Integer> capacityAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, GET_INTEGER, this.settingsName);
    }

    @Override
    public int capacity() {
        return this.get(this.capacityAsync());
    }
}

