/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonBaseLock;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.client.RedisException;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.LockPubSub;

public class RedissonLock
extends RedissonBaseLock {
    protected long internalLockLeaseTime;
    protected final LockPubSub pubSub;
    final CommandAsyncExecutor commandExecutor;

    public RedissonLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.internalLockLeaseTime = commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout();
        this.pubSub = commandExecutor.getConnectionManager().getSubscribeService().getLockPubSub();
    }

    String getChannelName() {
        return RedissonLock.prefixName("redisson_lock__channel", this.getRawName());
    }

    @Override
    public void lock() {
        try {
            this.lock(-1L, null, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lock(leaseTime, unit, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock(-1L, null, true);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        this.lock(leaseTime, unit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(long leaseTime, TimeUnit unit, boolean interruptibly) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(-1L, leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        CompletableFuture<RedissonLockEntry> future = this.subscribe(threadId);
        if (interruptibly) {
            this.commandExecutor.syncSubscriptionInterrupted(future);
        } else {
            this.commandExecutor.syncSubscription(future);
        }
        try {
            while ((ttl = this.tryAcquire(-1L, leaseTime, unit, threadId)) != null) {
                if (ttl >= 0L) {
                    try {
                        this.commandExecutor.getNow(future).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (interruptibly) {
                            throw e;
                        }
                        this.commandExecutor.getNow(future).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    continue;
                }
                if (interruptibly) {
                    this.commandExecutor.getNow(future).getLatch().acquire();
                    continue;
                }
                this.commandExecutor.getNow(future).getLatch().acquireUninterruptibly();
            }
        }
        finally {
            this.unsubscribe(this.commandExecutor.getNow(future), threadId);
        }
    }

    private Long tryAcquire(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync(waitTime, leaseTime, unit, threadId));
    }

    private RFuture<Boolean> tryAcquireOnceAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        RFuture<Boolean> acquiredFuture = leaseTime != -1L ? this.tryLockInnerAsync(waitTime, leaseTime, unit, threadId, RedisCommands.EVAL_NULL_BOOLEAN) : this.tryLockInnerAsync(waitTime, this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        CompletionStage<Boolean> f = acquiredFuture.thenApply(acquired -> {
            if (acquired.booleanValue()) {
                if (leaseTime != -1L) {
                    this.internalLockLeaseTime = unit.toMillis(leaseTime);
                } else {
                    this.scheduleExpirationRenewal(threadId);
                }
            }
            return acquired;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    private <T> RFuture<Long> tryAcquireAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        RFuture<Long> ttlRemainingFuture = leaseTime != -1L ? this.tryLockInnerAsync(waitTime, leaseTime, unit, threadId, RedisCommands.EVAL_LONG) : this.tryLockInnerAsync(waitTime, this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_LONG);
        CompletionStage<Long> f = ttlRemainingFuture.thenApply(ttlRemaining -> {
            if (ttlRemaining == null) {
                if (leaseTime != -1L) {
                    this.internalLockLeaseTime = unit.toMillis(leaseTime);
                } else {
                    this.scheduleExpirationRenewal(threadId);
                }
            }
            return ttlRemaining;
        });
        return new CompletableFutureWrapper<Long>(f);
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getRawName()), unit.toMillis(leaseTime), this.getLockName(threadId));
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(waitTime, leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        current = System.currentTimeMillis();
        CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe(threadId);
        try {
            subscribeFuture.toCompletableFuture().get(time, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            if (!subscribeFuture.cancel(false)) {
                subscribeFuture.whenComplete((res, ex) -> {
                    if (ex == null) {
                        this.unsubscribe((RedissonLockEntry)res, threadId);
                    }
                });
            }
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                this.acquireFailed(waitTime, unit, threadId);
                boolean e = false;
                return e;
            }
            while (true) {
                long currentTime = System.currentTimeMillis();
                ttl = this.tryAcquire(waitTime, leaseTime, unit, threadId);
                if (ttl == null) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - currentTime) <= 0L) {
                    this.acquireFailed(waitTime, unit, threadId);
                    boolean bl = false;
                    return bl;
                }
                currentTime = System.currentTimeMillis();
                if (ttl >= 0L && ttl < time) {
                    this.commandExecutor.getNow(subscribeFuture).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    this.commandExecutor.getNow(subscribeFuture).getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                if ((time -= System.currentTimeMillis() - currentTime) > 0L) continue;
                this.acquireFailed(waitTime, unit, threadId);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.unsubscribe(this.commandExecutor.getNow(subscribeFuture), threadId);
        }
    }

    protected CompletableFuture<RedissonLockEntry> subscribe(long threadId) {
        return this.pubSub.subscribe(this.getEntryName(), this.getChannelName());
    }

    protected void unsubscribe(RedissonLockEntry entry, long threadId) {
        this.pubSub.unsubscribe(entry, this.getEntryName(), this.getChannelName());
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public void unlock() {
        try {
            this.get(this.unlockAsync(Thread.currentThread().getId()));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IllegalMonitorStateException) {
                throw (IllegalMonitorStateException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getRawName(), this.getChannelName()), LockPubSub.UNLOCK_MESSAGE);
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return nil;", Arrays.asList(this.getRawName(), this.getChannelName()), LockPubSub.UNLOCK_MESSAGE, this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long currentThreadId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(-1L, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe(currentThreadId);
            subscribeFuture.whenComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.lockAsync(leaseTime, unit, (RedissonLockEntry)res, result, currentThreadId);
            });
        });
        return result;
    }

    private void lockAsync(final long leaseTime, final TimeUnit unit, final RedissonLockEntry entry, final RPromise<Void> result, final long currentThreadId) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(-1L, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(entry, currentThreadId);
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(entry, currentThreadId);
                if (!result.trySuccess(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            if (entry.getLatch().tryAcquire()) {
                this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
            } else {
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
                };
                entry.addListener(listener);
                if (ttl >= 0L) {
                    Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                RedissonLock.this.lockAsync(leaseTime, unit, entry, result, currentThreadId);
                            }
                        }
                    }, (long)ttl, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.tryAcquireOnceAsync(-1L, -1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, final long currentThreadId) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final CompletableFuture<RedissonLockEntry> subscribeFuture = this.subscribe(currentThreadId);
            subscribeFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryLockAsync(time, waitTime, leaseTime, unit, (RedissonLockEntry)r, result, currentThreadId);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            subscribeFuture.cancel(false);
                            RedissonLock.this.trySuccessFalse(currentThreadId, result);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return result;
    }

    private void trySuccessFalse(long currentThreadId, RPromise<Boolean> result) {
        this.acquireFailedAsync(-1L, null, currentThreadId).onComplete((res, e) -> {
            if (e == null) {
                result.trySuccess(false);
            } else {
                result.tryFailure((Throwable)e);
            }
        });
    }

    private void tryLockAsync(final AtomicLong time, final long waitTime, final long leaseTime, final TimeUnit unit, final RedissonLockEntry entry, final RPromise<Boolean> result, final long currentThreadId) {
        if (result.isDone()) {
            this.unsubscribe(entry, currentThreadId);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(entry, currentThreadId);
            this.trySuccessFalse(currentThreadId, result);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(entry, currentThreadId);
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(entry, currentThreadId);
                if (!result.trySuccess(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(entry, currentThreadId);
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            final long current = System.currentTimeMillis();
            if (entry.getLatch().tryAcquire()) {
                this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
                };
                entry.addListener(listener);
                long t = time.get();
                if (ttl >= 0L && ttl < time.get()) {
                    t = ttl;
                }
                if (!executed.get()) {
                    Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonLock.this.tryLockAsync(time, waitTime, leaseTime, unit, entry, result, currentThreadId);
                            }
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }
}

