/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonPatternTopic;
import org.redisson.api.ObjectListener;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.listener.SetObjectListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBucket<V>
extends RedissonExpirable
implements RBucket<V> {
    public RedissonBucket(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonBucket(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        if (expect == null && update == null) {
            return this.trySetAsync(null);
        }
        if (expect == null) {
            return this.trySetAsync(update);
        }
        if (update == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('del', KEYS[1]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), this.encode((Object)expect));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), this.encode((Object)expect), this.encode((Object)update));
    }

    @Override
    public V getAndSet(V newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<V> getAndSetAsync(V newValue) {
        if (newValue == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GETSET, this.getRawName(), this.encode((Object)newValue));
    }

    @Override
    public V get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<V> getAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GET, this.getRawName());
    }

    @Override
    public V getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.STRLEN, this.getRawName());
    }

    @Override
    public void set(V value) {
        this.get(this.setAsync(value));
    }

    @Override
    public RFuture<Void> setAsync(V value) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET, this.getRawName(), this.encode((Object)value));
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        this.get(this.setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PSETEX, this.getRawName(), timeUnit.toMillis(timeToLive), this.encode((Object)value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.NOT_EXISTS, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SETNX, this.getRawName(), this.encode((Object)value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode((Object)value), "PX", timeUnit.toMillis(timeToLive), "NX");
    }

    @Override
    public boolean trySet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.trySetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public boolean trySet(V value) {
        return this.get(this.trySetAsync(value));
    }

    @Override
    public boolean setIfExists(V value) {
        return this.get(this.setIfExistsAsync(value));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value) {
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('get', KEYS[1]); if currValue ~= false then redis.call('del', KEYS[1]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode((Object)value), "XX");
    }

    @Override
    public void setAndKeepTTL(V value) {
        this.get(this.setAndKeepTTLAsync(value));
    }

    @Override
    public RFuture<Void> setAndKeepTTLAsync(V value) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET, this.getRawName(), this.encode((Object)value), "KEEPTTL");
    }

    @Override
    public boolean setIfExists(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.setIfExistsAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode((Object)value), "PX", timeUnit.toMillis(timeToLive), "XX");
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode((Object)value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public V getAndSet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.getAndSetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof SetObjectListener) {
            return this.addListener("__keyevent@*:set", (SetObjectListener)listener, SetObjectListener::onSet);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof SetObjectListener) {
            return this.addListenerAsync("__keyevent@*:set", (SetObjectListener)listener, SetObjectListener::onSet);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:set");
        expiredTopic.removeListener(listenerId);
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RedissonPatternTopic setTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:set");
        RFuture<Void> f1 = setTopic.removeListenerAsync(listenerId);
        RFuture<Void> f2 = super.removeListenerAsync(listenerId);
        CompletableFuture<Void> f = CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture());
        return new CompletableFutureWrapper<Void>(f);
    }
}

