/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableThrottleLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;

    public FlowableThrottleLatest(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, boolean emitLast) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ThrottleLatestSubscriber<T>(s, this.timeout, this.unit, this.scheduler.createWorker(), this.emitLast));
    }

    static final class ThrottleLatestSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final Subscriber<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final AtomicLong requested;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        long emitted;
        boolean timerRunning;

        ThrottleLatestSubscriber(Subscriber<? super T> downstream, long timeout, TimeUnit unit, Scheduler.Worker worker, boolean emitLast) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.latest.set(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.latest.lazySet(null);
            }
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            AtomicLong requested = this.requested;
            Subscriber<T> downstream = this.downstream;
            while (true) {
                long e;
                boolean empty;
                if (this.cancelled) {
                    latest.lazySet(null);
                    return;
                }
                boolean d = this.done;
                if (d && this.error != null) {
                    latest.lazySet(null);
                    downstream.onError(this.error);
                    this.worker.dispose();
                    return;
                }
                T v = latest.get();
                boolean bl = empty = v == null;
                if (d) {
                    if (!empty && this.emitLast) {
                        v = latest.getAndSet(null);
                        e = this.emitted;
                        if (e != requested.get()) {
                            this.emitted = e + 1L;
                            downstream.onNext(v);
                            downstream.onComplete();
                        } else {
                            downstream.onError(new MissingBackpressureException("Could not emit final value due to lack of requests"));
                        }
                    } else {
                        latest.lazySet(null);
                        downstream.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v = latest.getAndSet(null);
                    e = this.emitted;
                    if (e == requested.get()) {
                        this.upstream.cancel();
                        downstream.onError(new MissingBackpressureException("Could not emit value due to lack of requests"));
                        this.worker.dispose();
                        return;
                    }
                    downstream.onNext(v);
                    this.emitted = e + 1L;
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.schedule(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

