/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.Callable;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.RPromise;
import org.redisson.rx.CommandRxService;

public class CommandRxBatchService
extends CommandRxService {
    private final CommandBatchService batchService;

    public CommandRxBatchService(ConnectionManager connectionManager, CommandAsyncExecutor executor, BatchOptions options) {
        super(connectionManager, executor.getObjectBuilder());
        this.batchService = new CommandBatchService(executor, options, RedissonObjectBuilder.ReferenceType.RXJAVA);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<RFuture<R>> supplier) {
        Flowable flowable = super.flowable(new Callable<RFuture<R>>(){
            volatile RFuture<R> future;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RFuture<R> call() throws Exception {
                if (this.future == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.future == null) {
                            this.future = (RFuture)supplier.call();
                        }
                    }
                }
                return this.future;
            }
        });
        flowable.subscribe();
        return flowable;
    }

    @Override
    protected <R> RPromise<R> createPromise() {
        return this.batchService.createPromise();
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect, boolean noRetry) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, ignoreRedirect, noRetry);
    }

    public RFuture<BatchResult<?>> executeAsync() {
        return this.batchService.executeAsync();
    }

    public RFuture<Void> discardAsync() {
        return this.batchService.discardAsync();
    }
}

