/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.pool;

import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.ConnectionPool;

public class PubSubConnectionPool
extends ConnectionPool<RedisPubSubConnection> {
    public PubSubConnectionPool(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry masterSlaveEntry) {
        super(config, connectionManager, masterSlaveEntry);
    }

    public RFuture<RedisPubSubConnection> get() {
        return this.get(RedisCommands.PUBLISH);
    }

    @Override
    protected RedisPubSubConnection poll(ClientConnectionsEntry entry, RedisCommand<?> command) {
        return entry.pollSubscribeConnection();
    }

    @Override
    protected int getMinimumIdleSize(ClientConnectionsEntry entry) {
        return this.config.getSubscriptionConnectionMinimumIdleSize();
    }

    @Override
    protected CompletionStage<RedisPubSubConnection> connect(ClientConnectionsEntry entry) {
        return entry.connectPubSub();
    }

    @Override
    protected void acquireConnection(ClientConnectionsEntry entry, Runnable runnable, RedisCommand<?> command) {
        entry.acquireSubscribeConnection(runnable);
    }

    @Override
    protected void releaseConnection(ClientConnectionsEntry entry) {
        entry.releaseSubscribeConnection();
    }

    @Override
    protected void releaseConnection(ClientConnectionsEntry entry, RedisPubSubConnection conn) {
        entry.releaseSubscribeConnection(conn);
    }
}

