/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class AnnotationParser {
    protected final Annotation defaultAnnotation;
    protected final Class<? extends Annotation> annotationClass;

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationClass;
    }

    public AnnotationParser(Class<? extends Annotation> annotationClass) {
        this(annotationClass, annotationClass);
    }

    public AnnotationParser(Class<? extends Annotation> annotationClass, Class<? extends Annotation> defaultAnnotationClass) {
        if (annotationClass == null) {
            Class[] genericSupertypes = ClassUtil.getGenericSupertypes(this.getClass());
            if (genericSupertypes != null) {
                annotationClass = genericSupertypes[0];
            }
            if (annotationClass == null || annotationClass == Annotation.class) {
                throw new IllegalArgumentException("Missing annotation from generics supertype");
            }
        }
        this.annotationClass = annotationClass;
        if (defaultAnnotationClass != null && defaultAnnotationClass != annotationClass) {
            Annotation defaultAnnotation = annotationClass.getAnnotation(defaultAnnotationClass);
            if (defaultAnnotation == null) {
                try {
                    defaultAnnotation = defaultAnnotationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.defaultAnnotation = defaultAnnotation;
        } else {
            this.defaultAnnotation = null;
        }
    }

    public boolean hasAnnotationOn(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(this.annotationClass);
    }

    public Reader of(AnnotatedElement annotatedElement) {
        return new Reader(annotatedElement);
    }

    public class Reader {
        private final AnnotatedElement annotatedElement;

        private Reader(AnnotatedElement annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public Class<? extends Annotation> annotationType() {
            return AnnotationParser.this.annotationClass;
        }

        protected String readStringElement(String name) {
            Annotation annotation = this.annotatedElement.getAnnotation(AnnotationParser.this.annotationClass);
            Object annotationValue = ClassUtil.readAnnotationValue(annotation, name);
            if (annotationValue == null) {
                if (AnnotationParser.this.defaultAnnotation == null) {
                    return null;
                }
                annotationValue = ClassUtil.readAnnotationValue(AnnotationParser.this.defaultAnnotation, name);
                if (annotationValue == null) {
                    return null;
                }
            }
            String value = StringUtil.toSafeString(annotationValue);
            return value.trim();
        }

        public Object readElement(String name) {
            Annotation annotation = this.annotatedElement.getAnnotation(AnnotationParser.this.annotationClass);
            Object annotationValue = ClassUtil.readAnnotationValue(annotation, name);
            if (annotationValue == null && AnnotationParser.this.defaultAnnotation != null) {
                annotationValue = ClassUtil.readAnnotationValue(AnnotationParser.this.defaultAnnotation, name);
            }
            return annotationValue;
        }

        public String readString(String name, String defaultValue) {
            String value = this.readStringElement(name);
            if (StringUtil.isEmpty(value)) {
                value = defaultValue;
            }
            return value;
        }

        public boolean readBoolean(String name, boolean defaultValue) {
            Boolean value = (Boolean)this.readElement(name);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public int readInt(String name, int defaultValue) {
            Integer value = (Integer)this.readElement(name);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
    }
}

