/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.resolver.AddressResolver;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.redisson.api.NatMapper;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAuthRequiredException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.AsyncCountDownLatch;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RedisURI> sentinelHosts = new HashSet<RedisURI>();
    private final ConcurrentMap<RedisURI, RedisClient> sentinels = new ConcurrentHashMap<RedisURI, RedisClient>();
    private final AtomicReference<RedisURI> currentMaster = new AtomicReference();
    private final Set<RedisURI> disconnectedSlaves = new HashSet<RedisURI>();
    private ScheduledFuture<?> monitorFuture;
    private AddressResolver<InetSocketAddress> sentinelResolver;
    private final NatMapper natMapper;
    private final String sentinelPassword;
    private boolean usePassword = false;
    private String scheme;
    private boolean checkSlaveStatusWithSyncing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config, UUID id) {
        super(config, id);
        if (cfg.getMasterName() == null) {
            throw new IllegalArgumentException("masterName parameter is not defined!");
        }
        if (cfg.getSentinelAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one sentinel node should be defined!");
        }
        this.config = this.create(cfg);
        this.sentinelPassword = cfg.getSentinelPassword();
        this.checkSlaveStatusWithSyncing = cfg.isCheckSlaveStatusWithSyncing();
        this.initTimer(this.config);
        this.natMapper = cfg.getNatMapper();
        this.sentinelResolver = this.resolverGroup.getResolver(this.getGroup().next());
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            this.scheme = addr.getScheme();
            if (NetUtil.createByteArrayFromIpAddressString((addr = this.applyNatMap(addr)).getHost()) != null || addr.getHost().equals("localhost")) continue;
            this.sentinelHosts.add(addr);
        }
        this.checkAuth(cfg);
        Exception lastException = null;
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisURI uri;
                RedisConnection connection = null;
                try {
                    connection = client.connect();
                    if (!connection.isActive()) continue;
                }
                catch (RedisConnectionException e) {}
                continue;
                RedisURI master = connection.sync(RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
                if (master == null) {
                    throw new RedisConnectionException("Master node is undefined! SENTINEL GET-MASTER-ADDR-BY-NAME command returns empty result!");
                }
                RedisURI masterHost = this.resolveIP(this.scheme, master).syncUninterruptibly().getNow();
                this.config.setMasterAddress(masterHost.toString());
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                List sentinelSlaves = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String host = (String)map.get("ip");
                    String port = (String)map.get("port");
                    String flags = map.getOrDefault("flags", "");
                    String string = map.getOrDefault("master-link-status", "");
                    uri = this.resolveIP(host, port).syncUninterruptibly().getNow();
                    this.config.addSlaveAddress(uri.toString());
                    this.log.debug("slave {} state: {}", (Object)uri, (Object)map);
                    this.log.info("slave: {} added", (Object)uri);
                    if (!this.isSlaveDown(flags, string)) continue;
                    this.disconnectedSlaves.add(uri);
                    this.log.warn("slave: {} is down", (Object)uri);
                }
                List sentinelSentinels = (List)connection.sync(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
                ArrayList<RFuture<Void>> connectionFutures = new ArrayList<RFuture<Void>>(sentinelSentinels.size());
                for (Map map : sentinelSentinels) {
                    if (map.isEmpty()) continue;
                    String ip = (String)map.get("ip");
                    String string = (String)map.get("port");
                    uri = this.resolveIP(ip, string).syncUninterruptibly().getNow();
                    RFuture<Void> future = this.registerSentinel(uri, this.config, null);
                    connectionFutures.add(future);
                }
                RedisURI sentinelIp = this.toURI(connection.getRedisClient().getAddr());
                RFuture<Void> f = this.registerSentinel(sentinelIp, this.config, null);
                connectionFutures.add(f);
                for (RFuture rFuture : connectionFutures) {
                    rFuture.awaitUninterruptibly(this.config.getConnectTimeout());
                }
                break;
            }
            catch (RedisConnectionException e) {
                this.stopThreads();
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                this.log.warn(e.getMessage());
            }
            finally {
                client.shutdownAsync();
            }
        }
        if (cfg.isCheckSentinelsList()) {
            if (this.sentinels.isEmpty()) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns empty result! Set checkSentinelsList = false to avoid this check.", lastException);
            }
            if (this.sentinels.size() < 2) {
                this.stopThreads();
                throw new RedisConnectionException("SENTINEL SENTINELS command returns less than 2 nodes! At least two sentinels should be defined in Redis configuration. Set checkSentinelsList = false to avoid this check.", lastException);
            }
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!", lastException);
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found!");
        }
        this.initSingleEntry();
        this.scheduleChangeCheck(cfg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuth(SentinelServersConfig cfg) {
        if (cfg.getPassword() == null) {
            return;
        }
        for (String address : cfg.getSentinelAddresses()) {
            RedisURI addr = new RedisURI(address);
            addr = this.applyNatMap(addr);
            RedisClient client = this.createClient(NodeType.SENTINEL, addr, this.config.getConnectTimeout(), this.config.getTimeout(), null);
            try {
                RedisConnection c = client.connect();
                if (this.config.getPingConnectionInterval() == 0) {
                    c.sync(RedisCommands.PING, new Object[0]);
                }
                return;
            }
            catch (RedisAuthRequiredException e) {
                this.usePassword = true;
                return;
            }
            catch (RedisConnectionException e) {
                this.log.warn("Can't connect to sentinel server", e);
            }
            catch (Exception exception) {}
            continue;
            finally {
                client.shutdown();
            }
        }
        this.stopThreads();
        StringBuilder list = new StringBuilder();
        for (String address : cfg.getSentinelAddresses()) {
            list.append(address).append(", ");
        }
        throw new RedisConnectionException("Unable to connect to Redis sentinel servers: " + list);
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
        if (this.config.getDnsMonitoringInterval() == -1L || this.sentinelHosts.isEmpty()) {
            return;
        }
        this.scheduleSentinelDNSCheck();
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        if (type == NodeType.SENTINEL && !this.usePassword) {
            result.setUsername(null);
            result.setPassword(null);
        } else if (type == NodeType.SENTINEL && this.usePassword) {
            result.setUsername(null);
            if (this.sentinelPassword != null) {
                result.setPassword(this.sentinelPassword);
            }
        }
        return result;
    }

    private void scheduleSentinelDNSCheck() {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicInteger sentinelsCounter = new AtomicInteger(SentinelConnectionManager.this.sentinelHosts.size());
                SentinelConnectionManager.this.performSentinelDNSCheck(future -> {
                    if (sentinelsCounter.decrementAndGet() == 0) {
                        SentinelConnectionManager.this.scheduleSentinelDNSCheck();
                    }
                });
            }
        }, this.config.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    private void performSentinelDNSCheck(FutureListener<List<InetSocketAddress>> commonListener) {
        for (RedisURI host : this.sentinelHosts) {
            Future<List<InetSocketAddress>> allNodes = this.sentinelResolver.resolveAll(InetSocketAddress.createUnresolved(host.getHost(), host.getPort()));
            allNodes.addListener(future -> {
                if (!future.isSuccess()) {
                    this.log.error("Unable to resolve " + host.getHost(), future.cause());
                    return;
                }
                ((List)future.getNow()).stream().map(addr -> this.toURI((InetSocketAddress)addr)).filter(uri -> !this.sentinels.containsKey(uri)).forEach(uri -> this.registerSentinel((RedisURI)uri, this.getConfig(), host.getHost()));
            });
            if (commonListener == null) continue;
            allNodes.addListener(commonListener);
        }
    }

    private void scheduleChangeCheck(final SentinelServersConfig cfg, final Iterator<RedisClient> iterator) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicReference lastException = new AtomicReference();
                Iterator iter = iterator;
                if (iter == null) {
                    ArrayList clients = new ArrayList(SentinelConnectionManager.this.sentinels.values());
                    Collections.shuffle(clients);
                    iter = clients.iterator();
                }
                SentinelConnectionManager.this.checkState(cfg, iter, lastException);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkState(SentinelServersConfig cfg, Iterator<RedisClient> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.performSentinelDNSCheck(null);
            this.scheduleChangeCheck(cfg, null);
            return;
        }
        if (!this.getShutdownLatch().acquire()) {
            return;
        }
        RedisClient client = iterator.next();
        RedisURI addr = this.toURI(client.getAddr());
        RFuture<RedisConnection> connectionFuture = this.connectToNode(NodeType.SENTINEL, cfg, addr, null);
        connectionFuture.onComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkState(cfg, iterator, lastException);
                return;
            }
            this.updateState(cfg, (RedisConnection)connection, iterator);
        });
    }

    private void updateState(final SentinelServersConfig cfg, final RedisConnection connection, final Iterator<RedisClient> iterator) {
        final AtomicInteger commands = new AtomicInteger(2);
        BiConsumer<Object, Throwable> commonListener = new BiConsumer<Object, Throwable>(){
            private final AtomicBoolean failed = new AtomicBoolean();

            @Override
            public void accept(Object t, Throwable u) {
                if (commands.decrementAndGet() == 0) {
                    SentinelConnectionManager.this.getShutdownLatch().release();
                    if (this.failed.get()) {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, iterator);
                    } else {
                        SentinelConnectionManager.this.scheduleChangeCheck(cfg, null);
                    }
                }
                if (u != null && this.failed.compareAndSet(false, true)) {
                    SentinelConnectionManager.this.log.error("Can't execute SENTINEL commands on " + connection.getRedisClient().getAddr(), u);
                    SentinelConnectionManager.this.closeNodeConnection(connection);
                }
            }
        };
        RFuture<RedisURI> masterFuture = this.checkMasterChange(cfg, connection);
        masterFuture.onComplete((BiConsumer<RedisURI, Throwable>)commonListener);
        if (!this.config.checkSkipSlavesInit()) {
            commands.incrementAndGet();
            RFuture<List<Map<String, String>>> slavesFuture = this.checkSlavesChange(cfg, connection);
            slavesFuture.onComplete((BiConsumer<List<Map<String, String>>, Throwable>)commonListener);
        }
        RFuture<List<Map<String, String>>> sentinelsFuture = this.checkSentinelsChange(cfg, connection);
        sentinelsFuture.onComplete((BiConsumer<List<Map<String, String>>, Throwable>)commonListener);
    }

    private RFuture<List<Map<String, String>>> checkSentinelsChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture<List<Map<String, String>>> sentinelsFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SENTINELS, cfg.getMasterName());
        sentinelsFuture.onComplete((list, e) -> {
            if (e != null || list.isEmpty()) {
                return;
            }
            AsyncCountDownLatch latch = new AsyncCountDownLatch();
            List newUris = list.stream().filter(m -> {
                String flags = m.getOrDefault("flags", "");
                String masterLinkStatus = m.getOrDefault("master-link-status", "");
                return !m.isEmpty() && !this.isSlaveDown(flags, masterLinkStatus);
            }).map(m -> {
                String ip = (String)m.get("ip");
                String port = (String)m.get("port");
                return this.toURI(ip, port);
            }).map(addr -> {
                RFuture<RedisURI> f = this.resolveIP((RedisURI)addr);
                f.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.log.error("unable to resolve hostname", (Throwable)ex);
                    }
                    latch.countDown();
                });
                return f;
            }).collect(Collectors.toList());
            latch.latch(() -> {
                List<RedisURI> uris = newUris.stream().map(u -> (RedisURI)u.getNow()).filter(u -> u != null).collect(Collectors.toList());
                InetSocketAddress addr = connection.getRedisClient().getAddr();
                RedisURI currentAddr = this.toURI(addr);
                uris.add(currentAddr);
                this.updateSentinels(uris);
            }, newUris.size());
        });
        return sentinelsFuture;
    }

    private RFuture<List<Map<String, String>>> checkSlavesChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture<List<Map<String, String>>> slavesFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
        slavesFuture.onComplete((slavesMap, ex) -> {
            if (ex != null) {
                return;
            }
            HashSet currentSlaves = new HashSet(slavesMap.size());
            AsyncCountDownLatch latch = new AsyncCountDownLatch();
            for (Map map : slavesMap) {
                if (map.isEmpty()) {
                    latch.countDown();
                    continue;
                }
                String host = (String)map.get("ip");
                String port = (String)map.get("port");
                String flags = map.getOrDefault("flags", "");
                String masterLinkStatus = map.getOrDefault("master-link-status", "");
                String masterHost = (String)map.get("master-host");
                String masterPort = (String)map.get("master-port");
                RFuture<RedisURI> slaveAddrFuture = this.resolveIP(host, port);
                RFuture<RedisURI> masterAddrFuture = this.resolveIP(masterHost, masterPort);
                CompletableFuture<Void> resolvedFuture = CompletableFuture.allOf(masterAddrFuture.toCompletableFuture(), slaveAddrFuture.toCompletableFuture());
                resolvedFuture.whenComplete((res, exc) -> {
                    if (exc != null) {
                        this.log.error("Unable to resolve addresses " + host + " and/or " + masterHost, (Throwable)exc);
                        latch.countDown();
                        return;
                    }
                    RedisURI slaveAddr = (RedisURI)slaveAddrFuture.getNow();
                    RedisURI masterAddr = (RedisURI)masterAddrFuture.getNow();
                    if (this.isSlaveDown(flags, masterLinkStatus)) {
                        this.slaveDown(slaveAddr);
                        latch.countDown();
                        return;
                    }
                    if ("?".equals(masterHost) || !this.isUseSameMaster(slaveAddr, masterAddr)) {
                        latch.countDown();
                        return;
                    }
                    currentSlaves.add(slaveAddr);
                    this.addSlave(slaveAddr).onComplete((r, e2) -> {
                        latch.countDown();
                        if (e2 != null) {
                            this.log.error("Unable to add slave " + slaveAddr, (Throwable)e2);
                        }
                    });
                });
            }
            latch.latch(() -> {
                MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
                entry.getAllEntries().stream().map(e -> e.getClient().getAddr()).map(a -> this.toURI(a.getAddress().getHostAddress(), String.valueOf(a.getPort()))).filter(a -> !currentSlaves.contains(a) && !a.equals(this.currentMaster.get())).forEach(a -> this.slaveDown((RedisURI)a));
            }, slavesMap.size());
        });
        return slavesFuture;
    }

    private RFuture<RedisURI> checkMasterChange(SentinelServersConfig cfg, RedisConnection connection) {
        RFuture<RedisURI> masterFuture = connection.async(StringCodec.INSTANCE, RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
        masterFuture.thenCompose(u -> this.resolveIP(this.scheme, (RedisURI)u)).whenComplete((newMaster, e) -> {
            if (e != null) {
                return;
            }
            RedisURI current = this.currentMaster.get();
            if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, (RedisURI)newMaster)) {
                RFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), (RedisURI)newMaster);
                changeFuture.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.currentMaster.compareAndSet((RedisURI)newMaster, current);
                    }
                });
            }
        });
        return masterFuture;
    }

    private void updateSentinels(Collection<RedisURI> newUris) {
        newUris.stream().filter(uri -> !this.sentinels.containsKey(uri)).forEach(uri -> this.registerSentinel((RedisURI)uri, this.getConfig(), null));
        this.sentinels.keySet().stream().filter(uri -> !newUris.contains(uri)).forEach(uri -> {
            RedisClient sentinel = (RedisClient)this.sentinels.remove(uri);
            if (sentinel != null) {
                this.disconnectNode((RedisURI)uri);
                sentinel.shutdownAsync();
                this.log.warn("sentinel: {} is down", uri);
            }
        });
    }

    private RedisURI toURI(String host, String port) {
        if (NetUtil.isValidIpV6Address(host)) {
            byte[] addr = NetUtil.createByteArrayFromIpAddressString(host);
            try {
                InetAddress ia = InetAddress.getByAddress(host, addr);
                host = ia.getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        RedisURI uri = new RedisURI(this.scheme + "://" + host + ":" + port);
        return this.applyNatMap(uri);
    }

    @Override
    protected Collection<RedisURI> getDisconnectedNodes() {
        return this.disconnectedSlaves;
    }

    private RFuture<Void> registerSentinel(RedisURI addr, MasterSlaveServersConfig c, String sslHostname) {
        RedisClient sentinel;
        boolean isHostname;
        boolean bl = isHostname = NetUtil.createByteArrayFromIpAddressString(addr.getHost()) == null;
        if (!isHostname && (sentinel = (RedisClient)this.sentinels.get(addr)) != null) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedisClient client = this.createClient(NodeType.SENTINEL, addr, c.getConnectTimeout(), c.getTimeout(), sslHostname);
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<InetSocketAddress> future = client.resolveAddr();
        future.onComplete((res, e) -> {
            RedisClient sentinel;
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RedisURI ipAddr = this.toURI(client.getAddr());
            if (isHostname && (sentinel = (RedisClient)this.sentinels.get(ipAddr)) != null) {
                result.trySuccess(null);
                return;
            }
            RFuture<RedisConnection> f = client.connectAsync();
            f.onComplete((connection, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                RFuture r = connection.async(RedisCommands.PING, new Object[0]);
                r.onComplete((resp, exc) -> {
                    if (exc != null) {
                        result.tryFailure((Throwable)exc);
                        return;
                    }
                    if (this.sentinels.putIfAbsent(ipAddr, client) == null) {
                        this.log.info("sentinel: {} added", (Object)ipAddr);
                    }
                    result.trySuccess(null);
                });
            });
        });
        return result;
    }

    private RFuture<RedisURI> resolveIP(String host, String port) {
        RedisURI uri = this.toURI(host, port);
        return this.resolveIP(uri);
    }

    private RedisURI toURI(InetSocketAddress addr) {
        return this.toURI(addr.getAddress().getHostAddress(), "" + addr.getPort());
    }

    private RFuture<Void> addSlave(RedisURI uri) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(uri) && !this.config.checkSkipSlavesInit()) {
            RFuture<Void> future = entry.addSlave(uri);
            future.onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    this.log.error("Can't add slave: " + uri, (Throwable)e);
                    return;
                }
                if (entry.isSlaveUnfreezed(uri) || entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                    this.log.info("slave: {} added", (Object)uri);
                    result.trySuccess(null);
                }
            });
        } else {
            if (entry.hasSlave(uri)) {
                this.slaveUp(uri);
            }
            result.trySuccess(null);
        }
        return result;
    }

    private void slaveDown(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.warn("slave: {} is down", (Object)uri);
        } else {
            MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
            if (entry.slaveDown(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
                this.log.warn("slave: {} is down", (Object)uri);
            }
        }
    }

    private boolean isSlaveDown(String flags, String masterLinkStatus) {
        boolean baseStatus;
        boolean bl = baseStatus = flags.contains("s_down") || flags.contains("disconnected");
        if (this.checkSlaveStatusWithSyncing && !StringUtil.isNullOrEmpty(masterLinkStatus)) {
            return baseStatus || masterLinkStatus.contains("err");
        }
        return baseStatus;
    }

    private boolean isUseSameMaster(RedisURI slaveAddr, RedisURI slaveMasterAddr) {
        RedisURI master = this.currentMaster.get();
        if (!master.equals(slaveMasterAddr)) {
            this.log.warn("Skipped slave up {} for master {} differs from current {}", slaveAddr, slaveMasterAddr, master);
            return false;
        }
        return true;
    }

    private void slaveUp(RedisURI uri) {
        if (this.config.checkSkipSlavesInit()) {
            this.log.info("slave: {} is up", (Object)uri);
            return;
        }
        if (this.getEntry(this.singleSlotRange.getStartSlot()).slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            this.log.info("slave: {} is up", (Object)uri);
        }
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((SentinelServersConfig)cfg).getDatabase());
        return res;
    }

    public Collection<RedisClient> getSentinels() {
        return this.sentinels.values();
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.sentinels.values().stream().map(s -> s.shutdownAsync()).forEach(f -> f.syncUninterruptibly());
        super.shutdown();
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        RedisURI result = this.natMapper.map(address);
        if (!result.equals(address)) {
            this.log.debug("nat mapped uri: {} to {}", (Object)address, (Object)result);
        }
        return result;
    }
}

