/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.redisson.RedissonQueue;
import org.redisson.RedissonQueueSemaphore;
import org.redisson.RedissonSemaphore;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonBoundedBlockingQueue<V>
extends RedissonQueue<V>
implements RBoundedBlockingQueue<V> {
    private final CommandAsyncExecutor commandExecutor;

    protected RedissonBoundedBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
    }

    protected RedissonBoundedBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.commandExecutor = commandExecutor;
    }

    private String getSemaphoreName() {
        return RedissonBoundedBlockingQueue.prefixName("redisson_bqs", this.getRawName());
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        RFuture<Boolean> future = this.offerAsync(e);
        future.onComplete((res, ex) -> {
            if (ex != null) {
                result.tryFailure((Throwable)ex);
                return;
            }
            if (!res.booleanValue()) {
                result.tryFailure(new IllegalStateException("Queue is full"));
                return;
            }
            result.trySuccess((Boolean)res);
        });
        return result;
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.acquireAsync();
    }

    private RedissonQueueSemaphore createSemaphore(V e) {
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName());
        semaphore.setQueueName(this.getRawName());
        semaphore.setValue(e);
        return semaphore;
    }

    @Override
    public void put(V e) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        semaphore.acquire();
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync();
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquire(timeout, unit);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e, long timeout, TimeUnit unit) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync(timeout, unit);
    }

    @Override
    public RFuture<V> takeAsync() {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.getRawName(), 0);
        return this.wrapTakeFuture(takeFuture);
    }

    private RPromise<V> wrapTakeFuture(final RFuture<V> takeFuture) {
        RedissonPromise result = new RedissonPromise<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(mayInterruptIfRunning);
                return takeFuture.cancel(mayInterruptIfRunning);
            }
        };
        takeFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res == null) {
                result.trySuccess(takeFuture.getNow());
                return;
            }
            this.createSemaphore(null).releaseAsync().onComplete((r, ex) -> result.trySuccess(takeFuture.getNow()));
        });
        return result;
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAllAsync(Collections.singleton(o));
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local count = 0; for i = 1, #ARGV, 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then count = count + 1; end; end; if count > 0 then local value = redis.call('incrby', KEYS[2], count); redis.call('publish', KEYS[3], value); return 1;end;return 0 ", Arrays.asList(this.getRawName(), this.getSemaphoreName(), channelName), this.encode(c).toArray());
    }

    @Override
    public RFuture<V> pollAsync() {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local res = redis.call('lpop', KEYS[1]);if res ~= false then local value = redis.call('incrby', KEYS[2], ARGV[1]); redis.call('publish', KEYS[3], value); end;return res;", Arrays.asList(this.getRawName(), this.getSemaphoreName(), channelName), 1);
    }

    @Override
    public V take() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.getRawName(), this.toSeconds(timeout, unit));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        RFuture takeFuture = this.commandExecutor.pollFromAnyAsync(this.getRawName(), this.codec, RedisCommands.BLPOP_VALUE, this.toSeconds(timeout, unit), queueNames);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.commandExecutor.getConnectionManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.commandExecutor.getConnectionManager().getElementsSubscribeService().unsubscribe(listenerId);
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        RFuture takeFuture = this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.BRPOPLPUSH, this.getRawName(), queueName, unit.toSeconds(timeout));
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public int remainingCapacity() {
        return this.createSemaphore(null).availablePermits();
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getRawName(), this.getSemaphoreName(), channelName), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getRawName(), this.getSemaphoreName(), channelName), maxElements);
    }

    @Override
    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getSemaphoreName(), channelName), capacity);
    }

    @Override
    public boolean trySetCapacity(int capacity) {
        return this.get(this.trySetCapacityAsync(capacity));
    }

    @Override
    public void clear() {
        String channelName = RedissonSemaphore.getChannelName(this.getSemaphoreName());
        this.get(this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local len = redis.call('llen', KEYS[1]); if len > 0 then redis.call('del', KEYS[1]); local value = redis.call('incrby', KEYS[2], len); redis.call('publish', KEYS[3], value); end; ", Arrays.asList(this.getRawName(), this.getSemaphoreName(), channelName), new Object[0]));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.getSemaphoreName());
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.getSemaphoreName());
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, this.getRawName(), this.getSemaphoreName());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, this.getRawName(), this.getSemaphoreName());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.getSemaphoreName());
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.getSemaphoreName());
        semaphore.setQueueName(this.getRawName());
        semaphore.setValues(c);
        return semaphore.tryAcquireAsync();
    }
}

