/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RExecutorBatchFuture;
import org.redisson.api.RExecutorFuture;
import org.redisson.misc.RedissonPromise;

public class RedissonExecutorBatchFuture
extends RedissonPromise<Void>
implements RExecutorBatchFuture {
    private List<RExecutorFuture<?>> futures;

    public RedissonExecutorBatchFuture(List<RExecutorFuture<?>> futures) {
        this.futures = futures;
        AtomicInteger counter = new AtomicInteger(futures.size());
        for (RExecutorFuture<?> future : futures) {
            future.onComplete((? super V res, ? super Throwable e) -> {
                if (e != null) {
                    this.tryFailure((Throwable)e);
                    return;
                }
                if (counter.decrementAndGet() == 0) {
                    this.trySuccess(null);
                }
            });
        }
    }

    @Override
    public List<RExecutorFuture<?>> getTaskFutures() {
        return this.futures;
    }
}

