/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMultimapCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapValues;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimapCache;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;

public class RedissonSetMultimapCache<K, V>
extends RedissonSetMultimap<K, V>
implements RSetMultimapCache<K, V> {
    private final RedissonMultimapCache<K> baseCache;

    public RedissonSetMultimapCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
        if (evictionScheduler != null) {
            evictionScheduler.scheduleCleanMultimap(name, this.getTimeoutSetName());
        }
        this.baseCache = new RedissonMultimapCache(connectionManager, this, this.getTimeoutSetName(), this.prefix);
    }

    public RedissonSetMultimapCache(EvictionScheduler evictionScheduler, Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
        if (evictionScheduler != null) {
            evictionScheduler.scheduleCleanMultimap(name, this.getTimeoutSetName());
        }
        this.baseCache = new RedissonMultimapCache(connectionManager, this, this.getTimeoutSetName(), this.prefix);
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value ~= false then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('scard', ARGV[3]) > 0 and 1 or 0;end;return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), keyState, setName);
    }

    String getTimeoutSetName() {
        return RedissonSetMultimapCache.suffixName(this.getName(), "redisson_set_multimap_ttl");
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        ByteBuf valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], keys[i-1]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[2]) then local name = ARGV[3] .. v; if redis.call('sismember', name, ARGV[1]) == 1 then return 1; end;end; end;end; return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), valueState, System.currentTimeMillis(), this.prefix);
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[1]) then if redis.call('sismember', KEYS[1], ARGV[3]) == 1 then return 1; end;end; return 0; ", Arrays.asList(setName, this.getTimeoutSetName()), System.currentTimeMillis(), keyState, valueState);
    }

    @Override
    public RSet<V> get(K key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return new RedissonSetMultimapValues(this.codec, this.commandExecutor, setName, this.getTimeoutSetName(), key);
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[1]) then return redis.call('smembers', KEYS[1]); end; return {}; ", Arrays.asList(setName, this.getTimeoutSetName()), System.currentTimeMillis(), keyState);
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); redis.call('zrem', KEYS[3], ARGV[1]); return members; ", Arrays.asList(this.getName(), setName, this.getTimeoutSetName()), keyState);
    }

    @Override
    public boolean expireKey(K key, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.expireKeyAsync(key, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireKeyAsync(K key, long timeToLive, TimeUnit timeUnit) {
        return this.baseCache.expireKeyAsync(key, timeToLive, timeUnit);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return this.baseCache.sizeInMemoryAsync();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.baseCache.deleteAsync();
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.baseCache.expireAsync(timeToLive, timeUnit);
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.baseCache.expireAtAsync(timestamp);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.baseCache.clearExpireAsync();
    }
}

