/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.LockPubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLock
extends RedissonExpirable
implements RLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonLock.class);
    private static final ConcurrentMap<String, ExpirationEntry> EXPIRATION_RENEWAL_MAP = new ConcurrentHashMap<String, ExpirationEntry>();
    protected long internalLockLeaseTime;
    final String id;
    final String entryName;
    protected final LockPubSub pubSub;
    final CommandAsyncExecutor commandExecutor;
    private static final RedisCommand<Integer> HGET = new RedisCommand<Integer>("HGET", RedisCommand.ValueType.MAP_VALUE, new IntegerReplayConvertor(0));

    public RedissonLock(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.id = commandExecutor.getConnectionManager().getId();
        this.internalLockLeaseTime = commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout();
        this.entryName = this.id + ":" + name;
        this.pubSub = commandExecutor.getConnectionManager().getSubscribeService().getLockPubSub();
    }

    protected String getEntryName() {
        return this.entryName;
    }

    String getChannelName() {
        return RedissonLock.prefixName("redisson_lock__channel", this.getName());
    }

    protected String getLockName(long threadId) {
        return this.id + ":" + threadId;
    }

    @Override
    public void lock() {
        try {
            this.lock(-1L, null, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lock(leaseTime, unit, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock(-1L, null, true);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        this.lock(leaseTime, unit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(long leaseTime, TimeUnit unit, boolean interruptibly) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(-1L, leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        RFuture<RedissonLockEntry> future = this.subscribe(threadId);
        if (interruptibly) {
            this.commandExecutor.syncSubscriptionInterrupted(future);
        } else {
            this.commandExecutor.syncSubscription(future);
        }
        try {
            while ((ttl = this.tryAcquire(-1L, leaseTime, unit, threadId)) != null) {
                if (ttl >= 0L) {
                    try {
                        future.getNow().getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (interruptibly) {
                            throw e;
                        }
                        future.getNow().getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    }
                    continue;
                }
                if (interruptibly) {
                    future.getNow().getLatch().acquire();
                    continue;
                }
                future.getNow().getLatch().acquireUninterruptibly();
            }
        }
        finally {
            this.unsubscribe(future, threadId);
        }
    }

    private Long tryAcquire(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync(waitTime, leaseTime, unit, threadId));
    }

    private RFuture<Boolean> tryAcquireOnceAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(waitTime, leaseTime, unit, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        }
        RFuture<Boolean> ttlRemainingFuture = this.tryLockInnerAsync(waitTime, this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        ttlRemainingFuture.onComplete((ttlRemaining, e) -> {
            if (e != null) {
                return;
            }
            if (ttlRemaining.booleanValue()) {
                this.scheduleExpirationRenewal(threadId);
            }
        });
        return ttlRemainingFuture;
    }

    private <T> RFuture<Long> tryAcquireAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(waitTime, leaseTime, unit, threadId, RedisCommands.EVAL_LONG);
        }
        RFuture<Long> ttlRemainingFuture = this.tryLockInnerAsync(waitTime, this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_LONG);
        ttlRemainingFuture.onComplete((ttlRemaining, e) -> {
            if (e != null) {
                return;
            }
            if (ttlRemaining == null) {
                this.scheduleExpirationRenewal(threadId);
            }
        });
        return ttlRemainingFuture;
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    private void renewExpiration() {
        ExpirationEntry ee = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(this.getEntryName());
        if (ee == null) {
            return;
        }
        Timeout task = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                ExpirationEntry ent = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(RedissonLock.this.getEntryName());
                if (ent == null) {
                    return;
                }
                Long threadId = ent.getFirstThreadId();
                if (threadId == null) {
                    return;
                }
                RFuture<Boolean> future = RedissonLock.this.renewExpirationAsync(threadId);
                future.onComplete((res, e) -> {
                    if (e != null) {
                        log.error("Can't update lock " + RedissonLock.this.getName() + " expiration", (Throwable)e);
                        EXPIRATION_RENEWAL_MAP.remove(RedissonLock.this.getEntryName());
                        return;
                    }
                    if (res.booleanValue()) {
                        RedissonLock.this.renewExpiration();
                    }
                });
            }
        }, this.internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
        ee.setTimeout(task);
    }

    private void scheduleExpirationRenewal(long threadId) {
        ExpirationEntry entry = new ExpirationEntry();
        ExpirationEntry oldEntry = EXPIRATION_RENEWAL_MAP.putIfAbsent(this.getEntryName(), entry);
        if (oldEntry != null) {
            oldEntry.addThreadId(threadId);
        } else {
            entry.addThreadId(threadId);
            this.renewExpiration();
        }
    }

    protected RFuture<Boolean> renewExpirationAsync(long threadId) {
        return this.evalWriteAsync(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('pexpire', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    void cancelExpirationRenewal(Long threadId) {
        ExpirationEntry task = (ExpirationEntry)EXPIRATION_RENEWAL_MAP.get(this.getEntryName());
        if (task == null) {
            return;
        }
        if (threadId != null) {
            task.removeThreadId(threadId);
        }
        if (threadId == null || task.hasNoThreads()) {
            Timeout timeout = task.getTimeout();
            if (timeout != null) {
                timeout.cancel();
            }
            EXPIRATION_RENEWAL_MAP.remove(this.getEntryName());
        }
    }

    protected <T> RFuture<T> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        CommandBatchService executorService = this.createCommandBatchService();
        RFuture result = executorService.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
        if (this.commandExecutor instanceof CommandBatchService) {
            return result;
        }
        RedissonPromise r = new RedissonPromise();
        RFuture<BatchResult<?>> future = executorService.executeAsync();
        future.onComplete((res, ex) -> {
            if (ex != null) {
                r.tryFailure((Throwable)ex);
                return;
            }
            r.trySuccess(result.getNow());
        });
        return r;
    }

    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.evalWriteAsync(this.getName(), LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    private CommandBatchService createCommandBatchService() {
        if (this.commandExecutor instanceof CommandBatchService) {
            return (CommandBatchService)this.commandExecutor;
        }
        MasterSlaveEntry entry = this.commandExecutor.getConnectionManager().getEntry(this.getName());
        BatchOptions options = BatchOptions.defaults().syncSlaves(entry.getAvailableSlaves(), 1L, TimeUnit.SECONDS);
        return new CommandBatchService(this.commandExecutor.getConnectionManager(), options);
    }

    private void acquireFailed(long waitTime, TimeUnit unit, long threadId) {
        this.get(this.acquireFailedAsync(waitTime, unit, threadId));
    }

    protected RFuture<Void> acquireFailedAsync(long waitTime, TimeUnit unit, long threadId) {
        return RedissonPromise.newSucceededFuture(null);
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(waitTime, leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        current = System.currentTimeMillis();
        RFuture<RedissonLockEntry> subscribeFuture = this.subscribe(threadId);
        if (!subscribeFuture.await(time, TimeUnit.MILLISECONDS)) {
            if (!subscribeFuture.cancel(false)) {
                subscribeFuture.onComplete((res, e) -> {
                    if (e == null) {
                        this.unsubscribe(subscribeFuture, threadId);
                    }
                });
            }
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                this.acquireFailed(waitTime, unit, threadId);
                boolean bl = false;
                return bl;
            }
            while (true) {
                long currentTime = System.currentTimeMillis();
                ttl = this.tryAcquire(waitTime, leaseTime, unit, threadId);
                if (ttl == null) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - currentTime) <= 0L) {
                    this.acquireFailed(waitTime, unit, threadId);
                    boolean bl = false;
                    return bl;
                }
                currentTime = System.currentTimeMillis();
                if (ttl >= 0L && ttl < time) {
                    subscribeFuture.getNow().getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    subscribeFuture.getNow().getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                if ((time -= System.currentTimeMillis() - currentTime) > 0L) continue;
                this.acquireFailed(waitTime, unit, threadId);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.unsubscribe(subscribeFuture, threadId);
        }
    }

    protected RFuture<RedissonLockEntry> subscribe(long threadId) {
        return this.pubSub.subscribe(this.getEntryName(), this.getChannelName());
    }

    protected void unsubscribe(RFuture<RedissonLockEntry> future, long threadId) {
        this.pubSub.unsubscribe((PubSubEntry)future.getNow(), this.getEntryName(), this.getChannelName());
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public void unlock() {
        try {
            this.get(this.unlockAsync(Thread.currentThread().getId()));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IllegalMonitorStateException) {
                throw (IllegalMonitorStateException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.evalWriteAsync(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.UNLOCK_MESSAGE);
    }

    @Override
    public boolean isLocked() {
        return this.isExists();
    }

    @Override
    public RFuture<Boolean> isLockedAsync() {
        return this.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.isHeldByThread(Thread.currentThread().getId());
    }

    @Override
    public boolean isHeldByThread(long threadId) {
        RFuture future = this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getName(), this.getLockName(threadId));
        return (Boolean)this.get(future);
    }

    @Override
    public RFuture<Integer> getHoldCountAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, HGET, this.getName(), this.getLockName(Thread.currentThread().getId()));
    }

    @Override
    public int getHoldCount() {
        return this.get(this.getHoldCountAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        long threadId = Thread.currentThread().getId();
        return this.unlockAsync(threadId);
    }

    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        return this.evalWriteAsync(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return nil;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.UNLOCK_MESSAGE, this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public RFuture<Void> unlockAsync(long threadId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Boolean> future = this.unlockInnerAsync(threadId);
        future.onComplete((opStatus, e) -> {
            this.cancelExpirationRenewal(threadId);
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (opStatus == null) {
                IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + threadId);
                result.tryFailure(cause);
                return;
            }
            result.trySuccess(null);
        });
        return result;
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long currentThreadId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(-1L, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            RFuture<RedissonLockEntry> subscribeFuture = this.subscribe(currentThreadId);
            subscribeFuture.onComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
            });
        });
        return result;
    }

    private void lockAsync(final long leaseTime, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Void> result, final long currentThreadId) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(-1L, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture, currentThreadId);
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(subscribeFuture, currentThreadId);
                if (!result.trySuccess(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            final RedissonLockEntry entry = (RedissonLockEntry)subscribeFuture.getNow();
            if (entry.getLatch().tryAcquire()) {
                this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
            } else {
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                };
                entry.addListener(listener);
                if (ttl >= 0L) {
                    Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        }
                    }, (long)ttl, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.tryAcquireOnceAsync(-1L, -1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, final long currentThreadId) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long currentTime = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - currentTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final RFuture<RedissonLockEntry> subscribeFuture = this.subscribe(currentThreadId);
            subscribeFuture.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                this.tryLockAsync(time, waitTime, leaseTime, unit, subscribeFuture, result, currentThreadId);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            subscribeFuture.cancel(false);
                            RedissonLock.this.trySuccessFalse(currentThreadId, result);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return result;
    }

    private void trySuccessFalse(long currentThreadId, RPromise<Boolean> result) {
        this.acquireFailedAsync(-1L, null, currentThreadId).onComplete((res, e) -> {
            if (e == null) {
                result.trySuccess(false);
            } else {
                result.tryFailure((Throwable)e);
            }
        });
    }

    private void tryLockAsync(final AtomicLong time, final long waitTime, final long leaseTime, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Boolean> result, final long currentThreadId) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture, currentThreadId);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture, currentThreadId);
            this.trySuccessFalse(currentThreadId, result);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(waitTime, leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture, currentThreadId);
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                this.unsubscribe(subscribeFuture, currentThreadId);
                if (!result.trySuccess(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(subscribeFuture, currentThreadId);
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            final long current = System.currentTimeMillis();
            final RedissonLockEntry entry = (RedissonLockEntry)subscribeFuture.getNow();
            if (entry.getLatch().tryAcquire()) {
                this.tryLockAsync(time, waitTime, leaseTime, unit, subscribeFuture, result, currentThreadId);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null) {
                        ((Timeout)futureRef.get()).cancel();
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryLockAsync(time, waitTime, leaseTime, unit, subscribeFuture, result, currentThreadId);
                };
                entry.addListener(listener);
                long t = time.get();
                if (ttl >= 0L && ttl < time.get()) {
                    t = ttl;
                }
                if (!executed.get()) {
                    Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonLock.this.tryLockAsync(time, waitTime, leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    public static class ExpirationEntry {
        private final Map<Long, Integer> threadIds = new LinkedHashMap<Long, Integer>();
        private volatile Timeout timeout;

        public synchronized void addThreadId(long threadId) {
            Integer counter = this.threadIds.get(threadId);
            if (counter == null) {
                counter = 1;
            } else {
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
            }
            this.threadIds.put(threadId, counter);
        }

        public synchronized boolean hasNoThreads() {
            return this.threadIds.isEmpty();
        }

        public synchronized Long getFirstThreadId() {
            if (this.threadIds.isEmpty()) {
                return null;
            }
            return this.threadIds.keySet().iterator().next();
        }

        public synchronized void removeThreadId(long threadId) {
            Integer counter = this.threadIds.get(threadId);
            if (counter == null) {
                return;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter - 1);
            if (counter == 0) {
                this.threadIds.remove(threadId);
            } else {
                this.threadIds.put(threadId, counter);
            }
        }

        public void setTimeout(Timeout timeout) {
            this.timeout = timeout;
        }

        public Timeout getTimeout() {
            return this.timeout;
        }
    }
}

