/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.NetUtil;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.RedisChannelInitializer;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;

public final class RedisClient {
    private final AtomicReference<RFuture<InetSocketAddress>> resolvedAddrFuture = new AtomicReference();
    private final Bootstrap bootstrap;
    private final Bootstrap pubSubBootstrap;
    private final RedisURI uri;
    private InetSocketAddress resolvedAddr;
    private final ChannelGroup channels;
    private ExecutorService executor;
    private final long commandTimeout;
    private Timer timer;
    private RedisClientConfig config;
    private boolean hasOwnTimer;
    private boolean hasOwnExecutor;
    private boolean hasOwnGroup;
    private boolean hasOwnResolver;

    public static RedisClient create(RedisClientConfig config) {
        return new RedisClient(config);
    }

    private RedisClient(RedisClientConfig config) {
        RedisClientConfig copy = new RedisClientConfig(config);
        if (copy.getTimer() == null) {
            copy.setTimer(new HashedWheelTimer());
            this.hasOwnTimer = true;
        }
        if (copy.getGroup() == null) {
            copy.setGroup(new NioEventLoopGroup());
            this.hasOwnGroup = true;
        }
        if (copy.getExecutor() == null) {
            copy.setExecutor(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2));
            this.hasOwnExecutor = true;
        }
        if (copy.getResolverGroup() == null) {
            if (config.getSocketChannelClass() == EpollSocketChannel.class) {
                copy.setResolverGroup(new DnsAddressResolverGroup(EpollDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            } else {
                copy.setResolverGroup(new DnsAddressResolverGroup(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            }
            this.hasOwnResolver = true;
        }
        this.config = copy;
        this.executor = copy.getExecutor();
        this.timer = copy.getTimer();
        this.uri = copy.getAddress();
        this.resolvedAddr = copy.getAddr();
        if (this.resolvedAddr != null) {
            this.resolvedAddrFuture.set(RedissonPromise.newSucceededFuture(this.resolvedAddr));
        }
        this.channels = new DefaultChannelGroup(copy.getGroup().next());
        this.bootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PLAIN);
        this.pubSubBootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PUBSUB);
        this.commandTimeout = copy.getCommandTimeout();
    }

    private Bootstrap createBootstrap(RedisClientConfig config, RedisChannelInitializer.Type type) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().resolver(config.getResolverGroup()).channel(config.getSocketChannelClass())).group(config.getGroup());
        bootstrap.handler(new RedisChannelInitializer(bootstrap, config, this, this.channels, type));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, config.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, config.isKeepAlive());
        bootstrap.option(ChannelOption.TCP_NODELAY, config.isTcpNoDelay());
        config.getNettyHook().afterBoostrapInitialization(bootstrap);
        return bootstrap;
    }

    public InetSocketAddress getAddr() {
        return this.resolvedAddr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.bootstrap.config().group();
    }

    public RedisClientConfig getConfig() {
        return this.config;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public RedisConnection connect() {
        try {
            return this.connectAsync().syncUninterruptibly().getNow();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public RFuture<InetSocketAddress> resolveAddr() {
        if (this.resolvedAddrFuture.get() != null) {
            return this.resolvedAddrFuture.get();
        }
        final RedissonPromise<InetSocketAddress> promise = new RedissonPromise<InetSocketAddress>();
        if (!this.resolvedAddrFuture.compareAndSet(null, promise)) {
            return this.resolvedAddrFuture.get();
        }
        byte[] addr = NetUtil.createByteArrayFromIpAddressString(this.uri.getHost());
        if (addr != null) {
            try {
                this.resolvedAddr = new InetSocketAddress(InetAddress.getByAddress(addr), this.uri.getPort());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            promise.trySuccess(this.resolvedAddr);
            return promise;
        }
        AddressResolver<?> resolver = this.bootstrap.config().resolver().getResolver(this.bootstrap.config().group().next());
        Future<?> resolveFuture = resolver.resolve(InetSocketAddress.createUnresolved(this.uri.getHost(), this.uri.getPort()));
        resolveFuture.addListener(new FutureListener<InetSocketAddress>(){

            @Override
            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                InetSocketAddress resolved = future.getNow();
                byte[] addr = resolved.getAddress().getAddress();
                RedisClient.this.resolvedAddr = new InetSocketAddress(InetAddress.getByAddress(RedisClient.this.uri.getHost(), addr), resolved.getPort());
                promise.trySuccess(RedisClient.this.resolvedAddr);
            }
        });
        return promise;
    }

    public RFuture<RedisConnection> connectAsync() {
        final RedissonPromise<RedisConnection> f = new RedissonPromise<RedisConnection>();
        RFuture<InetSocketAddress> addrFuture = this.resolveAddr();
        addrFuture.onComplete((res, e) -> {
            if (e != null) {
                f.tryFailure((Throwable)e);
                return;
            }
            ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)res);
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(final ChannelFuture future) throws Exception {
                    if (RedisClient.this.bootstrap.config().group().isShuttingDown()) {
                        IllegalStateException cause = new IllegalStateException("RedisClient is shutdown");
                        f.tryFailure(cause);
                        return;
                    }
                    if (future.isSuccess()) {
                        Object c = RedisConnection.getFrom(future.channel());
                        ((RedisConnection)c).getConnectionPromise().onComplete((res, e) -> RedisClient.this.bootstrap.config().group().execute(new Runnable((Throwable)e, f, (RedisConnection)c){
                            final /* synthetic */ Throwable val$e;
                            final /* synthetic */ RPromise val$f;
                            final /* synthetic */ RedisConnection val$c;
                            {
                                this.val$e = throwable;
                                this.val$f = rPromise;
                                this.val$c = redisConnection;
                            }

                            @Override
                            public void run() {
                                if (this.val$e == null) {
                                    if (!this.val$f.trySuccess(this.val$c)) {
                                        this.val$c.closeAsync();
                                    }
                                } else {
                                    this.val$f.tryFailure(this.val$e);
                                    this.val$c.closeAsync();
                                }
                            }
                        }));
                    } else {
                        RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                            @Override
                            public void run() {
                                f.tryFailure(future.cause());
                            }
                        });
                    }
                }
            });
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            return this.connectPubSubAsync().syncUninterruptibly().getNow();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        final RedissonPromise<RedisPubSubConnection> f = new RedissonPromise<RedisPubSubConnection>();
        RFuture<InetSocketAddress> nameFuture = this.resolveAddr();
        nameFuture.onComplete((res, e) -> {
            if (e != null) {
                f.tryFailure((Throwable)e);
                return;
            }
            ChannelFuture channelFuture = this.pubSubBootstrap.connect((SocketAddress)res);
            channelFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(final ChannelFuture future) throws Exception {
                    if (RedisClient.this.bootstrap.config().group().isShuttingDown()) {
                        IllegalStateException cause = new IllegalStateException("RedisClient is shutdown");
                        f.tryFailure(cause);
                        return;
                    }
                    if (future.isSuccess()) {
                        RedisPubSubConnection c = (RedisPubSubConnection)RedisPubSubConnection.getFrom(future.channel());
                        c.getConnectionPromise().onComplete((res, e) -> RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable((Throwable)e, f, c){
                            final /* synthetic */ Throwable val$e;
                            final /* synthetic */ RPromise val$f;
                            final /* synthetic */ RedisPubSubConnection val$c;
                            {
                                this.val$e = throwable;
                                this.val$f = rPromise;
                                this.val$c = redisPubSubConnection;
                            }

                            @Override
                            public void run() {
                                if (this.val$e == null) {
                                    if (!this.val$f.trySuccess(this.val$c)) {
                                        this.val$c.closeAsync();
                                    }
                                } else {
                                    this.val$f.tryFailure(this.val$e);
                                    this.val$c.closeAsync();
                                }
                            }
                        }));
                    } else {
                        RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable(){

                            @Override
                            public void run() {
                                f.tryFailure(future.cause());
                            }
                        });
                    }
                }
            });
        });
        return f;
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
    }

    public RFuture<Void> shutdownAsync() {
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        if (this.channels.isEmpty()) {
            this.shutdown(result);
            return result;
        }
        ChannelGroupFuture channelsFuture = this.channels.newCloseFuture();
        channelsFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RedisClient.this.shutdown(result);
            }
        });
        for (Channel channel : this.channels) {
            Object connection = RedisConnection.getFrom(channel);
            if (connection == null) continue;
            ((RedisConnection)connection).closeAsync();
        }
        return result;
    }

    private void shutdown(final RPromise<Void> result) {
        if (!(this.hasOwnTimer || this.hasOwnExecutor || this.hasOwnResolver || this.hasOwnGroup)) {
            result.trySuccess(null);
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        if (RedisClient.this.hasOwnTimer) {
                            RedisClient.this.timer.stop();
                        }
                        if (RedisClient.this.hasOwnExecutor) {
                            RedisClient.this.executor.shutdown();
                            RedisClient.this.executor.awaitTermination(15L, TimeUnit.SECONDS);
                        }
                        if (RedisClient.this.hasOwnResolver) {
                            RedisClient.this.bootstrap.config().resolver().close();
                        }
                        if (RedisClient.this.hasOwnGroup) {
                            RedisClient.this.bootstrap.config().group().shutdownGracefully();
                        }
                    }
                    catch (Exception e) {
                        result.tryFailure(e);
                        return;
                    }
                    result.trySuccess(null);
                }
            };
            t.start();
        }
    }

    public String toString() {
        return "[addr=" + this.uri + "]";
    }
}

