/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.Flowable;
import io.reactivex.Single;
import org.reactivestreams.Publisher;
import org.redisson.RedissonObject;
import org.redisson.ScanIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RLockRx;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RSet;
import org.redisson.api.RedissonRxClient;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.rx.PublisherAdder;
import org.redisson.rx.SetRxIterator;

public class RedissonSetRx<V> {
    private final RSet<V> instance;
    private final RedissonRxClient redisson;

    public RedissonSetRx(RSet<V> instance, RedissonRxClient redisson) {
        this.instance = instance;
        this.redisson = redisson;
    }

    public Single<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<Object>(){

            @Override
            public RFuture<Boolean> add(Object e) {
                return RedissonSetRx.this.instance.addAsync(e);
            }
        }.addAll(c);
    }

    public Flowable<V> iterator(int count) {
        return this.iterator(null, count);
    }

    public Flowable<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    public Flowable<V> iterator(final String pattern, final int count) {
        return new SetRxIterator<V>(){

            @Override
            protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((ScanIterator)((Object)RedissonSetRx.this.instance)).scanIteratorAsync(RedissonSetRx.this.instance.getName(), client, nextIterPos, pattern, count);
            }
        }.create();
    }

    public Publisher<V> iterator() {
        return this.iterator(null, 10);
    }

    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreRx getSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockRx getFairLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockRx getReadWriteLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockRx getLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "lock");
        return this.redisson.getLock(name);
    }
}

