/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import io.netty.resolver.AddressResolver;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.redisson.api.NatMapper;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.cluster.ClusterNodeInfo;
import org.redisson.cluster.ClusterPartition;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.CRC16;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.RedisURI;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<Integer, ClusterPartition> lastPartitions = new ConcurrentHashMap<Integer, ClusterPartition>();
    private ScheduledFuture<?> monitorFuture;
    private volatile RedisURI lastClusterNode;
    private RedisStrictCommand<List<ClusterNodeInfo>> clusterNodesCommand;
    private String configEndpointHostName;
    private final NatMapper natMapper;
    private final AtomicReferenceArray<MasterSlaveEntry> slot2entry = new AtomicReferenceArray(16384);
    private final Map<RedisClient, MasterSlaveEntry> client2entry = new ConcurrentHashMap<RedisClient, MasterSlaveEntry>();

    public ClusterConnectionManager(ClusterServersConfig cfg, Config config, UUID id) {
        super(config, id);
        if (cfg.getNodeAddresses().isEmpty()) {
            throw new IllegalArgumentException("At least one cluster node should be defined!");
        }
        this.natMapper = cfg.getNatMapper();
        this.config = this.create(cfg);
        this.initTimer(this.config);
        Throwable lastException = null;
        ArrayList<String> failedMasters = new ArrayList<String>();
        for (String address : cfg.getNodeAddresses()) {
            RedisURI addr = new RedisURI(address);
            RFuture<RedisConnection> connectionFuture = this.connectToNode(cfg, addr, null, addr.getHost());
            try {
                RedisConnection connection = connectionFuture.syncUninterruptibly().getNow();
                if (cfg.getNodeAddresses().size() == 1 && NetUtil.createByteArrayFromIpAddressString(addr.getHost()) == null) {
                    this.configEndpointHostName = addr.getHost();
                }
                this.clusterNodesCommand = RedisCommands.CLUSTER_NODES;
                if (addr.isSsl()) {
                    this.clusterNodesCommand = RedisCommands.CLUSTER_NODES_SSL;
                }
                List<ClusterNodeInfo> nodes = connection.sync(this.clusterNodesCommand, new Object[0]);
                StringBuilder nodesValue = new StringBuilder();
                for (ClusterNodeInfo clusterNodeInfo : nodes) {
                    nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                }
                this.log.info("Redis cluster nodes configuration got from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
                this.lastClusterNode = addr;
                Collection<ClusterPartition> partitions = this.parsePartitions(nodes);
                ArrayList<RFuture<Void>> masterFutures = new ArrayList<RFuture<Void>>();
                for (ClusterPartition clusterPartition : partitions) {
                    if (clusterPartition.isMasterFail()) {
                        failedMasters.add(clusterPartition.getMasterAddress().toString());
                        continue;
                    }
                    if (clusterPartition.getMasterAddress() == null) {
                        throw new IllegalStateException("Master node: " + clusterPartition.getNodeId() + " doesn't have address.");
                    }
                    RFuture<Void> masterFuture = this.addMasterEntry(clusterPartition, cfg);
                    masterFutures.add(masterFuture);
                }
                for (RFuture rFuture : masterFutures) {
                    rFuture.awaitUninterruptibly();
                    if (rFuture.isSuccess()) continue;
                    lastException = rFuture.cause();
                }
                break;
            }
            catch (Exception e) {
                lastException = e;
                this.log.warn(e.getMessage());
            }
        }
        if (this.lastPartitions.isEmpty()) {
            this.stopThreads();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Can't connect to servers!", lastException);
            }
            throw new RedisConnectionException("Can't connect to servers! Failed masters according to cluster status: " + failedMasters, lastException);
        }
        if (cfg.isCheckSlotsCoverage() && this.lastPartitions.size() != 16384) {
            this.stopThreads();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Not all slots covered! Only " + this.lastPartitions.size() + " slots are available. Set checkSlotsCoverage = false to avoid this check.", lastException);
            }
            throw new RedisConnectionException("Not all slots covered! Only " + this.lastPartitions.size() + " slots are available. Set checkSlotsCoverage = false to avoid this check. Failed masters according to cluster status: " + failedMasters, lastException);
        }
        this.scheduleClusterChangeCheck(cfg);
    }

    @Override
    public Collection<MasterSlaveEntry> getEntrySet() {
        return this.client2entry.values();
    }

    @Override
    protected MasterSlaveEntry getEntry(RedisURI addr) {
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            if (RedisURI.compare(entry.getClient().getAddr(), addr)) {
                return entry;
            }
            if (!entry.hasSlave(addr)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisClient redisClient) {
        MasterSlaveEntry entry = this.client2entry.get(redisClient);
        if (entry != null) {
            return entry;
        }
        for (MasterSlaveEntry mentry : this.client2entry.values()) {
            if (!mentry.hasSlave(redisClient)) continue;
            return mentry;
        }
        return null;
    }

    @Override
    public MasterSlaveEntry getEntry(InetSocketAddress address) {
        for (MasterSlaveEntry entry : this.client2entry.values()) {
            InetSocketAddress addr = entry.getClient().getAddr();
            if (!addr.getAddress().equals(address.getAddress()) || addr.getPort() != address.getPort()) continue;
            return entry;
        }
        return null;
    }

    @Override
    protected RFuture<RedisClient> changeMaster(int slot, RedisURI address) {
        MasterSlaveEntry entry = this.getEntry(slot);
        RedisClient oldClient = entry.getClient();
        RFuture<RedisClient> future = super.changeMaster(slot, address);
        future.onComplete((res, e) -> {
            if (e == null) {
                this.client2entry.remove(oldClient);
                this.client2entry.put(entry.getClient(), entry);
            }
        });
        return future;
    }

    @Override
    public MasterSlaveEntry getEntry(int slot) {
        return this.slot2entry.get(slot);
    }

    private void addEntry(Integer slot, MasterSlaveEntry entry) {
        MasterSlaveEntry oldEntry = this.slot2entry.getAndSet(slot, entry);
        if (oldEntry != entry) {
            entry.incReference();
            this.shutdownEntry(oldEntry);
        }
        this.client2entry.put(entry.getClient(), entry);
    }

    private void removeEntry(Integer slot) {
        MasterSlaveEntry entry = this.slot2entry.getAndSet(slot, null);
        this.shutdownEntry(entry);
    }

    private void shutdownEntry(MasterSlaveEntry entry) {
        if (entry != null && entry.decReference() == 0) {
            this.client2entry.remove(entry.getClient());
            entry.getAllEntries().forEach(e -> entry.nodeDown((ClientConnectionsEntry)e));
            entry.masterDown();
            entry.shutdownAsync();
            this.subscribeService.remove(entry);
            String slaves = entry.getAllEntries().stream().filter(e -> !e.getClient().getAddr().equals(entry.getClient().getAddr())).map(e -> e.getClient().toString()).collect(Collectors.joining(","));
            this.log.info("{} master and related slaves: {} removed", (Object)entry.getClient().getAddr(), (Object)slaves);
        }
    }

    @Override
    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig result = super.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        result.setReadOnly(type == NodeType.SLAVE && this.config.getReadMode() != ReadMode.MASTER);
        return result;
    }

    private RFuture<Void> addMasterEntry(ClusterPartition partition, ClusterServersConfig cfg) {
        if (partition.isMasterFail()) {
            RedisException e = new RedisException("Failed to add master: " + partition.getMasterAddress() + " for slot ranges: " + partition.getSlotRanges() + ". Reason - server has FAIL flag");
            if (partition.getSlotsAmount() == 0) {
                e = new RedisException("Failed to add master: " + partition.getMasterAddress() + ". Reason - server has FAIL flag");
            }
            return RedissonPromise.newFailedFuture(e);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<RedisConnection> connectionFuture = this.connectToNode(cfg, partition.getMasterAddress(), null, this.configEndpointHostName);
        connectionFuture.onComplete((connection, ex1) -> {
            MasterSlaveEntry entry;
            if (ex1 != null) {
                this.log.error("Can't connect to master: {} with slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                result.tryFailure((Throwable)ex1);
                return;
            }
            MasterSlaveServersConfig config = this.create(cfg);
            config.setMasterAddress(partition.getMasterAddress().toString());
            if (config.checkSkipSlavesInit()) {
                entry = new SingleEntry(this, config, this.configEndpointHostName);
            } else {
                Set<String> slaveAddresses = partition.getSlaveAddresses().stream().map(r -> r.toString()).collect(Collectors.toSet());
                config.setSlaveAddresses(slaveAddresses);
                entry = new MasterSlaveEntry(this, config, this.configEndpointHostName);
            }
            RFuture<RedisClient> f = entry.setupMasterEntry(new RedisURI(config.getMasterAddress()));
            f.onComplete((masterClient, ex3) -> {
                if (ex3 != null) {
                    this.log.error("Can't add master: " + partition.getMasterAddress() + " for slot ranges: " + partition.getSlotRanges(), (Throwable)ex3);
                    result.tryFailure((Throwable)ex3);
                    return;
                }
                for (Integer slot : partition.getSlots()) {
                    this.addEntry(slot, entry);
                    this.lastPartitions.put(slot, partition);
                }
                if (!config.checkSkipSlavesInit()) {
                    List<RFuture<Void>> fs = entry.initSlaveBalancer((Collection<RedisURI>)partition.getFailedSlaveAddresses(), (RedisClient)masterClient);
                    AtomicInteger counter = new AtomicInteger(fs.size());
                    for (RFuture<Void> future : fs) {
                        future.onComplete((r, ex) -> {
                            if (ex != null) {
                                this.log.error("unable to add slave for: " + partition.getMasterAddress() + " slot ranges: " + partition.getSlotRanges(), (Throwable)ex);
                            }
                            if (counter.decrementAndGet() == 0) {
                                if (!partition.getSlaveAddresses().isEmpty()) {
                                    this.log.info("slaves: {} added for slot ranges: {}", (Object)partition.getSlaveAddresses(), (Object)partition.getSlotRanges());
                                    if (!partition.getFailedSlaveAddresses().isEmpty()) {
                                        this.log.warn("slaves: {} are down for slot ranges: {}", (Object)partition.getFailedSlaveAddresses(), (Object)partition.getSlotRanges());
                                    }
                                }
                                if (result.trySuccess(null)) {
                                    this.log.info("master: {} added for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                                } else {
                                    this.log.error("unable to add master: {} for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                                }
                            }
                        });
                    }
                } else if (result.trySuccess(null)) {
                    this.log.info("master: {} added for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                } else {
                    this.log.error("unable to add master: {} for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                }
            });
        });
        return result;
    }

    private void scheduleClusterChangeCheck(final ClusterServersConfig cfg) {
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                if (ClusterConnectionManager.this.configEndpointHostName != null) {
                    String address = cfg.getNodeAddresses().iterator().next();
                    final RedisURI uri = new RedisURI(address);
                    AddressResolver resolver = ClusterConnectionManager.this.resolverGroup.getResolver(ClusterConnectionManager.this.getGroup().next());
                    Future allNodes = resolver.resolveAll(InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort()));
                    allNodes.addListener(new FutureListener<List<InetSocketAddress>>(){

                        @Override
                        public void operationComplete(Future<List<InetSocketAddress>> future) throws Exception {
                            AtomicReference<Throwable> lastException = new AtomicReference<Throwable>(future.cause());
                            if (!future.isSuccess()) {
                                ClusterConnectionManager.this.checkClusterState(cfg, Collections.emptyIterator(), lastException);
                                return;
                            }
                            ArrayList<RedisURI> nodes = new ArrayList<RedisURI>();
                            for (InetSocketAddress addr : future.getNow()) {
                                RedisURI node = new RedisURI(uri.getScheme() + "://" + addr.getAddress().getHostAddress() + ":" + addr.getPort());
                                RedisURI address = ClusterConnectionManager.this.applyNatMap(node);
                                nodes.add(address);
                            }
                            Iterator nodesIterator = nodes.iterator();
                            ClusterConnectionManager.this.checkClusterState(cfg, nodesIterator, lastException);
                        }
                    });
                } else {
                    AtomicReference lastException = new AtomicReference();
                    ArrayList<RedisURI> nodes = new ArrayList<RedisURI>();
                    ArrayList<RedisURI> slaves = new ArrayList<RedisURI>();
                    for (ClusterPartition partition : ClusterConnectionManager.this.getLastPartitions()) {
                        if (!partition.isMasterFail()) {
                            nodes.add(partition.getMasterAddress());
                        }
                        HashSet<RedisURI> partitionSlaves = new HashSet<RedisURI>(partition.getSlaveAddresses());
                        partitionSlaves.removeAll(partition.getFailedSlaveAddresses());
                        slaves.addAll(partitionSlaves);
                    }
                    nodes.addAll(slaves);
                    Iterator nodesIterator = nodes.iterator();
                    ClusterConnectionManager.this.checkClusterState(cfg, nodesIterator, lastException);
                }
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkClusterState(ClusterServersConfig cfg, Iterator<RedisURI> iterator, AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            if (lastException.get() != null) {
                this.log.error("Can't update cluster state", lastException.get());
            }
            this.scheduleClusterChangeCheck(cfg);
            return;
        }
        if (!this.getShutdownLatch().acquire()) {
            return;
        }
        RedisURI uri = iterator.next();
        RFuture<RedisConnection> connectionFuture = this.connectToNode(cfg, uri, null, this.configEndpointHostName);
        connectionFuture.onComplete((connection, e) -> {
            if (e != null) {
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkClusterState(cfg, iterator, lastException);
                return;
            }
            this.updateClusterState(cfg, (RedisConnection)connection, iterator, uri, lastException);
        });
    }

    private void updateClusterState(ClusterServersConfig cfg, RedisConnection connection, Iterator<RedisURI> iterator, RedisURI uri, AtomicReference<Throwable> lastException) {
        RFuture future = connection.async(this.clusterNodesCommand, new Object[0]);
        future.onComplete((nodes, e) -> {
            if (e != null) {
                this.log.error("Can't execute CLUSTER_NODES with " + connection.getRedisClient().getAddr(), (Throwable)e);
                this.closeNodeConnection(connection);
                lastException.set((Throwable)e);
                this.getShutdownLatch().release();
                this.checkClusterState(cfg, iterator, lastException);
                return;
            }
            this.lastClusterNode = uri;
            StringBuilder nodesValue = new StringBuilder();
            if (this.log.isDebugEnabled()) {
                for (ClusterNodeInfo clusterNodeInfo : nodes) {
                    nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                }
                this.log.debug("cluster nodes state got from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
            }
            Collection<ClusterPartition> newPartitions = this.parsePartitions((List<ClusterNodeInfo>)nodes);
            RFuture<Void> masterFuture = this.checkMasterNodesChange(cfg, newPartitions);
            this.checkSlaveNodesChange(newPartitions);
            masterFuture.onComplete((res, ex) -> {
                this.checkSlotsMigration(newPartitions);
                this.checkSlotsChange(newPartitions);
                this.getShutdownLatch().release();
                this.scheduleClusterChangeCheck(cfg);
            });
        });
    }

    private void checkSlaveNodesChange(Collection<ClusterPartition> newPartitions) {
        Set<ClusterPartition> lastPartitions = this.getLastPartitions();
        block0: for (ClusterPartition newPart : newPartitions) {
            for (ClusterPartition currentPart : lastPartitions) {
                if (!newPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                MasterSlaveEntry entry = this.getEntry(currentPart.slots().nextSetBit(0));
                Set<RedisURI> addedSlaves = this.addRemoveSlaves(entry, currentPart, newPart);
                this.upDownSlaves(entry, currentPart, newPart, addedSlaves);
                continue block0;
            }
        }
    }

    private void upDownSlaves(MasterSlaveEntry entry, ClusterPartition currentPart, ClusterPartition newPart, Set<RedisURI> addedSlaves) {
        HashSet<RedisURI> aliveSlaves = new HashSet<RedisURI>(currentPart.getFailedSlaveAddresses());
        aliveSlaves.removeAll(addedSlaves);
        aliveSlaves.removeAll(newPart.getFailedSlaveAddresses());
        for (RedisURI uri : aliveSlaves) {
            currentPart.removeFailedSlaveAddress(uri);
            if (!entry.hasSlave(uri) || !entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.info("slave: {} is up for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
        HashSet<RedisURI> failedSlaves = new HashSet<RedisURI>(newPart.getFailedSlaveAddresses());
        failedSlaves.removeAll(currentPart.getFailedSlaveAddresses());
        for (RedisURI uri : failedSlaves) {
            currentPart.addFailedSlaveAddress(uri);
            if (!entry.slaveDown(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.disconnectNode(uri);
            this.log.warn("slave: {} has down for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
    }

    private Set<RedisURI> addRemoveSlaves(MasterSlaveEntry entry, ClusterPartition currentPart, ClusterPartition newPart) {
        HashSet<RedisURI> removedSlaves = new HashSet<RedisURI>(currentPart.getSlaveAddresses());
        removedSlaves.removeAll(newPart.getSlaveAddresses());
        for (RedisURI uri : removedSlaves) {
            currentPart.removeSlaveAddress(uri);
            if (!entry.slaveDown(uri, ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.info("slave {} removed for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
        HashSet<RedisURI> addedSlaves = new HashSet<RedisURI>(newPart.getSlaveAddresses());
        addedSlaves.removeAll(currentPart.getSlaveAddresses());
        for (RedisURI uri : addedSlaves) {
            RFuture<Void> future = entry.addSlave(uri);
            future.onComplete((res, ex) -> {
                if (ex != null) {
                    this.log.error("Can't add slave: " + uri, (Throwable)ex);
                    return;
                }
                currentPart.addSlaveAddress(uri);
                entry.slaveUp(uri, ClientConnectionsEntry.FreezeReason.MANAGER);
                this.log.info("slave: {} added for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
            });
        }
        return addedSlaves;
    }

    private int slotsAmount(Collection<ClusterPartition> partitions) {
        int result = 0;
        for (ClusterPartition clusterPartition : partitions) {
            result += clusterPartition.getSlotsAmount();
        }
        return result;
    }

    private ClusterPartition find(Collection<ClusterPartition> partitions, Integer slot) {
        for (ClusterPartition clusterPartition : partitions) {
            if (!clusterPartition.hasSlot(slot)) continue;
            return clusterPartition;
        }
        return null;
    }

    private RFuture<Void> checkMasterNodesChange(ClusterServersConfig cfg, Collection<ClusterPartition> newPartitions) {
        Set<ClusterPartition> lastPartitions = this.getLastPartitions();
        HashMap<RedisURI, ClusterPartition> addedPartitions = new HashMap<RedisURI, ClusterPartition>();
        HashSet<RedisURI> mastersElected = new HashSet<RedisURI>();
        for (ClusterPartition newPart : newPartitions) {
            boolean masterFound = false;
            for (ClusterPartition currentPart : lastPartitions) {
                if (!newPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                masterFound = true;
                if (!newPart.isMasterFail() || newPart.getSlotsAmount() == 0) continue;
                for (Integer slot : currentPart.getSlots()) {
                    ClusterPartition newMasterPart = this.find(newPartitions, slot);
                    if (newMasterPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                    RedisURI newUri = newMasterPart.getMasterAddress();
                    RedisURI oldUri = currentPart.getMasterAddress();
                    mastersElected.add(newUri);
                    RFuture<RedisClient> future = this.changeMaster(slot, newUri);
                    currentPart.setMasterAddress(newUri);
                    future.onComplete((res, e) -> {
                        if (e != null) {
                            currentPart.setMasterAddress(oldUri);
                        } else {
                            this.disconnectNode(oldUri);
                        }
                    });
                }
            }
            if (masterFound || newPart.getSlotsAmount() <= 0) continue;
            addedPartitions.put(newPart.getMasterAddress(), newPart);
        }
        addedPartitions.keySet().removeAll(mastersElected);
        if (addedPartitions.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        AtomicInteger masters = new AtomicInteger(addedPartitions.size());
        for (ClusterPartition newPart : addedPartitions.values()) {
            RFuture<Void> future = this.addMasterEntry(newPart, cfg);
            future.onComplete((res, e) -> {
                if (masters.decrementAndGet() == 0) {
                    result.trySuccess(null);
                }
            });
        }
        return result;
    }

    private void checkSlotsChange(Collection<ClusterPartition> newPartitions) {
        int newSlotsAmount = this.slotsAmount(newPartitions);
        if (newSlotsAmount == this.lastPartitions.size() && this.lastPartitions.size() == 16384) {
            return;
        }
        HashSet<Integer> removedSlots = new HashSet<Integer>();
        for (Integer slot : this.lastPartitions.keySet()) {
            boolean found = false;
            for (ClusterPartition clusterPartition : newPartitions) {
                if (!clusterPartition.hasSlot(slot)) continue;
                found = true;
                break;
            }
            if (found) continue;
            removedSlots.add(slot);
        }
        this.lastPartitions.keySet().removeAll(removedSlots);
        if (!removedSlots.isEmpty()) {
            this.log.info("{} slots found to remove", (Object)removedSlots.size());
        }
        for (Integer slot : removedSlots) {
            this.removeEntry(slot);
        }
        Integer addedSlots = 0;
        for (ClusterPartition clusterPartition : newPartitions) {
            MasterSlaveEntry entry = this.getEntry(clusterPartition.getMasterAddress());
            for (Integer slot : clusterPartition.getSlots()) {
                if (this.lastPartitions.containsKey(slot) || entry == null) continue;
                this.addEntry(slot, entry);
                this.lastPartitions.put(slot, clusterPartition);
                Integer n = addedSlots;
                Integer n2 = addedSlots = Integer.valueOf(addedSlots + 1);
            }
        }
        if (addedSlots > 0) {
            this.log.info("{} slots found to add", (Object)addedSlots);
        }
    }

    private void checkSlotsMigration(Collection<ClusterPartition> newPartitions) {
        block0: for (ClusterPartition currentPartition : this.getLastPartitions()) {
            for (ClusterPartition newPartition : newPartitions) {
                if (!currentPartition.getNodeId().equals(newPartition.getNodeId())) continue;
                MasterSlaveEntry entry = this.getEntry(currentPartition.slots().nextSetBit(0));
                BitSet addedSlots = newPartition.copySlots();
                addedSlots.andNot(currentPartition.slots());
                currentPartition.addSlots(addedSlots);
                for (Integer slot : addedSlots.stream()::iterator) {
                    this.addEntry(slot, entry);
                    this.lastPartitions.put(slot, currentPartition);
                }
                if (!addedSlots.isEmpty()) {
                    this.log.info("{} slots added to {}", (Object)addedSlots.cardinality(), (Object)currentPartition.getMasterAddress());
                }
                BitSet removedSlots = currentPartition.copySlots();
                removedSlots.andNot(newPartition.slots());
                currentPartition.removeSlots(removedSlots);
                for (Integer removeSlot : removedSlots.stream()::iterator) {
                    if (!this.lastPartitions.remove(removeSlot, currentPartition)) continue;
                    this.removeEntry(removeSlot);
                }
                if (removedSlots.isEmpty()) continue block0;
                this.log.info("{} slots removed from {}", (Object)removedSlots.cardinality(), (Object)currentPartition.getMasterAddress());
                continue block0;
            }
        }
    }

    private int indexOf(byte[] array, byte element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int calcSlot(byte[] key) {
        int end;
        if (key == null) {
            return 0;
        }
        int start = this.indexOf(key, (byte)123);
        if (start != -1 && (end = this.indexOf(key, (byte)125)) != -1 && start + 1 < end) {
            key = Arrays.copyOfRange(key, start + 1, end);
        }
        int result = CRC16.crc16(key) % 16384;
        return result;
    }

    @Override
    public int calcSlot(String key) {
        int end;
        if (key == null) {
            return 0;
        }
        int start = key.indexOf(123);
        if (start != -1 && (end = key.indexOf(125)) != -1 && start + 1 < end) {
            key = key.substring(start + 1, end);
        }
        int result = CRC16.crc16(key.getBytes()) % 16384;
        this.log.debug("slot {} for {}", (Object)result, (Object)key);
        return result;
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        return this.natMapper.map(address);
    }

    private Collection<ClusterPartition> parsePartitions(List<ClusterNodeInfo> nodes) {
        HashMap<String, ClusterPartition> partitions = new HashMap<String, ClusterPartition>();
        for (ClusterNodeInfo clusterNodeInfo : nodes) {
            ClusterPartition masterPartition;
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.NOADDR) || clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.HANDSHAKE)) continue;
            String masterId = clusterNodeInfo.getNodeId();
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                masterId = clusterNodeInfo.getSlaveOf();
            }
            if (masterId == null) continue;
            RedisURI address = this.applyNatMap(clusterNodeInfo.getAddress());
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                masterPartition = this.getPartition(partitions, masterId);
                ClusterPartition slavePartition = this.getPartition(partitions, clusterNodeInfo.getNodeId());
                slavePartition.setType(ClusterPartition.Type.SLAVE);
                slavePartition.setParent(masterPartition);
                masterPartition.addSlaveAddress(address);
                if (!clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL)) continue;
                masterPartition.addFailedSlaveAddress(address);
                continue;
            }
            if (!clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.MASTER)) continue;
            masterPartition = this.getPartition(partitions, masterId);
            masterPartition.addSlotRanges(clusterNodeInfo.getSlotRanges());
            masterPartition.setMasterAddress(address);
            masterPartition.setType(ClusterPartition.Type.MASTER);
            if (!clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL)) continue;
            masterPartition.setMasterFail(true);
        }
        this.addCascadeSlaves(partitions);
        return partitions.values();
    }

    private void addCascadeSlaves(Map<String, ClusterPartition> partitions) {
        Iterator<ClusterPartition> iter = partitions.values().iterator();
        while (iter.hasNext()) {
            ClusterPartition cp = iter.next();
            if (cp.getType() != ClusterPartition.Type.SLAVE) continue;
            if (cp.getParent() != null && cp.getParent().getType() == ClusterPartition.Type.MASTER) {
                ClusterPartition parent = cp.getParent();
                for (RedisURI addr : cp.getSlaveAddresses()) {
                    parent.addSlaveAddress(addr);
                }
                for (RedisURI addr : cp.getFailedSlaveAddresses()) {
                    parent.addFailedSlaveAddress(addr);
                }
            }
            iter.remove();
        }
    }

    private ClusterPartition getPartition(Map<String, ClusterPartition> partitions, String id) {
        ClusterPartition partition = partitions.get(id);
        if (partition == null) {
            partition = new ClusterPartition(id);
            partitions.put(id, partition);
        }
        return partition;
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.closeNodeConnections();
        super.shutdown();
    }

    private Set<ClusterPartition> getLastPartitions() {
        return new HashSet<ClusterPartition>(this.lastPartitions.values());
    }

    @Override
    public RedisURI getLastClusterNode() {
        return this.lastClusterNode;
    }

    @Override
    public boolean isClusterMode() {
        return true;
    }
}

