/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PingConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PingConnectionHandler.class);
    private final RedisClientConfig config;

    public PingConnectionHandler(RedisClientConfig config) {
        this.config = config;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        ((RedisConnection)connection).getConnectionPromise().onComplete((res, e) -> {
            if (e == null) {
                this.sendPing(ctx);
            }
        });
        ctx.fireChannelActive();
    }

    private void sendPing(final ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        CommandData<?, ?> commandData = ((RedisConnection)connection).getCurrentCommand();
        final RFuture future = commandData == null || !commandData.isBlockingCommand() ? ((RedisConnection)connection).async(StringCodec.INSTANCE, RedisCommands.PING, new Object[0]) : null;
        this.config.getTimer().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                if (future != null && (future.cancel(false) || !future.isSuccess())) {
                    ctx.channel().close();
                    if (future.cause() != null) {
                        log.error("Unable to send PING command over channel: " + ctx.channel(), future.cause());
                    }
                    log.debug("channel: {} closed due to PING response timeout set in {} ms", (Object)ctx.channel(), (Object)PingConnectionHandler.this.config.getPingConnectionInterval());
                } else {
                    PingConnectionHandler.this.sendPing(ctx);
                }
            }
        }, this.config.getPingConnectionInterval(), TimeUnit.MILLISECONDS);
    }
}

