/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonReference;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RId;
import org.redisson.api.annotation.RIndex;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.NamingScheme;

public class AccessorInterceptor {
    private final CommandAsyncExecutor commandExecutor;
    private final ConnectionManager connectionManager;

    public AccessorInterceptor(CommandAsyncExecutor commandExecutor, ConnectionManager connectionManager) {
        this.commandExecutor = commandExecutor;
        this.connectionManager = connectionManager;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @SuperCall Callable<?> superMethod, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectLiveMap") RMap<String, Object> liveMap) throws Exception {
        if (this.isGetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            return ((RLiveObject)me).getLiveObjectId();
        }
        if (this.isSetter(method, AccessorInterceptor.getREntityIdFieldName(me))) {
            ((RLiveObject)me).setLiveObjectId(args[0]);
            return null;
        }
        String fieldName = this.getFieldName(method);
        Field field = ClassUtils.getDeclaredField(me.getClass().getSuperclass(), fieldName);
        Class<?> fieldType = field.getType();
        if (this.isGetter(method, fieldName)) {
            RObject ar;
            Object result = liveMap.get(fieldName);
            if (result == null && (ar = this.connectionManager.getCommandExecutor().getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), fieldType, fieldName)) != null) {
                this.connectionManager.getCommandExecutor().getObjectBuilder().store(ar, fieldName, liveMap);
                return ar;
            }
            if (result != null && fieldType.isEnum()) {
                if (result instanceof String) {
                    return Enum.valueOf(fieldType, (String)result);
                }
                return result;
            }
            if (result instanceof RedissonReference) {
                return this.connectionManager.getCommandExecutor().getObjectBuilder().fromReference((RedissonReference)result);
            }
            return result;
        }
        if (this.isSetter(method, fieldName)) {
            Object arg = args[0];
            if (arg != null && ClassUtils.isAnnotationPresent(arg.getClass(), REntity.class)) {
                throw new IllegalStateException("REntity object should be attached to Redisson first");
            }
            if (arg instanceof RLiveObject) {
                RLiveObject liveObject = (RLiveObject)arg;
                this.storeIndex(field, me, liveObject.getLiveObjectId());
                Class<?> rEntity = liveObject.getClass().getSuperclass();
                NamingScheme ns = this.connectionManager.getCommandExecutor().getObjectBuilder().getNamingScheme(rEntity);
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, fieldType, AccessorInterceptor.getREntityIdFieldName(liveObject), liveObject.getLiveObjectId())));
                } else {
                    liveMap.fastPut(fieldName, new RedissonReference(rEntity, ns.getName(rEntity, fieldType, AccessorInterceptor.getREntityIdFieldName(liveObject), liveObject.getLiveObjectId())));
                }
                return me;
            }
            if (!(arg instanceof RObject) && (arg instanceof Collection || arg instanceof Map) && REntity.TransformationMode.ANNOTATION_BASED.equals((Object)ClassUtils.getAnnotation(me.getClass().getSuperclass(), REntity.class).fieldTransformation())) {
                RObject rObject = this.connectionManager.getCommandExecutor().getObjectBuilder().createObject(((RLiveObject)me).getLiveObjectId(), me.getClass().getSuperclass(), arg.getClass(), fieldName);
                if (arg != null) {
                    if (rObject instanceof Collection) {
                        Collection c = (Collection)((Object)rObject);
                        c.clear();
                        c.addAll((Collection)arg);
                    } else {
                        Map m = (Map)((Object)rObject);
                        m.clear();
                        m.putAll((Map)arg);
                    }
                }
                if (rObject != null) {
                    arg = rObject;
                }
            }
            if (arg instanceof RObject) {
                this.connectionManager.getCommandExecutor().getObjectBuilder().store((RObject)arg, fieldName, liveMap);
                return me;
            }
            if (arg == null) {
                Object oldArg = liveMap.remove(fieldName);
                if (field.getAnnotation(RIndex.class) != null) {
                    NamingScheme namingScheme = this.connectionManager.getCommandExecutor().getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
                    String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), fieldName);
                    CommandBatchService ce = this.commandExecutor instanceof CommandBatchService ? (CommandBatchService)this.commandExecutor : new CommandBatchService(this.connectionManager);
                    if (oldArg instanceof Number) {
                        RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
                        set.removeAsync(((RLiveObject)me).getLiveObjectId());
                    } else {
                        RedissonSetMultimap map = new RedissonSetMultimap(namingScheme.getCodec(), ce, indexName);
                        if (oldArg instanceof RLiveObject) {
                            map.removeAsync(((RLiveObject)oldArg).getLiveObjectId(), ((RLiveObject)me).getLiveObjectId());
                        } else {
                            map.removeAsync(oldArg, ((RLiveObject)me).getLiveObjectId());
                        }
                    }
                    ce.execute();
                }
            } else {
                this.storeIndex(field, me, arg);
                if (this.commandExecutor instanceof CommandBatchService) {
                    liveMap.fastPutAsync(fieldName, arg);
                } else {
                    liveMap.fastPut(fieldName, arg);
                }
            }
            return me;
        }
        return superMethod.call();
    }

    protected void storeIndex(Field field, Object me, Object arg) {
        if (field.getAnnotation(RIndex.class) != null) {
            CommandBatchService ce;
            NamingScheme namingScheme = this.connectionManager.getCommandExecutor().getObjectBuilder().getNamingScheme(me.getClass().getSuperclass());
            String indexName = namingScheme.getIndexName(me.getClass().getSuperclass(), field.getName());
            boolean skipExecution = false;
            if (this.commandExecutor instanceof CommandBatchService) {
                ce = (CommandBatchService)this.commandExecutor;
                skipExecution = true;
            } else {
                ce = new CommandBatchService(this.connectionManager);
            }
            if (arg instanceof Number) {
                RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
                set.addAsync(((Number)arg).doubleValue(), ((RLiveObject)me).getLiveObjectId());
            } else {
                RedissonSetMultimap<Object, Object> map = new RedissonSetMultimap<Object, Object>(namingScheme.getCodec(), ce, indexName);
                map.putAsync(arg, ((RLiveObject)me).getLiveObjectId());
            }
            if (!skipExecution) {
                ce.execute();
            }
        }
    }

    private String getFieldName(Method method) {
        String name = method.getName();
        int i = 4;
        if (name.startsWith("is")) {
            i = 3;
        }
        return name.substring(i - 1, i).toLowerCase() + name.substring(i);
    }

    private boolean isGetter(Method method, String fieldName) {
        return method.getName().equals("get" + AccessorInterceptor.getFieldNameSuffix(fieldName)) || method.getName().equals("is" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private boolean isSetter(Method method, String fieldName) {
        return method.getName().equals("set" + AccessorInterceptor.getFieldNameSuffix(fieldName));
    }

    private static String getFieldNameSuffix(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String getREntityIdFieldName(Object o) {
        return ((FieldDescription.InDefinedShape)Introspectior.getFieldsWithAnnotation(o.getClass().getSuperclass(), RId.class).getOnly()).getName();
    }
}

