/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;

public class Injector {
    public static void inject(Object task, RedissonClient redisson) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        Class<?> clazz = task.getClass();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            allFields.addAll(Arrays.asList(fields));
            if (clazz.getSuperclass() != Object.class) {
                clazz = clazz.getSuperclass();
                continue;
            }
            clazz = null;
        }
        for (Field field : allFields) {
            if (!RedissonClient.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(RInject.class)) continue;
            field.setAccessible(true);
            try {
                field.set(task, redisson);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

