/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.BatchOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandBatchService;
import org.redisson.command.RedisExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.RPromise;

public class BaseRedisBatchExecutor<V, R>
extends RedisExecutor<V, R> {
    final ConcurrentMap<MasterSlaveEntry, CommandBatchService.Entry> commands;
    final BatchOptions options;
    final AtomicInteger index;
    final AtomicBoolean executed;

    public BaseRedisBatchExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, ConcurrentMap<MasterSlaveEntry, CommandBatchService.Entry> commands, BatchOptions options, AtomicInteger index, AtomicBoolean executed) {
        super(readOnlyMode, source, codec, command, params, mainPromise, ignoreRedirect, connectionManager, objectBuilder);
        this.commands = commands;
        this.options = options;
        this.index = index;
        this.executed = executed;
    }

    protected final void addBatchCommandData(Object[] batchParams) {
        if (this.source.getEntry() != null) {
            CommandBatchService.Entry entry = (CommandBatchService.Entry)this.commands.get(this.source.getEntry());
            if (entry == null) {
                entry = new CommandBatchService.Entry();
                CommandBatchService.Entry oldEntry = this.commands.putIfAbsent(this.source.getEntry(), entry);
                if (oldEntry != null) {
                    entry = oldEntry;
                }
            }
            if (!this.readOnlyMode) {
                entry.setReadOnlyMode(false);
            }
            Codec codecToUse = this.getCodec(this.codec);
            BatchCommandData commandData = new BatchCommandData(this.mainPromise, codecToUse, this.command, batchParams, this.index.incrementAndGet());
            entry.getCommands().add(commandData);
        }
    }
}

