/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonQueue;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;

public class RedissonBlockingQueue<V>
extends RedissonQueue<V>
implements RBlockingQueue<V> {
    public RedissonBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        return this.addAsync(e, RedisCommands.RPUSH_VOID);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.get(this.putAsync(e));
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), 0);
    }

    @Override
    public V take() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.getName(), this.toSeconds(timeout, unit));
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.commandExecutor.pollFromAnyAsync(this.getName(), this.codec, RedisCommands.BLPOP_VALUE, this.toSeconds(timeout, unit), queueNames);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOPLPUSH, this.getName(), queueName, this.toSeconds(timeout, unit));
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); return vals", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getName()), maxElements);
    }
}

