/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.FstCodec;
import org.xerial.snappy.Snappy;

public class SnappyCodecV2
extends BaseCodec {
    private final Codec innerCodec;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            bytes = Snappy.uncompress(bytes);
            ByteBuf bf = Unpooled.wrappedBuffer(bytes);
            try {
                Object object = SnappyCodecV2.this.innerCodec.getValueDecoder().decode(bf, state);
                return object;
            }
            finally {
                bf.release();
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf encoded = SnappyCodecV2.this.innerCodec.getValueEncoder().encode(in);
            byte[] bytes = new byte[encoded.readableBytes()];
            encoded.readBytes(bytes);
            encoded.release();
            byte[] res = Snappy.compress(bytes);
            return Unpooled.wrappedBuffer(res);
        }
    };

    public SnappyCodecV2() {
        this(new FstCodec());
    }

    public SnappyCodecV2(Codec innerCodec) {
        this.innerCodec = innerCodec;
    }

    public SnappyCodecV2(ClassLoader classLoader) {
        this(new FstCodec(classLoader));
    }

    public SnappyCodecV2(ClassLoader classLoader, SnappyCodecV2 codec) throws ReflectiveOperationException {
        this(SnappyCodecV2.copy(classLoader, codec.innerCodec));
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

