/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.channel.ChannelFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;

public class PubSubConnectionEntry {
    private final AtomicInteger subscribedChannelsAmount;
    private final RedisPubSubConnection conn;
    private final ConcurrentMap<ChannelName, SubscribeListener> subscribeChannelListeners = new ConcurrentHashMap<ChannelName, SubscribeListener>();
    private final ConcurrentMap<ChannelName, Queue<RedisPubSubListener<?>>> channelListeners = new ConcurrentHashMap();

    public PubSubConnectionEntry(RedisPubSubConnection conn, int subscriptionsPerConnection) {
        this.conn = conn;
        this.subscribedChannelsAmount = new AtomicInteger(subscriptionsPerConnection);
    }

    public int countListeners() {
        return this.channelListeners.size();
    }

    public boolean hasListeners(ChannelName channelName) {
        return this.channelListeners.containsKey(channelName);
    }

    public Collection<RedisPubSubListener<?>> getListeners(ChannelName channelName) {
        Collection result = (Collection)this.channelListeners.get(channelName);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        Queue oldQueue;
        if (listener == null) {
            return;
        }
        Queue<RedisPubSubListener<Object>> queue = (ConcurrentLinkedQueue)this.channelListeners.get(channelName);
        if (queue == null && (oldQueue = (Queue)this.channelListeners.putIfAbsent(channelName, queue = new ConcurrentLinkedQueue())) != null) {
            queue = oldQueue;
        }
        boolean deleted = false;
        ConcurrentLinkedQueue concurrentLinkedQueue = queue;
        synchronized (concurrentLinkedQueue) {
            if (this.channelListeners.get(channelName) != queue) {
                deleted = true;
            } else {
                queue.add(listener);
            }
        }
        if (deleted) {
            this.addListener(channelName, listener);
            return;
        }
        this.conn.addListener(listener);
    }

    public boolean removeAllListeners(ChannelName channelName) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            this.removeListener(channelName, listener);
        }
        return listeners.isEmpty();
    }

    public boolean removeListener(ChannelName channelName, EventListener msgListener) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (listener instanceof PubSubMessageListener && ((PubSubMessageListener)listener).getListener() == msgListener) {
                this.removeListener(channelName, listener);
                return true;
            }
            if (!(listener instanceof PubSubPatternMessageListener) || ((PubSubPatternMessageListener)listener).getListener() != msgListener) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(ChannelName channelName, int listenerId) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (System.identityHashCode(listener) != listenerId) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.channelListeners.get(channelName);
        synchronized (queue2) {
            if (queue.remove(listener) && queue.isEmpty()) {
                this.channelListeners.remove(channelName);
            }
        }
        this.conn.removeListener(listener);
    }

    public int tryAcquire() {
        int value;
        do {
            if ((value = this.subscribedChannelsAmount.get()) != 0) continue;
            return -1;
        } while (!this.subscribedChannelsAmount.compareAndSet(value, value - 1));
        return value - 1;
    }

    public int release() {
        return this.subscribedChannelsAmount.incrementAndGet();
    }

    public ChannelFuture subscribe(Codec codec, ChannelName channelName) {
        return this.conn.subscribe(codec, channelName);
    }

    public ChannelFuture psubscribe(Codec codec, ChannelName pattern) {
        return this.conn.psubscribe(codec, pattern);
    }

    public SubscribeListener getSubscribeFuture(ChannelName channel, PubSubType type) {
        SubscribeListener listener = (SubscribeListener)this.subscribeChannelListeners.get(channel);
        if (listener == null) {
            listener = new SubscribeListener(channel, type);
            SubscribeListener oldSubscribeListener = this.subscribeChannelListeners.putIfAbsent(channel, listener);
            if (oldSubscribeListener != null) {
                listener = oldSubscribeListener;
            } else {
                this.conn.addListener(listener);
            }
        }
        return listener;
    }

    public ChannelFuture unsubscribe(final ChannelName channel, final RedisPubSubListener<?> listener) {
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, CharSequence ch) {
                if (type == PubSubType.UNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, ch);
                    }
                    return true;
                }
                return false;
            }
        });
        return this.conn.unsubscribe(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners(ChannelName channel) {
        this.conn.removeDisconnectListener(channel);
        SubscribeListener s = (SubscribeListener)this.subscribeChannelListeners.remove(channel);
        this.conn.removeListener(s);
        Queue queue = (Queue)this.channelListeners.get(channel);
        if (queue != null) {
            Queue queue2 = queue;
            synchronized (queue2) {
                this.channelListeners.remove(channel);
            }
            for (RedisPubSubListener listener : queue) {
                this.conn.removeListener(listener);
            }
        }
    }

    public ChannelFuture punsubscribe(final ChannelName channel, final RedisPubSubListener<?> listener) {
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, CharSequence ch) {
                if (type == PubSubType.PUNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, ch);
                    }
                    return true;
                }
                return false;
            }
        });
        return this.conn.punsubscribe(channel);
    }

    public RedisPubSubConnection getConnection() {
        return this.conn;
    }
}

