/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;

public class RedissonNodeConfig
extends Config {
    private int mapReduceWorkers = 0;
    private RedissonNodeInitializer redissonNodeInitializer;
    private Map<String, Integer> executorServiceWorkers = new HashMap<String, Integer>();

    public RedissonNodeConfig() {
    }

    public RedissonNodeConfig(Config oldConf) {
        super(oldConf);
    }

    public RedissonNodeConfig(RedissonNodeConfig oldConf) {
        super(oldConf);
        this.executorServiceWorkers = new HashMap<String, Integer>(oldConf.executorServiceWorkers);
        this.redissonNodeInitializer = oldConf.redissonNodeInitializer;
        this.mapReduceWorkers = oldConf.mapReduceWorkers;
    }

    public RedissonNodeConfig setMapReduceWorkers(int mapReduceWorkers) {
        this.mapReduceWorkers = mapReduceWorkers;
        return this;
    }

    public int getMapReduceWorkers() {
        return this.mapReduceWorkers;
    }

    public RedissonNodeConfig setExecutorServiceWorkers(Map<String, Integer> workers) {
        this.executorServiceWorkers = workers;
        return this;
    }

    public Map<String, Integer> getExecutorServiceWorkers() {
        return this.executorServiceWorkers;
    }

    public RedissonNodeConfig setRedissonNodeInitializer(RedissonNodeInitializer redissonNodeInitializer) {
        this.redissonNodeInitializer = redissonNodeInitializer;
        return this;
    }

    public RedissonNodeInitializer getRedissonNodeInitializer() {
        return this.redissonNodeInitializer;
    }

    public static RedissonNodeConfig fromJSON(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(file, RedissonNodeConfig.class);
    }

    public static RedissonNodeConfig fromYAML(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(file, RedissonNodeConfig.class);
    }
}

