/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonReference;
import org.redisson.api.DeletedObjectListener;
import org.redisson.api.ExpiredObjectListener;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CountableListener;
import org.redisson.misc.Hash;
import org.redisson.misc.RedissonPromise;

public abstract class RedissonObject
implements RObject {
    protected final CommandAsyncExecutor commandExecutor;
    private String name;
    protected final Codec codec;

    public RedissonObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this.codec = codec;
        this.name = name;
        this.commandExecutor = commandExecutor;
    }

    public RedissonObject(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    protected boolean await(RFuture<?> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        return this.commandExecutor.await(future, timeout, timeoutUnit);
    }

    public static String prefixName(String prefix, String name) {
        if (name.contains("{")) {
            return prefix + ":" + name;
        }
        return prefix + ":{" + name + "}";
    }

    public static String suffixName(String name, String suffix) {
        if (name.contains("{")) {
            return name + ":" + suffix;
        }
        return "{" + name + "}:" + suffix;
    }

    protected final <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    protected final <V> V get(RFuture<V> future) {
        return this.commandExecutor.get(future);
    }

    protected final long toSeconds(long timeout, TimeUnit unit) {
        long seconds = unit.toSeconds(timeout);
        if (timeout != 0L && seconds == 0L) {
            seconds = 1L;
        }
        return seconds;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getName(Object o) {
        return this.getName();
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.MEMORY_USAGE, this.getName());
    }

    public final RFuture<Long> sizeInMemoryAsync(List<Object> keys) {
        return this.commandExecutor.evalWriteAsync((String)keys.get(0), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_LONG, "local total = 0;for j = 1, #KEYS, 1 do local size = redis.call('memory', 'usage', KEYS[j]); if size ~= false then total = total + size;end; end; return total; ", keys, new Object[0]);
    }

    @Override
    public long sizeInMemory() {
        return this.get(this.sizeInMemoryAsync());
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        RFuture<Void> f = this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAME, this.getName(), newName);
        f.onComplete((r, e) -> {
            if (e == null) {
                this.name = newName;
            }
        });
        return f;
    }

    @Override
    public void migrate(String host, int port, int database, long timeout) {
        this.get(this.migrateAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getName(), database, timeout);
    }

    @Override
    public void copy(String host, int port, int database, long timeout) {
        this.get(this.copyAsync(host, port, database, timeout));
    }

    @Override
    public RFuture<Void> copyAsync(String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.MIGRATE, host, port, this.getName(), database, timeout, "COPY");
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        RFuture<Boolean> f = this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.RENAMENX, this.getName(), newName);
        f.onComplete((value, e) -> {
            if (e == null && value.booleanValue()) {
                this.name = newName;
            }
        });
        return f;
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.DEL_BOOL, this.getName());
    }

    @Override
    public boolean unlink() {
        return this.get(this.unlinkAsync());
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.UNLINK_BOOL, this.getName());
    }

    @Override
    public boolean touch() {
        return this.get(this.touchAsync());
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.TOUCH, this.getName());
    }

    @Override
    public boolean isExists() {
        return this.get(this.isExistsAsync());
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EXISTS, this.getName());
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    protected List<ByteBuf> encode(Collection<?> values) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(values.size());
        for (Object object : values) {
            result.add(this.encode(object));
        }
        return result;
    }

    public void encode(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encode(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockByMapKey(Object key, String suffix) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = RedissonObject.suffixName(this.getName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockByValue(Object key, String suffix) {
        ByteBuf keyState = this.encode(key);
        try {
            String string = RedissonObject.suffixName(this.getName(key), Hash.hash128toBase64(keyState) + ":" + suffix);
            return string;
        }
        finally {
            keyState.release();
        }
    }

    protected void encodeMapKeys(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encodeMapKey(object));
        }
    }

    protected void encodeMapValues(Collection<Object> params, Collection<?> values) {
        for (Object object : values) {
            params.add(this.encodeMapValue(object));
        }
    }

    public ByteBuf encode(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = this.commandExecutor.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ByteBuf encodeMapKey(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = this.commandExecutor.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapKeyEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ByteBuf encodeMapValue(Object value) {
        RedissonReference reference;
        if (this.commandExecutor.isRedissonReferenceSupportEnabled() && (reference = this.commandExecutor.getObjectBuilder().toReference(value)) != null) {
            value = reference;
        }
        try {
            return this.codec.getMapValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public byte[] dump() {
        return this.get(this.dumpAsync());
    }

    @Override
    public RFuture<byte[]> dumpAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.DUMP, this.getName());
    }

    @Override
    public void restore(byte[] state) {
        this.get(this.restoreAsync(state));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state) {
        return this.restoreAsync(state, 0L, null);
    }

    @Override
    public void restore(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getName(), ttl, state);
    }

    @Override
    public void restoreAndReplace(byte[] state, long timeToLive, TimeUnit timeUnit) {
        this.get(this.restoreAndReplaceAsync(state, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        long ttl = 0L;
        if (timeToLive > 0L) {
            ttl = timeUnit.toMillis(timeToLive);
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.RESTORE, this.getName(), ttl, state, "REPLACE");
    }

    @Override
    public void restoreAndReplace(byte[] state) {
        this.get(this.restoreAndReplaceAsync(state));
    }

    @Override
    public RFuture<Void> restoreAndReplaceAsync(byte[] state) {
        return this.restoreAndReplaceAsync(state, 0L, null);
    }

    @Override
    public int addListener(final ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
            return topic.addListener(String.class, new PatternMessageListener<String>(){

                @Override
                public void onMessage(CharSequence pattern, CharSequence channel, String msg) {
                    if (msg.equals(RedissonObject.this.getName())) {
                        ((ExpiredObjectListener)listener).onExpired(msg);
                    }
                }
            });
        }
        if (listener instanceof DeletedObjectListener) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
            return topic.addListener(String.class, new PatternMessageListener<String>(){

                @Override
                public void onMessage(CharSequence pattern, CharSequence channel, String msg) {
                    if (msg.equals(RedissonObject.this.getName())) {
                        ((DeletedObjectListener)listener).onDeleted(msg);
                    }
                }
            });
        }
        throw new IllegalArgumentException();
    }

    @Override
    public RFuture<Integer> addListenerAsync(final ObjectListener listener) {
        if (listener instanceof ExpiredObjectListener) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
            return topic.addListenerAsync(String.class, new PatternMessageListener<String>(){

                @Override
                public void onMessage(CharSequence pattern, CharSequence channel, String msg) {
                    if (msg.equals(RedissonObject.this.getName())) {
                        ((ExpiredObjectListener)listener).onExpired(msg);
                    }
                }
            });
        }
        if (listener instanceof DeletedObjectListener) {
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
            return topic.addListenerAsync(String.class, new PatternMessageListener<String>(){

                @Override
                public void onMessage(CharSequence pattern, CharSequence channel, String msg) {
                    if (msg.equals(RedissonObject.this.getName())) {
                        ((DeletedObjectListener)listener).onDeleted(msg);
                    }
                }
            });
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void removeListener(int listenerId) {
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
        expiredTopic.removeListener(listenerId);
        RedissonPatternTopic deletedTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
        deletedTopic.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        CountableListener<Object> listener = new CountableListener<Object>(result, null, 2);
        RedissonPatternTopic expiredTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:expired");
        expiredTopic.removeListenerAsync(listenerId).onComplete(listener);
        RedissonPatternTopic deletedTopic = new RedissonPatternTopic(StringCodec.INSTANCE, this.commandExecutor, "__keyevent@*:del");
        deletedTopic.removeListenerAsync(listenerId).onComplete(listener);
        return result;
    }
}

