/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.function.Supplier;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.redisson.reactive.CommandReactiveService;
import reactor.core.publisher.Mono;

public class CommandReactiveBatchService
extends CommandReactiveService {
    private final CommandBatchService batchService;

    public CommandReactiveBatchService(ConnectionManager connectionManager, BatchOptions options) {
        super(connectionManager);
        this.batchService = new CommandBatchService(connectionManager, options);
    }

    @Override
    public <R> Mono<R> reactive(final Supplier<RFuture<R>> supplier) {
        Mono mono = super.reactive(new Supplier<RFuture<R>>(){
            volatile RFuture<R> future;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RFuture<R> get() {
                if (this.future == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.future == null) {
                            this.future = (RFuture)supplier.get();
                        }
                    }
                }
                return this.future;
            }
        });
        mono.subscribe();
        return mono;
    }

    @Override
    protected <R> RPromise<R> createPromise() {
        return this.batchService.createPromise();
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt, boolean ignoreRedirect) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, attempt, ignoreRedirect);
    }

    public RFuture<BatchResult<?>> executeAsync(BatchOptions options) {
        return this.batchService.executeAsync(options);
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        this.batchService.enableRedissonReferenceSupport(redissonReactive);
        return super.enableRedissonReferenceSupport(redissonReactive);
    }
}

