/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AsyncSemaphore {
    private int counter;
    private final Set<Entry> listeners = new LinkedHashSet<Entry>();

    public AsyncSemaphore(int permits) {
        this.counter = permits;
    }

    public boolean tryAcquire(long timeoutMillis) {
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable listener = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.acquire(listener);
        try {
            boolean res = latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!res && !this.remove(listener)) {
                this.release();
            }
            return res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!this.remove(listener)) {
                this.release();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueSize() {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners() {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            this.listeners.clear();
        }
    }

    public void acquire(Runnable listener) {
        this.acquire(listener, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Runnable listener, int permits) {
        boolean run = false;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            if (this.counter < permits) {
                this.listeners.add(new Entry(listener, permits));
                return;
            }
            this.counter -= permits;
            run = true;
        }
        if (run) {
            listener.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable listener) {
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            return this.listeners.remove(new Entry(listener, 0));
        }
    }

    public int getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Entry entryToAcquire = null;
        AsyncSemaphore asyncSemaphore = this;
        synchronized (asyncSemaphore) {
            Entry entry;
            ++this.counter;
            Iterator<Entry> iter = this.listeners.iterator();
            if (iter.hasNext() && (entry = iter.next()).getPermits() >= this.counter) {
                iter.remove();
                entryToAcquire = entry;
            }
        }
        if (entryToAcquire != null) {
            this.acquire(entryToAcquire.getRunnable(), entryToAcquire.getPermits());
        }
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }

    private static class Entry {
        private Runnable runnable;
        private int permits;

        Entry(Runnable runnable, int permits) {
            this.runnable = runnable;
            this.permits = permits;
        }

        public int getPermits() {
            return this.permits;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.runnable == null ? 0 : this.runnable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return !(this.runnable == null ? other.runnable != null : !this.runnable.equals(other.runnable));
        }
    }
}

