/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation;

import org.redisson.RedissonKeys;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class DeleteOperation
extends TransactionalOperation {
    private String lockName;
    private String transactionId;

    public DeleteOperation(String name) {
        this(name, null, null);
    }

    public DeleteOperation(String name, String lockName, String transactionId) {
        super(name, null);
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonKeys keys = new RedissonKeys(commandExecutor);
        keys.deleteAsync(this.getName());
        if (this.lockName != null) {
            RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync();
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        if (this.lockName != null) {
            RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync();
        }
    }

    public String getLockName() {
        return this.lockName;
    }
}

