/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonDeque;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonRedLock;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonStream;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNode;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDoubleRx;
import org.redisson.api.RAtomicLongRx;
import org.redisson.api.RBatchRx;
import org.redisson.api.RBitSetRx;
import org.redisson.api.RBlockingDequeRx;
import org.redisson.api.RBlockingQueueRx;
import org.redisson.api.RBucketRx;
import org.redisson.api.RDequeRx;
import org.redisson.api.RGeoRx;
import org.redisson.api.RHyperLogLogRx;
import org.redisson.api.RKeysRx;
import org.redisson.api.RLexSortedSetRx;
import org.redisson.api.RListMultimapRx;
import org.redisson.api.RListRx;
import org.redisson.api.RLock;
import org.redisson.api.RLockRx;
import org.redisson.api.RMapCacheRx;
import org.redisson.api.RMapRx;
import org.redisson.api.RPatternTopicRx;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RQueueRx;
import org.redisson.api.RRateLimiterRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RScoredSortedSetRx;
import org.redisson.api.RScriptRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RSetCacheRx;
import org.redisson.api.RSetMultimapRx;
import org.redisson.api.RSetRx;
import org.redisson.api.RStreamRx;
import org.redisson.api.RTopicRx;
import org.redisson.api.RTransactionRx;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.rx.CommandRxExecutor;
import org.redisson.rx.CommandRxService;
import org.redisson.rx.RedissonBatchRx;
import org.redisson.rx.RedissonBlockingDequeRx;
import org.redisson.rx.RedissonBlockingQueueRx;
import org.redisson.rx.RedissonKeysRx;
import org.redisson.rx.RedissonLexSortedSetRx;
import org.redisson.rx.RedissonListMultimapRx;
import org.redisson.rx.RedissonListRx;
import org.redisson.rx.RedissonMapCacheRx;
import org.redisson.rx.RedissonMapRx;
import org.redisson.rx.RedissonReadWriteLockRx;
import org.redisson.rx.RedissonScoredSortedSetRx;
import org.redisson.rx.RedissonSetCacheRx;
import org.redisson.rx.RedissonSetMultimapRx;
import org.redisson.rx.RedissonSetRx;
import org.redisson.rx.RedissonTopicRx;
import org.redisson.rx.RedissonTransactionRx;
import org.redisson.rx.RxProxyBuilder;

public class RedissonRx
implements RedissonRxClient {
    protected final EvictionScheduler evictionScheduler;
    protected final CommandRxExecutor commandExecutor;
    protected final ConnectionManager connectionManager;
    protected final Config config;

    protected RedissonRx(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        this.commandExecutor = new CommandRxService(this.connectionManager);
        this.evictionScheduler = new EvictionScheduler(this.commandExecutor);
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public <K, V> RStreamRx<K, V> getStream(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonStream(codec, this.commandExecutor, name), RStreamRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public <V> RGeoRx<V> getGeo(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, new RedissonGeo(codec, this.commandExecutor, name, null), new RedissonScoredSortedSetRx(set), RGeoRx.class);
    }

    @Override
    public RLockRx getFairLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonFairLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RRateLimiterRx getRateLimiter(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRateLimiter(this.commandExecutor, name), RRateLimiterRx.class);
    }

    @Override
    public RSemaphoreRx getSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSemaphore(this.commandExecutor, name), RSemaphoreRx.class);
    }

    @Override
    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPermitExpirableSemaphore(this.commandExecutor, name), RPermitExpirableSemaphoreRx.class);
    }

    @Override
    public RReadWriteLockRx getReadWriteLock(String name) {
        return new RedissonReadWriteLockRx(this.commandExecutor, name);
    }

    @Override
    public RLockRx getLock(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonLock(this.commandExecutor, name), RLockRx.class);
    }

    @Override
    public RLockRx getMultiLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonMultiLock(locks), RLockRx.class);
    }

    @Override
    public RLockRx getRedLock(RLock ... locks) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonRedLock(locks), RLockRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec) {
        RedissonMapCache map = new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name) {
        RedissonMapCache map = new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx(map), RMapCacheRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public <V> RBucketRx<V> getBucket(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBucket(codec, this.commandExecutor, name), RBucketRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public <V> RHyperLogLogRx<V> getHyperLogLog(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonHyperLogLog(codec, this.commandExecutor, name), RHyperLogLogRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name) {
        RedissonList list = new RedissonList(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <V> RListRx<V> getList(String name, Codec codec) {
        RedissonList list = new RedissonList(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, list, new RedissonListRx(list), RListRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(this.commandExecutor, name), new RedissonListMultimapRx(this.commandExecutor, name), RListMultimapRx.class);
    }

    @Override
    public <K, V> RListMultimapRx<K, V> getListMultimap(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonListMultimap(codec, this.commandExecutor, name), new RedissonListMultimapRx(codec, this.commandExecutor, name), RListMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(this.commandExecutor, name), new RedissonSetMultimapRx(this.commandExecutor, name, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RSetMultimapRx<K, V> getSetMultimap(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonSetMultimap(codec, this.commandExecutor, name), new RedissonSetMultimapRx(codec, this.commandExecutor, name, this), RSetMultimapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name) {
        RedissonMap map = new RedissonMap(this.commandExecutor, name, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec) {
        RedissonMap map = new RedissonMap(codec, this.commandExecutor, name, null, null);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx(map, this), RMapRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name) {
        RedissonSet set = new RedissonSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RSetRx<V> getSet(String name, Codec codec) {
        RedissonSet set = new RedissonSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetRx(set, this), RSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public <V> RScoredSortedSetRx<V> getScoredSortedSet(String name, Codec codec) {
        RedissonScoredSortedSet set = new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonScoredSortedSetRx(set), RScoredSortedSetRx.class);
    }

    @Override
    public RLexSortedSetRx getLexSortedSet(String name) {
        RedissonLexSortedSet set = new RedissonLexSortedSet(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonLexSortedSetRx(set), RLexSortedSetRx.class);
    }

    @Override
    public RTopicRx getTopic(String name) {
        RedissonTopic topic = new RedissonTopic(this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RTopicRx getTopic(String name, Codec codec) {
        RedissonTopic topic = new RedissonTopic(codec, this.commandExecutor, name);
        return RxProxyBuilder.create(this.commandExecutor, topic, new RedissonTopicRx(topic), RTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public RPatternTopicRx getPatternTopic(String pattern, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonPatternTopic(codec, this.commandExecutor, pattern), RPatternTopicRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(this.commandExecutor, name, null), new RedissonListRx(new RedissonList(this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RQueueRx<V> getQueue(String name, Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonQueue(codec, this.commandExecutor, name, null), new RedissonListRx(new RedissonList(codec, this.commandExecutor, name, null)), RQueueRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RBlockingQueueRx<V> getBlockingQueue(String name, Codec codec) {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonBlockingQueueRx(queue), RBlockingQueueRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name) {
        RedissonDeque queue = new RedissonDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V> RDequeRx<V> getDeque(String name, Codec codec) {
        RedissonDeque queue = new RedissonDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, queue, new RedissonListRx(queue), RDequeRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name) {
        RedissonSetCache set = new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public <V> RSetCacheRx<V> getSetCache(String name, Codec codec) {
        RedissonSetCache set = new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, set, new RedissonSetCacheRx(set, this), RSetCacheRx.class);
    }

    @Override
    public RAtomicLongRx getAtomicLong(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicLong(this.commandExecutor, name), RAtomicLongRx.class);
    }

    @Override
    public RAtomicDoubleRx getAtomicDouble(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonAtomicDouble(this.commandExecutor, name), RAtomicDoubleRx.class);
    }

    @Override
    public RBitSetRx getBitSet(String name) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonBitSet(this.commandExecutor, name), RBitSetRx.class);
    }

    @Override
    public RScriptRx getScript() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor), RScriptRx.class);
    }

    @Override
    public RScriptRx getScript(Codec codec) {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonScript(this.commandExecutor, codec), RScriptRx.class);
    }

    @Override
    public RBatchRx createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RBatchRx createBatch(BatchOptions options) {
        RedissonBatchRx batch = new RedissonBatchRx(this.evictionScheduler, this.connectionManager, this.commandExecutor, options);
        if (this.config.isReferenceEnabled()) {
            batch.enableRedissonReferenceSupport(this);
        }
        return batch;
    }

    @Override
    public RKeysRx getKeys() {
        return RxProxyBuilder.create(this.commandExecutor, new RedissonKeys(this.commandExecutor), new RedissonKeysRx(this.commandExecutor), RKeysRx.class);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager);
    }

    @Override
    public void shutdown() {
        this.connectionManager.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.isShuttingDown();
    }

    protected void enableRedissonReferenceSupport() {
        this.commandExecutor.enableRedissonReferenceSupport(this);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, null, options);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapCacheRx<K, V> getMapCache(String name, MapOptions<K, V> options) {
        RedissonMapCache<K, V> map = new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.commandExecutor, name, null, options);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapCacheRx<K, V>(map), RMapCacheRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(this.commandExecutor, name, null, options);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this), RMapRx.class);
    }

    @Override
    public <K, V> RMapRx<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        RedissonMap<K, V> map = new RedissonMap<K, V>(codec, this.commandExecutor, name, null, options);
        return RxProxyBuilder.create(this.commandExecutor, map, new RedissonMapRx<K, V>(map, this), RMapRx.class);
    }

    @Override
    public RTransactionRx createTransaction(TransactionOptions options) {
        return new RedissonTransactionRx(this.commandExecutor, options);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }

    @Override
    public <V> RBlockingDequeRx<V> getBlockingDeque(String name, Codec codec) {
        RedissonBlockingDeque deque = new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
        return RxProxyBuilder.create(this.commandExecutor, deque, new RedissonBlockingDequeRx(deque), RBlockingDequeRx.class);
    }
}

