/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.QueueTransferService;
import org.redisson.RedisClusterNodes;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBatch;
import org.redisson.RedissonBinaryStream;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBloomFilter;
import org.redisson.RedissonBoundedBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDelayedQueue;
import org.redisson.RedissonDeque;
import org.redisson.RedissonDoubleAdder;
import org.redisson.RedissonExecutorService;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonLock;
import org.redisson.RedissonLongAdder;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonPriorityBlockingDeque;
import org.redisson.RedissonPriorityBlockingQueue;
import org.redisson.RedissonPriorityDeque;
import org.redisson.RedissonPriorityQueue;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonReactive;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonReference;
import org.redisson.RedissonRemoteService;
import org.redisson.RedissonRx;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapCache;
import org.redisson.RedissonSortedSet;
import org.redisson.RedissonStream;
import org.redisson.RedissonTopic;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNodesGroup;
import org.redisson.api.ExecutorOptions;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RBitSet;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RDeque;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RGeo;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RKeys;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RListMultimapCache;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RLock;
import org.redisson.api.RLongAdder;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RPriorityBlockingDeque;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RPriorityDeque;
import org.redisson.api.RPriorityQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RRemoteService;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScript;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RSetMultimapCache;
import org.redisson.api.RSortedSet;
import org.redisson.api.RStream;
import org.redisson.api.RTopic;
import org.redisson.api.RTransaction;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandExecutor;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.remote.ResponseEntry;
import org.redisson.transaction.RedissonTransaction;

public class Redisson
implements RedissonClient {
    protected final QueueTransferService queueTransferService = new QueueTransferService();
    protected final EvictionScheduler evictionScheduler;
    protected final ConnectionManager connectionManager;
    protected final ConcurrentMap<Class<?>, Class<?>> liveObjectClassCache = new ConcurrentHashMap();
    protected final Config config;
    protected final ConcurrentMap<String, ResponseEntry> responses = new ConcurrentHashMap<String, ResponseEntry>();

    protected Redisson(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        this.evictionScheduler = new EvictionScheduler(this.connectionManager.getCommandExecutor());
    }

    public EvictionScheduler getEvictionScheduler() {
        return this.evictionScheduler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.connectionManager.getCommandExecutor();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static RedissonClient create() {
        Config config = new Config();
        ((SingleServerConfig)config.useSingleServer().setTimeout(1000000)).setAddress("redis://127.0.0.1:6379");
        return Redisson.create(config);
    }

    public static RedissonClient create(Config config) {
        Redisson redisson = new Redisson(config);
        if (config.isReferenceEnabled()) {
            redisson.enableRedissonReferenceSupport();
        }
        return redisson;
    }

    public static RedissonRxClient createRx() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379");
        return Redisson.createRx(config);
    }

    public static RedissonRxClient createRx(Config config) {
        RedissonRx react = new RedissonRx(config);
        if (config.isReferenceEnabled()) {
            react.enableRedissonReferenceSupport();
        }
        return react;
    }

    public static RedissonReactiveClient createReactive() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379");
        return Redisson.createReactive(config);
    }

    public static RedissonReactiveClient createReactive(Config config) {
        RedissonReactive react = new RedissonReactive(config);
        if (config.isReferenceEnabled()) {
            react.enableRedissonReferenceSupport();
        }
        return react;
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name) {
        return new RedissonStream(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name, Codec codec) {
        return new RedissonStream(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RBinaryStream getBinaryStream(String name) {
        return new RedissonBinaryStream(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RGeo<V> getGeo(String name) {
        return new RedissonGeo(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RGeo<V> getGeo(String name, Codec codec) {
        return new RedissonGeo(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        return new RedissonBucket(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RRateLimiter getRateLimiter(String name) {
        return new RedissonRateLimiter(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RBucket<V> getBucket(String name, Codec codec) {
        return new RedissonBucket(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RBuckets getBuckets() {
        return new RedissonBuckets(this.connectionManager.getCommandExecutor());
    }

    @Override
    public RBuckets getBuckets(Codec codec) {
        return new RedissonBuckets(codec, this.connectionManager.getCommandExecutor());
    }

    @Override
    public <V> RHyperLogLog<V> getHyperLogLog(String name) {
        return new RedissonHyperLogLog(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RHyperLogLog<V> getHyperLogLog(String name, Codec codec) {
        return new RedissonHyperLogLog(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RList<V> getList(String name) {
        return new RedissonList(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RList<V> getList(String name, Codec codec) {
        return new RedissonList(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <K, V> RListMultimap<K, V> getListMultimap(String name) {
        return new RedissonListMultimap(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RListMultimap<K, V> getListMultimap(String name, Codec codec) {
        return new RedissonListMultimap(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, LocalCachedMapOptions<K, V> options) {
        return new RedissonLocalCachedMap<K, V>(this.connectionManager.getCommandExecutor(), name, options, this.evictionScheduler, this);
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, Codec codec, LocalCachedMapOptions<K, V> options) {
        return new RedissonLocalCachedMap<K, V>(codec, this.connectionManager.getCommandExecutor(), name, options, this.evictionScheduler, this);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        return new RedissonMap(this.connectionManager.getCommandExecutor(), name, this, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, MapOptions<K, V> options) {
        return new RedissonMap<K, V>(this.connectionManager.getCommandExecutor(), name, this, options);
    }

    @Override
    public <K, V> RSetMultimap<K, V> getSetMultimap(String name) {
        return new RedissonSetMultimap(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name) {
        return new RedissonSetMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name, Codec codec) {
        return new RedissonSetMultimapCache(this.evictionScheduler, codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name) {
        return new RedissonListMultimapCache(this.evictionScheduler, (CommandAsyncExecutor)this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name, Codec codec) {
        return new RedissonListMultimapCache(this.evictionScheduler, codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <K, V> RSetMultimap<K, V> getSetMultimap(String name, Codec codec) {
        return new RedissonSetMultimap(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name) {
        return new RedissonSetCache(this.evictionScheduler, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name, Codec codec) {
        return new RedissonSetCache(codec, this.evictionScheduler, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name) {
        return new RedissonMapCache(this.evictionScheduler, (CommandAsyncExecutor)this.connectionManager.getCommandExecutor(), name, (RedissonClient)this, null);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, MapOptions<K, V> options) {
        return new RedissonMapCache<K, V>(this.evictionScheduler, (CommandAsyncExecutor)this.connectionManager.getCommandExecutor(), name, (RedissonClient)this, options);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec) {
        return new RedissonMapCache(codec, this.evictionScheduler, this.connectionManager.getCommandExecutor(), name, this, null);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        return new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.connectionManager.getCommandExecutor(), name, this, options);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        return new RedissonMap(codec, this.connectionManager.getCommandExecutor(), name, this, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        return new RedissonMap<K, V>(codec, this.connectionManager.getCommandExecutor(), name, this, options);
    }

    @Override
    public RLock getLock(String name) {
        return new RedissonLock(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RLock getFairLock(String name) {
        return new RedissonFairLock(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RReadWriteLock getReadWriteLock(String name) {
        return new RedissonReadWriteLock(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        return new RedissonSet(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RSet<V> getSet(String name, Codec codec) {
        return new RedissonSet(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RScript getScript() {
        return new RedissonScript(this.connectionManager.getCommandExecutor());
    }

    @Override
    public RScript getScript(Codec codec) {
        return new RedissonScript(this.connectionManager.getCommandExecutor(), codec);
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name) {
        return this.getExecutorService(name, this.connectionManager.getCodec());
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, ExecutorOptions options) {
        return this.getExecutorService(name, this.connectionManager.getCodec(), options);
    }

    @Override
    @Deprecated
    public RScheduledExecutorService getExecutorService(Codec codec, String name) {
        return this.getExecutorService(name, codec);
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, Codec codec) {
        return this.getExecutorService(name, codec, ExecutorOptions.defaults());
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, Codec codec, ExecutorOptions options) {
        return new RedissonExecutorService(codec, this.connectionManager.getCommandExecutor(), this, name, this.queueTransferService, this.responses, options);
    }

    @Override
    public RRemoteService getRemoteService() {
        return this.getRemoteService("redisson_rs", this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(String name) {
        return this.getRemoteService(name, this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(Codec codec) {
        return this.getRemoteService("redisson_rs", codec);
    }

    @Override
    public RRemoteService getRemoteService(String name, Codec codec) {
        String executorId = codec == this.connectionManager.getCodec() ? this.connectionManager.getId().toString() : this.connectionManager.getId() + ":" + name;
        return new RedissonRemoteService(codec, (RedissonClient)this, name, this.connectionManager.getCommandExecutor(), executorId, this.responses);
    }

    @Override
    public <V> RSortedSet<V> getSortedSet(String name) {
        return new RedissonSortedSet(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RSortedSet<V> getSortedSet(String name, Codec codec) {
        return new RedissonSortedSet(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name) {
        return new RedissonScoredSortedSet(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name, Codec codec) {
        return new RedissonScoredSortedSet(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RLexSortedSet getLexSortedSet(String name) {
        return new RedissonLexSortedSet(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RTopic getTopic(String name) {
        return new RedissonTopic(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RTopic getTopic(String name, Codec codec) {
        return new RedissonTopic(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RPatternTopic getPatternTopic(String pattern) {
        return new RedissonPatternTopic(this.connectionManager.getCommandExecutor(), pattern);
    }

    @Override
    public RPatternTopic getPatternTopic(String pattern, Codec codec) {
        return new RedissonPatternTopic(codec, this.connectionManager.getCommandExecutor(), pattern);
    }

    @Override
    public <V> RDelayedQueue<V> getDelayedQueue(RQueue<V> destinationQueue) {
        if (destinationQueue == null) {
            throw new NullPointerException();
        }
        return new RedissonDelayedQueue(this.queueTransferService, destinationQueue.getCodec(), this.connectionManager.getCommandExecutor(), destinationQueue.getName());
    }

    @Override
    public <V> RQueue<V> getQueue(String name) {
        return new RedissonQueue(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RQueue<V> getQueue(String name, Codec codec) {
        return new RedissonQueue(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name) {
        return new RedissonBlockingQueue(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new RedissonBlockingQueue(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name) {
        return new RedissonBoundedBlockingQueue(this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name, Codec codec) {
        return new RedissonBoundedBlockingQueue(codec, this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RDeque<V> getDeque(String name) {
        return new RedissonDeque(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RDeque<V> getDeque(String name, Codec codec) {
        return new RedissonDeque(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name) {
        return new RedissonBlockingDeque(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name, Codec codec) {
        return new RedissonBlockingDeque(codec, this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RAtomicLong getAtomicLong(String name) {
        return new RedissonAtomicLong(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RLongAdder getLongAdder(String name) {
        return new RedissonLongAdder(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RDoubleAdder getDoubleAdder(String name) {
        return new RedissonDoubleAdder(this.connectionManager.getCommandExecutor(), name, this);
    }

    @Override
    public RAtomicDouble getAtomicDouble(String name) {
        return new RedissonAtomicDouble(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RCountDownLatch getCountDownLatch(String name) {
        return new RedissonCountDownLatch(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RBitSet getBitSet(String name) {
        return new RedissonBitSet(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RSemaphore getSemaphore(String name) {
        return new RedissonSemaphore(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(String name) {
        return new RedissonPermitExpirableSemaphore(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RBloomFilter<V> getBloomFilter(String name) {
        return new RedissonBloomFilter(this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public <V> RBloomFilter<V> getBloomFilter(String name, Codec codec) {
        return new RedissonBloomFilter(codec, this.connectionManager.getCommandExecutor(), name);
    }

    @Override
    public RKeys getKeys() {
        return new RedissonKeys(this.connectionManager.getCommandExecutor());
    }

    @Override
    public RTransaction createTransaction(TransactionOptions options) {
        return new RedissonTransaction(this.connectionManager.getCommandExecutor(), options);
    }

    @Override
    public RBatch createBatch(BatchOptions options) {
        RedissonBatch batch = new RedissonBatch(this.evictionScheduler, this.connectionManager, options);
        if (this.config.isReferenceEnabled()) {
            batch.enableRedissonReferenceSupport(this);
        }
        return batch;
    }

    @Override
    public RBatch createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RLiveObjectService getLiveObjectService() {
        return new RedissonLiveObjectService(this, this.liveObjectClassCache, this.connectionManager.getCommandExecutor());
    }

    @Override
    public void shutdown() {
        this.connectionManager.shutdown();
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        this.connectionManager.shutdown(quietPeriod, timeout, unit);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager);
    }

    @Override
    public ClusterNodesGroup getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson is not in cluster mode!");
        }
        return new RedisClusterNodes(this.connectionManager);
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.isShuttingDown();
    }

    protected void enableRedissonReferenceSupport() {
        this.connectionManager.getCommandExecutor().enableRedissonReferenceSupport(this);
    }

    @Override
    public <V> RPriorityQueue<V> getPriorityQueue(String name) {
        return new RedissonPriorityQueue(this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityQueue<V> getPriorityQueue(String name, Codec codec) {
        return new RedissonPriorityQueue(codec, this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name) {
        return new RedissonPriorityBlockingQueue(this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name, Codec codec) {
        return new RedissonPriorityBlockingQueue(codec, this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name) {
        return new RedissonPriorityBlockingDeque(this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name, Codec codec) {
        return new RedissonPriorityBlockingDeque(codec, this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityDeque<V> getPriorityDeque(String name) {
        return new RedissonPriorityDeque(this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    @Override
    public <V> RPriorityDeque<V> getPriorityDeque(String name, Codec codec) {
        return new RedissonPriorityDeque(codec, this.connectionManager.getCommandExecutor(), name, (RedissonClient)this);
    }

    static {
        RedissonReference.warmUp();
    }
}

