/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketGetAndSetOperation<V>
extends TransactionalOperation {
    private Object value;
    private String lockName;
    private String transactionId;

    public BucketGetAndSetOperation(String name, String lockName, Codec codec, Object value, String transactionId) {
        super(name, codec);
        this.value = value;
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<Object> bucket = new RedissonBucket<Object>(this.codec, commandExecutor, this.name);
        bucket.getAndSetAsync(this.value);
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync();
    }

    public Object getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }
}

