/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.pool;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ConnectionPool<T extends RedisConnection> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final List<ClientConnectionsEntry> entries = new CopyOnWriteArrayList<ClientConnectionsEntry>();
    final ConnectionManager connectionManager;
    final MasterSlaveServersConfig config;
    final MasterSlaveEntry masterSlaveEntry;

    public ConnectionPool(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry masterSlaveEntry) {
        this.config = config;
        this.masterSlaveEntry = masterSlaveEntry;
        this.connectionManager = connectionManager;
    }

    public RFuture<Void> add(final ClientConnectionsEntry entry) {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        promise.addListener((FutureListener)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    ConnectionPool.this.entries.add(entry);
                }
            }
        });
        this.initConnections(entry, promise, true);
        return promise;
    }

    public RPromise<Void> initConnections(ClientConnectionsEntry entry) {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        this.initConnections(entry, promise, false);
        return promise;
    }

    private void initConnections(ClientConnectionsEntry entry, RPromise<Void> initPromise, boolean checkFreezed) {
        int minimumIdleSize = this.getMinimumIdleSize(entry);
        if (minimumIdleSize == 0 || checkFreezed && entry.isFreezed()) {
            initPromise.trySuccess(null);
            return;
        }
        AtomicInteger initializedConnections = new AtomicInteger(minimumIdleSize);
        int startAmount = Math.min(50, minimumIdleSize);
        AtomicInteger requests = new AtomicInteger(startAmount);
        for (int i = 0; i < startAmount; ++i) {
            this.createConnection(checkFreezed, requests, entry, initPromise, minimumIdleSize, initializedConnections);
        }
    }

    private void createConnection(final boolean checkFreezed, final AtomicInteger requests, final ClientConnectionsEntry entry, final RPromise<Void> initPromise, final int minimumIdleSize, final AtomicInteger initializedConnections) {
        if (checkFreezed && entry.isFreezed() || !this.tryAcquireConnection(entry)) {
            int totalInitializedConnections = minimumIdleSize - initializedConnections.get();
            RedisConnectionException cause = new RedisConnectionException("Unable to init enough connections amount! Only " + totalInitializedConnections + " from " + minimumIdleSize + " were initialized. Server: " + entry.getClient().getAddr());
            initPromise.tryFailure(cause);
            return;
        }
        this.acquireConnection(entry, new Runnable(){

            @Override
            public void run() {
                RedissonPromise promise = new RedissonPromise();
                ConnectionPool.this.createConnection(entry, promise);
                promise.addListener(new FutureListener<T>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void operationComplete(Future<T> future) throws Exception {
                        if (future.isSuccess()) {
                            Iterator conn = (RedisConnection)future.getNow();
                            if (!initPromise.isDone()) {
                                ConnectionPool.this.releaseConnection(entry, conn);
                            } else {
                                ((RedisConnection)((Object)conn)).closeAsync();
                            }
                        }
                        ConnectionPool.this.releaseConnection(entry);
                        if (!future.isSuccess()) {
                            void var3_10;
                            if (initPromise.isDone()) {
                                return;
                            }
                            for (RedisConnection redisConnection : entry.getAllConnections()) {
                                if (redisConnection.isClosed()) continue;
                                redisConnection.closeAsync();
                            }
                            entry.getAllConnections().clear();
                            for (RedisConnection redisConnection : entry.getAllSubscribeConnections()) {
                                if (redisConnection.isClosed()) continue;
                                redisConnection.closeAsync();
                            }
                            entry.getAllSubscribeConnections().clear();
                            int totalInitializedConnections = minimumIdleSize - initializedConnections.get();
                            if (totalInitializedConnections == 0) {
                                String string = "Unable to connect to Redis server: " + entry.getClient().getAddr();
                            } else {
                                String string = "Unable to init enough connections amount! Only " + totalInitializedConnections + " from " + minimumIdleSize + " were initialized. Redis server: " + entry.getClient().getAddr();
                            }
                            RedisConnectionException cause = new RedisConnectionException((String)var3_10, future.cause());
                            initPromise.tryFailure(cause);
                            return;
                        }
                        int value = initializedConnections.decrementAndGet();
                        if (value == 0) {
                            if (initPromise.trySuccess(null)) {
                                ConnectionPool.this.log.info("{} connections initialized for {}", (Object)minimumIdleSize, (Object)entry.getClient().getAddr());
                            }
                        } else if (value > 0 && !initPromise.isDone() && requests.incrementAndGet() <= minimumIdleSize) {
                            ConnectionPool.this.createConnection(checkFreezed, requests, entry, initPromise, minimumIdleSize, initializedConnections);
                        }
                    }
                });
            }
        });
    }

    protected void acquireConnection(ClientConnectionsEntry entry, Runnable runnable) {
        entry.acquireConnection(runnable);
    }

    protected abstract int getMinimumIdleSize(ClientConnectionsEntry var1);

    public RFuture<T> get(RedisCommand<?> command) {
        LinkedList<ClientConnectionsEntry> entriesCopy = new LinkedList<ClientConnectionsEntry>(this.entries);
        Iterator iterator = entriesCopy.iterator();
        while (iterator.hasNext()) {
            ClientConnectionsEntry entry = (ClientConnectionsEntry)iterator.next();
            if ((!entry.isFreezed() || entry.isMasterForRead()) && this.tryAcquireConnection(entry)) continue;
            iterator.remove();
        }
        if (!entriesCopy.isEmpty()) {
            ClientConnectionsEntry entry = this.config.getLoadBalancer().getEntry(entriesCopy);
            return this.acquireConnection(command, entry);
        }
        LinkedList<InetSocketAddress> failed = new LinkedList<InetSocketAddress>();
        LinkedList<InetSocketAddress> freezed = new LinkedList<InetSocketAddress>();
        for (ClientConnectionsEntry entry : this.entries) {
            if (entry.isFailed()) {
                failed.add(entry.getClient().getAddr());
                continue;
            }
            if (!entry.isFreezed()) continue;
            freezed.add(entry.getClient().getAddr());
        }
        StringBuilder errorMsg = new StringBuilder(this.getClass().getSimpleName() + " no available Redis entries. ");
        if (!freezed.isEmpty()) {
            errorMsg.append(" Disconnected hosts: " + freezed);
        }
        if (!failed.isEmpty()) {
            errorMsg.append(" Hosts disconnected due to errors during `failedSlaveCheckInterval`: " + failed);
        }
        RedisConnectionException exception = new RedisConnectionException(errorMsg.toString());
        return RedissonPromise.newFailedFuture(exception);
    }

    public RFuture<T> get(RedisCommand<?> command, ClientConnectionsEntry entry) {
        return this.acquireConnection(command, entry);
    }

    protected final RFuture<T> acquireConnection(RedisCommand<?> command, final ClientConnectionsEntry entry) {
        final RedissonPromise result = new RedissonPromise();
        AcquireCallback callback = new AcquireCallback<T>(){

            @Override
            public void run() {
                result.removeListener((FutureListener)this);
                ConnectionPool.this.connectTo(entry, result);
            }

            @Override
            public void operationComplete(Future<T> future) throws Exception {
                entry.removeConnection(this);
            }
        };
        result.addListener((FutureListener)callback);
        this.acquireConnection(entry, callback);
        return result;
    }

    protected boolean tryAcquireConnection(ClientConnectionsEntry entry) {
        if (entry.getNodeType() == NodeType.SLAVE && entry.isFailed()) {
            this.checkForReconnect(entry, null);
            return false;
        }
        return true;
    }

    protected T poll(ClientConnectionsEntry entry) {
        return (T)entry.pollConnection();
    }

    protected RFuture<T> connect(ClientConnectionsEntry entry) {
        return entry.connect();
    }

    private void connectTo(ClientConnectionsEntry entry, RPromise<T> promise) {
        if (promise.isDone()) {
            this.releaseConnection(entry);
            return;
        }
        T conn = this.poll(entry);
        if (conn != null) {
            if (!((RedisConnection)conn).isActive() && entry.getNodeType() == NodeType.SLAVE) {
                entry.trySetupFistFail();
            }
            this.connectedSuccessful(entry, promise, conn);
            return;
        }
        this.createConnection(entry, promise);
    }

    private void createConnection(final ClientConnectionsEntry entry, final RPromise<T> promise) {
        RFuture<T> connFuture = this.connect(entry);
        connFuture.addListener(new FutureListener<T>(){

            @Override
            public void operationComplete(Future<T> future) throws Exception {
                if (!future.isSuccess()) {
                    ConnectionPool.this.promiseFailure(entry, (RPromise)promise, (Object)future.cause());
                    return;
                }
                RedisConnection conn = (RedisConnection)future.getNow();
                if (!conn.isActive()) {
                    ConnectionPool.this.promiseFailure(entry, promise, conn);
                    return;
                }
                ConnectionPool.this.connectedSuccessful(entry, promise, conn);
            }
        });
    }

    private void connectedSuccessful(ClientConnectionsEntry entry, RPromise<T> promise, T conn) {
        if (((RedisConnection)conn).isActive() && entry.getNodeType() == NodeType.SLAVE) {
            entry.resetFirstFail();
        }
        if (!promise.trySuccess(conn)) {
            this.releaseConnection(entry, conn);
            this.releaseConnection(entry);
        }
    }

    private void promiseFailure(ClientConnectionsEntry entry, RPromise<T> promise, Throwable cause) {
        if (entry.getNodeType() == NodeType.SLAVE) {
            entry.trySetupFistFail();
            if (entry.isFailed()) {
                this.checkForReconnect(entry, cause);
            }
        }
        this.releaseConnection(entry);
        promise.tryFailure(cause);
    }

    private void promiseFailure(ClientConnectionsEntry entry, RPromise<T> promise, T conn) {
        if (entry.getNodeType() == NodeType.SLAVE) {
            entry.trySetupFistFail();
            if (entry.isFailed()) {
                ((RedisConnection)conn).closeAsync();
                entry.getAllConnections().remove(conn);
                this.checkForReconnect(entry, null);
            } else {
                this.releaseConnection(entry, conn);
            }
        } else {
            this.releaseConnection(entry, conn);
        }
        this.releaseConnection(entry);
        RedisConnectionException cause = new RedisConnectionException(conn + " is not active!");
        promise.tryFailure(cause);
    }

    private void checkForReconnect(ClientConnectionsEntry entry, Throwable cause) {
        if (this.masterSlaveEntry.slaveDown(entry, ClientConnectionsEntry.FreezeReason.RECONNECT)) {
            this.log.error("slave " + entry.getClient().getAddr() + " has been disconnected after " + this.config.getFailedSlaveCheckInterval() + " ms interval since moment of the first failed connection", cause);
            this.scheduleCheck(entry);
        }
    }

    private void scheduleCheck(final ClientConnectionsEntry entry) {
        this.connectionManager.getConnectionEventsHub().fireDisconnect(entry.getClient().getAddr());
        this.connectionManager.newTimeout(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Timeout timeout) throws Exception {
                ClientConnectionsEntry clientConnectionsEntry = entry;
                synchronized (clientConnectionsEntry) {
                    if (entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.RECONNECT || !entry.isFreezed() || ConnectionPool.this.connectionManager.isShuttingDown()) {
                        return;
                    }
                }
                RFuture<RedisConnection> connectionFuture = entry.getClient().connectAsync();
                connectionFuture.addListener(new FutureListener<RedisConnection>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(Future<RedisConnection> future) throws Exception {
                        ClientConnectionsEntry clientConnectionsEntry = entry;
                        synchronized (clientConnectionsEntry) {
                            if (entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.RECONNECT || !entry.isFreezed()) {
                                return;
                            }
                        }
                        if (!future.isSuccess()) {
                            ConnectionPool.this.scheduleCheck(entry);
                            return;
                        }
                        final RedisConnection c = future.getNow();
                        if (!c.isActive()) {
                            c.closeAsync();
                            ConnectionPool.this.scheduleCheck(entry);
                            return;
                        }
                        final FutureListener<String> pingListener = new FutureListener<String>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             * Converted monitor instructions to comments
                             * Lifted jumps to return sites
                             */
                            @Override
                            public void operationComplete(Future<String> future) throws Exception {
                                try {
                                    ClientConnectionsEntry clientConnectionsEntry = entry;
                                    // MONITORENTER : clientConnectionsEntry
                                    if (entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.RECONNECT || !entry.isFreezed()) {
                                        // MONITOREXIT : clientConnectionsEntry
                                        return;
                                    }
                                    // MONITOREXIT : clientConnectionsEntry
                                    if (future.isSuccess() && "PONG".equals(future.getNow())) {
                                        if (!ConnectionPool.this.masterSlaveEntry.slaveUp(entry, ClientConnectionsEntry.FreezeReason.RECONNECT)) return;
                                        ConnectionPool.this.log.info("slave {} has been successfully reconnected", (Object)entry.getClient().getAddr());
                                        return;
                                    }
                                    ConnectionPool.this.scheduleCheck(entry);
                                    return;
                                }
                                finally {
                                    c.closeAsync();
                                }
                            }
                        };
                        if (entry.getConfig().getPassword() != null) {
                            RFuture temp = c.async(RedisCommands.AUTH, ConnectionPool.this.config.getPassword());
                            FutureListener<Void> listener = new FutureListener<Void>(){

                                @Override
                                public void operationComplete(Future<Void> future) throws Exception {
                                    ConnectionPool.this.ping(c, pingListener);
                                }
                            };
                            temp.addListener(listener);
                        } else {
                            ConnectionPool.this.ping(c, pingListener);
                        }
                    }
                });
            }
        }, this.config.getFailedSlaveReconnectionInterval(), TimeUnit.MILLISECONDS);
    }

    private void ping(RedisConnection c, FutureListener<String> pingListener) {
        RFuture f = c.async(RedisCommands.PING, new Object[0]);
        f.addListener(pingListener);
    }

    public void returnConnection(ClientConnectionsEntry entry, T connection) {
        if (entry.isFreezed() && entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.SYSTEM) {
            ((RedisConnection)connection).closeAsync();
            entry.getAllConnections().remove(connection);
        } else {
            this.releaseConnection(entry, connection);
        }
        this.releaseConnection(entry);
    }

    protected void releaseConnection(ClientConnectionsEntry entry) {
        entry.releaseConnection();
    }

    protected void releaseConnection(ClientConnectionsEntry entry, T conn) {
        entry.releaseConnection((RedisConnection)conn);
    }

    public static abstract class AcquireCallback<T>
    implements Runnable,
    FutureListener<T> {
    }
}

