/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class MapCacheEventCodec
implements Codec {
    private final Codec codec;
    private final boolean isWindows;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>(3);
            Object key = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapKeyDecoder());
            result.add(key);
            Object value = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
            result.add(value);
            if (buf.isReadable()) {
                Object oldValue = MapCacheEventCodec.this.decode(buf, state, MapCacheEventCodec.this.codec.getMapValueDecoder());
                result.add(oldValue);
            }
            return result;
        }
    };

    public MapCacheEventCodec(Codec codec, boolean isWindows) {
        this.codec = codec;
        this.isWindows = isWindows;
    }

    public MapCacheEventCodec(ClassLoader classLoader, MapCacheEventCodec codec) {
        try {
            this.codec = (Codec)codec.codec.getClass().getConstructor(ClassLoader.class, codec.codec.getClass()).newInstance(classLoader, codec.codec);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.isWindows = codec.isWindows;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException();
    }

    private Object decode(ByteBuf buf, State state, Decoder<?> decoder) throws IOException {
        int keyLen = this.isWindows ? buf.readIntLE() : (int)buf.readLongLE();
        ByteBuf keyBuf = buf.readSlice(keyLen);
        Object key = decoder.decode(keyBuf, state);
        return key;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codec == null ? 0 : this.codec.hashCode());
        result = 31 * result + (this.isWindows ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapCacheEventCodec other = (MapCacheEventCodec)obj;
        if (this.codec == null ? other.codec != null : !this.codec.equals(other.codec)) {
            return false;
        }
        return this.isWindows == other.isWindows;
    }
}

