/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.reactivex.Flowable;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.ReplayProcessor;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonMap;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.MapScanResult;

public class RedissonMapRxIterator<K, V, M> {
    private final RedissonMap<K, V> map;
    private final String pattern;
    private final int count;

    public RedissonMapRxIterator(RedissonMap<K, V> map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    public Flowable<M> create() {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) throws Exception {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues();
                    this.completed = false;
                }
            }

            protected void nextValues() {
                RedissonMapRxIterator.this.map.scanIteratorAsync(RedissonMapRxIterator.this.map.getName(), this.client, this.nextIterPos, RedissonMapRxIterator.this.pattern, RedissonMapRxIterator.this.count).addListener(new FutureListener<MapScanResult<Object, Object>>(){

                    @Override
                    public void operationComplete(Future<MapScanResult<Object, Object>> future) throws Exception {
                        if (!future.isSuccess()) {
                            p.onError(future.cause());
                            return;
                        }
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        MapScanResult<Object, Object> res = future.getNow();
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (Map.Entry<Object, Object> entry : res.getMap().entrySet()) {
                            Object val = RedissonMapRxIterator.this.getValue(entry);
                            p.onNext(val);
                            elementsRead.incrementAndGet();
                        }
                        if (elementsRead.get() >= readAmount.get()) {
                            p.onComplete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (res.getPos() == 0L && !RedissonMapRxIterator.this.tryAgain()) {
                            finished = true;
                            p.onComplete();
                        }
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    M getValue(final Map.Entry<Object, Object> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()){

            @Override
            public V setValue(V value) {
                return RedissonMapRxIterator.this.map.put(entry.getKey(), value);
            }
        };
    }
}

