/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

public abstract class PublisherAdder<V> {
    public abstract RFuture<Boolean> add(Object var1);

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        final CompletableFuture promise = new CompletableFuture();
        c.subscribe(new BaseSubscriber<V>(){
            volatile boolean completed;
            AtomicLong values = new AtomicLong();
            Subscription s;
            Boolean lastSize = false;

            @Override
            protected void hookOnSubscribe(Subscription s) {
                this.s = s;
                s.request(1L);
            }

            @Override
            protected void hookOnNext(V o) {
                this.values.getAndIncrement();
                PublisherAdder.this.add(o).addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            promise.completeExceptionally(future.cause());
                            return;
                        }
                        if (future.getNow().booleanValue()) {
                            lastSize = true;
                        }
                        s.request(1L);
                        if (values.decrementAndGet() == 0L && completed) {
                            promise.complete(lastSize);
                        }
                    }
                });
            }

            @Override
            protected void hookOnComplete() {
                this.completed = true;
                if (this.values.get() == 0L) {
                    promise.complete(this.lastSize);
                }
            }
        });
        return Mono.fromCompletionStage(promise);
    }
}

