/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommands;

@ChannelHandler.Sharable
public class PingConnectionHandler
extends ChannelInboundHandlerAdapter {
    private final RedisClientConfig config;

    public PingConnectionHandler(RedisClientConfig config) {
        this.config = config;
    }

    @Override
    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        ((RedisConnection)connection).getConnectionPromise().addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (future.isSuccess()) {
                    PingConnectionHandler.this.sendPing(ctx);
                }
            }
        });
        ctx.fireChannelActive();
    }

    protected void sendPing(ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        RFuture future = ((RedisConnection)connection).async(StringCodec.INSTANCE, RedisCommands.PING, new Object[0]);
        this.config.getTimer().newTimeout(new TimerTask((RedisConnection)connection, future, ctx){
            final /* synthetic */ RedisConnection val$connection;
            final /* synthetic */ RFuture val$future;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            {
                this.val$connection = redisConnection;
                this.val$future = rFuture;
                this.val$ctx = channelHandlerContext;
            }

            @Override
            public void run(Timeout timeout) throws Exception {
                CommandData commandData = this.val$connection.getCurrentCommand();
                if (!(commandData != null && commandData.isBlockingCommand() || !this.val$future.cancel(false) && this.val$future.isSuccess())) {
                    this.val$ctx.channel().close();
                } else {
                    PingConnectionHandler.this.sendPing(this.val$ctx);
                }
            }
        }, this.config.getPingConnectionInterval(), TimeUnit.MILLISECONDS);
    }
}

