/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefenceModule
extends SimpleModule {
    private static final long serialVersionUID = -429891510707420220L;

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addValueInstantiators(new DefenceValueInstantiator());
    }

    public static class DefenceValueInstantiator
    extends ValueInstantiators.Base {
        protected static final Set<String> DEFAULT_NO_DESER_CLASS_NAMES;

        @Override
        public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
            if (DEFAULT_NO_DESER_CLASS_NAMES.contains(beanDesc.getClassInfo().getRawType().getName())) {
                throw new IllegalArgumentException("Illegal type " + beanDesc.getClassInfo().getRawType().getName() + " to deserialize: prevented for security reasons");
            }
            return super.findValueInstantiator(config, beanDesc, defaultInstantiator);
        }

        static {
            HashSet<String> s = new HashSet<String>();
            s.add("org.apache.commons.collections.functors.InvokerTransformer");
            s.add("org.apache.commons.collections.functors.InstantiateTransformer");
            s.add("org.apache.commons.collections4.functors.InvokerTransformer");
            s.add("org.apache.commons.collections4.functors.InstantiateTransformer");
            s.add("org.codehaus.groovy.runtime.ConvertedClosure");
            s.add("org.codehaus.groovy.runtime.MethodClosure");
            s.add("org.springframework.beans.factory.ObjectFactory");
            s.add("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
            DEFAULT_NO_DESER_CLASS_NAMES = Collections.unmodifiableSet(s);
        }
    }
}

