/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMapCache;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheReactive;
import org.redisson.api.RMapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MapScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.NestedMultiDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.reactive.MapReactive;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.RedissonMapReactiveIterator;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.rx.Streams;

public class RedissonMapCacheReactive<K, V>
extends RedissonExpirableReactive
implements RMapCacheReactive<K, V>,
MapReactive<K, V> {
    private static final RedisCommand<MapScanResult<Object, Object>> EVAL_HSCAN = new RedisCommand<Object>("EVAL", new NestedMultiDecoder(new ObjectMapReplayDecoder(), new MapScanResultReplayDecoder()), RedisCommand.ValueType.MAP);
    private final RMapCache<K, V> mapCache;

    public RedissonMapCacheReactive(UUID id, EvictionScheduler evictionScheduler, CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.mapCache = new RedissonMapCache(evictionScheduler, (CommandAsyncExecutor)commandExecutor, name, null);
    }

    public RedissonMapCacheReactive(UUID id, EvictionScheduler evictionScheduler, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.mapCache = new RedissonMapCache(codec, evictionScheduler, commandExecutor, name, null);
    }

    @Override
    public Publisher<Boolean> containsKey(Object key) {
        return this.reactive(this.mapCache.containsKeyAsync(key));
    }

    @Override
    public Publisher<Boolean> containsValue(Object value) {
        return this.reactive(this.mapCache.containsValueAsync(value));
    }

    @Override
    public Publisher<Map<K, V>> getAll(Set<K> keys) {
        return this.reactive(this.mapCache.getAllAsync(keys));
    }

    @Override
    public Publisher<V> putIfAbsent(K key, V value, long ttl, TimeUnit unit) {
        return this.reactive(this.mapCache.putIfAbsentAsync(key, value, ttl, unit));
    }

    @Override
    public Publisher<Boolean> remove(Object key, Object value) {
        return this.reactive(this.mapCache.removeAsync(key, value));
    }

    @Override
    public Publisher<V> get(K key) {
        return this.reactive(this.mapCache.getAsync(key));
    }

    @Override
    public Publisher<V> put(K key, V value, long ttl, TimeUnit unit) {
        return this.reactive(this.mapCache.putAsync(key, value, ttl, unit));
    }

    String getTimeoutSetName() {
        return "redisson__timeout__set__{" + this.getName() + "}";
    }

    @Override
    public Publisher<V> remove(K key) {
        return this.reactive(this.mapCache.removeAsync(key));
    }

    @Override
    public Publisher<Long> fastRemove(K ... keys) {
        return this.reactive(this.mapCache.fastRemoveAsync(keys));
    }

    @Override
    public Publisher<MapScanResult<ScanObjectEntry, ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.reactive(((RedissonMapCache)this.mapCache).scanIteratorAsync(this.getName(), client, startPos));
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.reactive(this.mapCache.deleteAsync());
    }

    @Override
    public Publisher<Boolean> expire(long timeToLive, TimeUnit timeUnit) {
        return this.reactive(this.mapCache.expireAsync(timeToLive, timeUnit));
    }

    @Override
    public Publisher<Boolean> expireAt(long timestamp) {
        return this.reactive(this.mapCache.expireAtAsync(timestamp));
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.reactive(this.mapCache.clearExpireAsync());
    }

    @Override
    public Publisher<Void> putAll(Map<? extends K, ? extends V> map) {
        return this.reactive(this.mapCache.putAllAsync(map));
    }

    @Override
    public Publisher<V> addAndGet(K key, Number delta) {
        return this.reactive(this.mapCache.addAndGetAsync(key, delta));
    }

    @Override
    public Publisher<Boolean> fastPut(K key, V value) {
        return this.reactive(this.mapCache.fastPutAsync(key, value));
    }

    @Override
    public Publisher<V> put(K key, V value) {
        return this.reactive(this.mapCache.putAsync(key, value));
    }

    @Override
    public Publisher<V> replace(K key, V value) {
        return this.reactive(this.mapCache.replaceAsync(key, value));
    }

    @Override
    public Publisher<Boolean> replace(K key, V oldValue, V newValue) {
        return this.reactive(this.mapCache.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public Publisher<V> putIfAbsent(K key, V value) {
        return this.reactive(this.mapCache.putIfAbsentAsync(key, value));
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator() {
        return new RedissonMapReactiveIterator(this).stream();
    }

    @Override
    public Publisher<V> valueIterator() {
        return new RedissonMapReactiveIterator<K, V, V>(this){

            @Override
            V getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getValue().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<K> keyIterator() {
        return new RedissonMapReactiveIterator<K, V, K>(this){

            @Override
            K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(this.mapCache.sizeAsync());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != Streams.create(this.size()).next().poll().intValue()) {
                return false;
            }
            return Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce(true, this.booleanAnd()).next().poll();
        }
        if (o instanceof RMapReactive) {
            RMapReactive m = (RMapReactive)o;
            if (Streams.create(m.size()).next().poll() != Streams.create(this.size()).next().poll()) {
                return false;
            }
            return Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce(true, this.booleanAnd()).next().poll();
        }
        return true;
    }

    private BiFunction<Boolean, Boolean, Boolean> booleanAnd() {
        return new BiFunction<Boolean, Boolean, Boolean>(){

            @Override
            public Boolean apply(Boolean t, Boolean u) {
                return t & u;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final Map<?, ?> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                return true;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final RMapReactive<Object, Object> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            @Override
            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? Streams.create(m.get(key)).next().poll() != null || Streams.create(m.containsKey(key)).next().poll() == false : !value.equals(Streams.create(m.get(key)).next().poll())) {
                    return false;
                }
                return true;
            }
        };
    }

    public int hashCode() {
        return Streams.create(this.entryIterator()).map(new Function<Map.Entry<K, V>, Integer>(){

            @Override
            public Integer apply(Map.Entry<K, V> t) {
                return t.hashCode();
            }
        }).reduce(0, new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        }).next().poll();
    }
}

