/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.client.RedisConnectionException;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<InetAddress> currentMaster = new AtomicReference();
    private ScheduledFuture<?> monitorFuture;

    public SingleConnectionManager(SingleServerConfig cfg, Config config) {
        super(SingleConnectionManager.create(cfg), config);
        if (cfg.isDnsMonitoring()) {
            try {
                this.currentMaster.set(InetAddress.getByName(cfg.getAddress().getHost()));
            }
            catch (UnknownHostException e) {
                throw new RedisConnectionException("Unknown host: " + cfg.getAddress().getHost(), e);
            }
            this.log.debug("DNS monitoring enabled; Current master set to {}", (Object)this.currentMaster.get());
            this.monitorDnsChange(cfg);
        }
    }

    private static MasterSlaveServersConfig create(SingleServerConfig cfg) {
        MasterSlaveServersConfig newconfig = new MasterSlaveServersConfig();
        newconfig.setSslEnableEndpointIdentification(cfg.isSslEnableEndpointIdentification());
        newconfig.setSslProvider(cfg.getSslProvider());
        newconfig.setSslTruststore(cfg.getSslTruststore());
        newconfig.setSslTruststorePassword(cfg.getSslTruststorePassword());
        newconfig.setSslKeystore(cfg.getSslKeystore());
        newconfig.setSslKeystorePassword(cfg.getSslKeystorePassword());
        newconfig.setRetryAttempts(cfg.getRetryAttempts());
        newconfig.setRetryInterval(cfg.getRetryInterval());
        newconfig.setTimeout(cfg.getTimeout());
        newconfig.setPingTimeout(cfg.getPingTimeout());
        newconfig.setPassword(cfg.getPassword());
        newconfig.setDatabase(cfg.getDatabase());
        newconfig.setClientName(cfg.getClientName());
        newconfig.setMasterAddress(cfg.getAddress());
        newconfig.setMasterConnectionPoolSize(cfg.getConnectionPoolSize());
        newconfig.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        newconfig.setSubscriptionConnectionPoolSize(cfg.getSubscriptionConnectionPoolSize());
        newconfig.setConnectTimeout(cfg.getConnectTimeout());
        newconfig.setIdleConnectionTimeout(cfg.getIdleConnectionTimeout());
        newconfig.setFailedAttempts(cfg.getFailedAttempts());
        newconfig.setReconnectionTimeout(cfg.getReconnectionTimeout());
        newconfig.setMasterConnectionMinimumIdleSize(cfg.getConnectionMinimumIdleSize());
        newconfig.setSubscriptionConnectionMinimumIdleSize(cfg.getSubscriptionConnectionMinimumIdleSize());
        newconfig.setReadMode(ReadMode.MASTER);
        newconfig.setSubscriptionMode(SubscriptionMode.MASTER);
        return newconfig;
    }

    private void monitorDnsChange(final SingleServerConfig cfg) {
        this.monitorFuture = GlobalEventExecutor.INSTANCE.schedule(new Runnable(){

            @Override
            public void run() {
                SingleConnectionManager.this.getExecutor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InetAddress master = (InetAddress)SingleConnectionManager.this.currentMaster.get();
                            InetAddress now = InetAddress.getByName(cfg.getAddress().getHost());
                            if (!now.getHostAddress().equals(master.getHostAddress())) {
                                SingleConnectionManager.this.log.info("Detected DNS change. {} has changed from {} to {}", cfg.getAddress().getHost(), master.getHostAddress(), now.getHostAddress());
                                if (SingleConnectionManager.this.currentMaster.compareAndSet(master, now)) {
                                    SingleConnectionManager.this.changeMaster(SingleConnectionManager.this.singleSlotRange.getStartSlot(), cfg.getAddress());
                                    SingleConnectionManager.this.log.info("Master has been changed");
                                }
                            }
                        }
                        catch (Exception e) {
                            SingleConnectionManager.this.log.error(e.getMessage(), e);
                        }
                        finally {
                            SingleConnectionManager.this.monitorDnsChange(cfg);
                        }
                    }
                });
            }
        }, cfg.getDnsMonitoringInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        super.shutdown();
    }
}

