/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSet;
import org.redisson.api.RSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;

public class RedissonSetReactive<V>
extends RedissonExpirableReactive
implements RSetReactive<V> {
    private final RedissonSet<V> instance;

    public RedissonSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonSet(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name, null);
    }

    public RedissonSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonSet(codec, commandExecutor, name, null);
    }

    @Override
    public Publisher<Long> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this).addAll(c);
    }

    @Override
    public Publisher<Long> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.SCARD, this.getName());
    }

    @Override
    public Publisher<Boolean> contains(Object o) {
        return this.reactive(this.instance.containsAsync(o));
    }

    private Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), new ScanCodec(this.codec), RedisCommands.SSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<Long> add(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, this.getName(), e);
    }

    @Override
    public Publisher<V> removeRandom() {
        return this.reactive(this.instance.removeRandomAsync());
    }

    @Override
    public Publisher<V> random() {
        return this.reactive(this.instance.randomAsync());
    }

    @Override
    public Publisher<Boolean> remove(Object o) {
        return this.reactive(this.instance.removeAsync(o));
    }

    @Override
    public Publisher<Boolean> move(String destination, V member) {
        return this.reactive(this.instance.moveAsync(destination, member));
    }

    @Override
    public Publisher<Boolean> containsAll(Collection<?> c) {
        return this.reactive(this.instance.containsAllAsync(c));
    }

    @Override
    public Publisher<Long> addAll(Collection<? extends V> c) {
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, args.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(Collection<?> c) {
        return this.reactive(this.instance.retainAllAsync(c));
    }

    @Override
    public Publisher<Boolean> removeAll(Collection<?> c) {
        return this.reactive(this.instance.removeAllAsync(c));
    }

    @Override
    public Publisher<Set<V>> readIntersection(String ... names) {
        return this.reactive(this.instance.readIntersectionAsync(names));
    }

    @Override
    public Publisher<Long> intersection(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SINTERSTORE, args.toArray());
    }

    @Override
    public Publisher<Long> diff(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SDIFFSTORE, args.toArray());
    }

    @Override
    public Publisher<Long> union(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SUNIONSTORE, args.toArray());
    }

    @Override
    public Publisher<Set<V>> readUnion(String ... names) {
        return this.reactive(this.instance.readUnionAsync(names));
    }

    @Override
    public Publisher<V> iterator() {
        return new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long nextIterPos) {
                return RedissonSetReactive.this.scanIteratorReactive(client, nextIterPos);
            }
        };
    }
}

